package com.wassilak.cache_service.entity;

/**
 * The EntityException class represents any exceptions that occurred while trying to create or interact with Entity
 * objects.
 * <p>
 * Copyright (C) 2014 John Wassilak (john@wassilak.com)
 * <p>
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * <p>
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * <p>
 * You should have received a copy of the GNU General Public License along with this program. If not, see
 * http://www.gnu.org/licenses/.
 */
public final class EntityException extends Exception {

    /**
     * The serialVersionUID constant represents the current serialization version of this class.
     */
    private static final long serialVersionUID = -728283373375731583L;

    /**
     * The EntityException constructor appends the given message to the exception passed to the caller.
     *
     * @param message
     *            The message to be included in the exception.
     */
    public EntityException(String message) {
        super(message);
    }
}
