package com.wassilak.cache_service.entity;

import java.io.Serializable;
import java.util.Date;

/**
 * The Entity interface defines the behavior of the cache-service Entity object, which represents cached objects.
 * <p>
 * Copyright (C) 2014 John Wassilak (john@wassilak.com)
 * <p>
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * <p>
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * <p>
 * You should have received a copy of the GNU General Public License along with this program. If not, see
 * http://www.gnu.org/licenses/.
 * 
 * @param <T>
 *            The type of object that this Entity represents in a Cache.
 */
public interface Entity<T> extends Serializable {

    /**
     * The MIN_TTL constant represents the minimum allowable value of an Entity's timeToLive property.
     */
    public static final Long MIN_TTL = 0L;

    /**
     * The MAX_TTL constant represents the maximum allowable value of an Entity's timeToLive property.
     */
    public static final Long MAX_TTL = Long.MAX_VALUE - 1;

    /**
     * The getObject method returns the underlying object that this cache Entity represents.
     * 
     * @return The cached object.
     */
    public T getObject();

    /**
     * The getTimeStamp method returns the date/time that the entity was created. This is used in determining whether or
     * not the Entity should be considered expired and removed from the cache.
     *
     * @return The date/time that the Entity was created.
     */
    public Date getTimeStamp();

    /**
     * The getTimeToLive method returns the time that the Entity can live before it should be removed from the cache, in
     * milliseconds.
     *
     * @return The length of time before the Entity should expire and be removed from the cache.
     */
    public Long getTimeToLive();
}
