package com.wassilak.cache_service.cache;

/**
 * The CacheFactory class gives users the ability to create Cache objects.
 * <p>
 * Copyright (C) 2014 John Wassilak (john@wassilak.com)
 * <p>
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * <p>
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * <p>
 * You should have received a copy of the GNU General Public License along with this program. If not, see
 * http://www.gnu.org/licenses/.
 */
public final class CacheFactory {

    /**
     * The CacheFactory constructor ensures that the CacheFactory class cannot be instantiated. It is package private to
     * allow testing.
     */
    CacheFactory() {
        throw new IllegalStateException("This class should not be instantiated.");
    }

    /**
     * The createCache method creates a Cache object for the implied types.
     * 
     * @param <K>
     *            The type of Keys the Cache should accept.
     * @param <V>
     *            The type of Entities the Cache should accept.
     * @return A cache object for the implied types.
     */
    public static <K, V> Cache<K, V> createCache() {
        return new CacheImpl<K, V>();
    }
}
