/*
 * Decompiled with CFR 0.152.
 */
package com.warrenstrange.googleauth;

import com.warrenstrange.googleauth.GoogleAuthenticatorConfig;
import com.warrenstrange.googleauth.GoogleAuthenticatorException;
import com.warrenstrange.googleauth.GoogleAuthenticatorKey;
import com.warrenstrange.googleauth.ICredentialRepository;
import com.warrenstrange.googleauth.IGoogleAuthenticator;
import com.warrenstrange.googleauth.ReseedingSecureRandom;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.codec.binary.Base64;

public final class GoogleAuthenticator
implements IGoogleAuthenticator {
    public static final String RNG_ALGORITHM = "com.warrenstrange.googleauth.rng.algorithm";
    public static final String RNG_ALGORITHM_PROVIDER = "com.warrenstrange.googleauth.rng.algorithmProvider";
    private static final Logger LOGGER = Logger.getLogger(GoogleAuthenticator.class.getName());
    private static final int SECRET_BITS = 80;
    private static final int SCRATCH_CODE_LENGTH = 8;
    public static final int SCRATCH_CODE_MODULUS = (int)Math.pow(10.0, 8.0);
    private static final int SCRATCH_CODE_INVALID = -1;
    private static final int BYTES_PER_SCRATCH_CODE = 4;
    private static final String DEFAULT_RANDOM_NUMBER_ALGORITHM = "SHA1PRNG";
    private static final String DEFAULT_RANDOM_NUMBER_ALGORITHM_PROVIDER = "SUN";
    private final GoogleAuthenticatorConfig config;
    private ReseedingSecureRandom secureRandom = new ReseedingSecureRandom(this.getRandomNumberAlgorithm(), this.getRandomNumberAlgorithmProvider());
    private ICredentialRepository credentialRepository;
    private boolean credentialRepositorySearched;

    public GoogleAuthenticator() {
        this.config = new GoogleAuthenticatorConfig();
    }

    public GoogleAuthenticator(GoogleAuthenticatorConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("Configuration cannot be null.");
        }
        this.config = config;
    }

    private String getRandomNumberAlgorithm() {
        return System.getProperty(RNG_ALGORITHM, DEFAULT_RANDOM_NUMBER_ALGORITHM);
    }

    private String getRandomNumberAlgorithmProvider() {
        return System.getProperty(RNG_ALGORITHM_PROVIDER, DEFAULT_RANDOM_NUMBER_ALGORITHM_PROVIDER);
    }

    int calculateCode(byte[] key, long tm) {
        byte[] data = new byte[8];
        long value = tm;
        int i = 8;
        while (i-- > 0) {
            data[i] = (byte)value;
            value >>>= 8;
        }
        SecretKeySpec signKey = new SecretKeySpec(key, this.config.getHmacHashFunction().toString());
        try {
            Mac mac = Mac.getInstance(this.config.getHmacHashFunction().toString());
            mac.init(signKey);
            byte[] hash = mac.doFinal(data);
            int offset = hash[hash.length - 1] & 0xF;
            long truncatedHash = 0L;
            for (int i2 = 0; i2 < 4; ++i2) {
                truncatedHash <<= 8;
                truncatedHash |= (long)(hash[offset + i2] & 0xFF);
            }
            truncatedHash &= Integer.MAX_VALUE;
            return (int)(truncatedHash %= (long)this.config.getKeyModulus());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
            throw new GoogleAuthenticatorException("The operation cannot be performed now.");
        }
    }

    private long getTimeWindowFromTime(long time) {
        return time / this.config.getTimeStepSizeInMillis();
    }

    private boolean checkCode(String secret, long code, long timestamp, int window) {
        byte[] decodedKey = this.decodeSecret(secret);
        long timeWindow = this.getTimeWindowFromTime(timestamp);
        for (int i = -((window - 1) / 2); i <= window / 2; ++i) {
            long hash = this.calculateCode(decodedKey, timeWindow + (long)i);
            if (hash != code) continue;
            return true;
        }
        return false;
    }

    private byte[] decodeSecret(String secret) {
        switch (this.config.getKeyRepresentation()) {
            case BASE32: {
                Base32 codec32 = new Base32();
                return codec32.decode(secret.toUpperCase());
            }
            case BASE64: {
                Base64 codec64 = new Base64();
                return codec64.decode(secret);
            }
        }
        throw new IllegalArgumentException("Unknown key representation type.");
    }

    @Override
    public GoogleAuthenticatorKey createCredentials() {
        byte[] buffer = new byte[10];
        this.secureRandom.nextBytes(buffer);
        byte[] secretKey = Arrays.copyOf(buffer, 10);
        String generatedKey = this.calculateSecretKey(secretKey);
        int validationCode = this.calculateValidationCode(secretKey);
        List<Integer> scratchCodes = this.calculateScratchCodes();
        return new GoogleAuthenticatorKey.Builder(generatedKey).setConfig(this.config).setVerificationCode(validationCode).setScratchCodes(scratchCodes).build();
    }

    @Override
    public GoogleAuthenticatorKey createCredentials(String userName) {
        if (userName == null) {
            throw new IllegalArgumentException("User name cannot be null.");
        }
        GoogleAuthenticatorKey key = this.createCredentials();
        ICredentialRepository repository = this.getValidCredentialRepository();
        repository.saveUserCredentials(userName, key.getKey(), key.getVerificationCode(), key.getScratchCodes());
        return key;
    }

    private List<Integer> calculateScratchCodes() {
        ArrayList<Integer> scratchCodes = new ArrayList<Integer>();
        for (int i = 0; i < this.config.getNumberOfScratchCodes(); ++i) {
            scratchCodes.add(this.generateScratchCode());
        }
        return scratchCodes;
    }

    private int calculateScratchCode(byte[] scratchCodeBuffer) {
        if (scratchCodeBuffer.length < 4) {
            throw new IllegalArgumentException(String.format("The provided random byte buffer is too small: %d.", scratchCodeBuffer.length));
        }
        int scratchCode = 0;
        for (int i = 0; i < 4; ++i) {
            scratchCode = (scratchCode << 8) + (scratchCodeBuffer[i] & 0xFF);
        }
        if (this.validateScratchCode(scratchCode = (scratchCode & Integer.MAX_VALUE) % SCRATCH_CODE_MODULUS)) {
            return scratchCode;
        }
        return -1;
    }

    boolean validateScratchCode(int scratchCode) {
        return scratchCode >= SCRATCH_CODE_MODULUS / 10;
    }

    private int generateScratchCode() {
        byte[] scratchCodeBuffer;
        int scratchCode;
        do {
            scratchCodeBuffer = new byte[4];
            this.secureRandom.nextBytes(scratchCodeBuffer);
        } while ((scratchCode = this.calculateScratchCode(scratchCodeBuffer)) == -1);
        return scratchCode;
    }

    private int calculateValidationCode(byte[] secretKey) {
        return this.calculateCode(secretKey, 0L);
    }

    @Override
    public int getTotpPassword(String secret) {
        return this.getTotpPassword(secret, new Date().getTime());
    }

    @Override
    public int getTotpPassword(String secret, long time) {
        return this.calculateCode(this.decodeSecret(secret), this.getTimeWindowFromTime(time));
    }

    @Override
    public int getTotpPasswordOfUser(String userName) {
        return this.getTotpPasswordOfUser(userName, new Date().getTime());
    }

    @Override
    public int getTotpPasswordOfUser(String userName, long time) {
        ICredentialRepository repository = this.getValidCredentialRepository();
        return this.calculateCode(this.decodeSecret(repository.getSecretKey(userName)), this.getTimeWindowFromTime(time));
    }

    private String calculateSecretKey(byte[] secretKey) {
        switch (this.config.getKeyRepresentation()) {
            case BASE32: {
                return new Base32().encodeToString(secretKey);
            }
            case BASE64: {
                return new Base64().encodeToString(secretKey);
            }
        }
        throw new IllegalArgumentException("Unknown key representation type.");
    }

    @Override
    public boolean authorize(String secret, int verificationCode) throws GoogleAuthenticatorException {
        return this.authorize(secret, verificationCode, new Date().getTime());
    }

    @Override
    public boolean authorize(String secret, int verificationCode, long time) throws GoogleAuthenticatorException {
        if (secret == null) {
            throw new IllegalArgumentException("Secret cannot be null.");
        }
        if (verificationCode <= 0 || verificationCode >= this.config.getKeyModulus()) {
            return false;
        }
        return this.checkCode(secret, verificationCode, time, this.config.getWindowSize());
    }

    @Override
    public boolean authorizeUser(String userName, int verificationCode) throws GoogleAuthenticatorException {
        return this.authorizeUser(userName, verificationCode, new Date().getTime());
    }

    @Override
    public boolean authorizeUser(String userName, int verificationCode, long time) throws GoogleAuthenticatorException {
        ICredentialRepository repository = this.getValidCredentialRepository();
        return this.authorize(repository.getSecretKey(userName), verificationCode, time);
    }

    private ICredentialRepository getValidCredentialRepository() {
        ICredentialRepository repository = this.getCredentialRepository();
        if (repository == null) {
            throw new UnsupportedOperationException(String.format("An instance of the %s service must be configured in order to use this feature.", ICredentialRepository.class.getName()));
        }
        return repository;
    }

    @Override
    public ICredentialRepository getCredentialRepository() {
        block1: {
            ICredentialRepository repository;
            if (this.credentialRepositorySearched) {
                return this.credentialRepository;
            }
            this.credentialRepositorySearched = true;
            ServiceLoader<ICredentialRepository> loader = ServiceLoader.load(ICredentialRepository.class);
            Iterator<ICredentialRepository> iterator = loader.iterator();
            if (!iterator.hasNext()) break block1;
            this.credentialRepository = repository = iterator.next();
        }
        return this.credentialRepository;
    }

    @Override
    public void setCredentialRepository(ICredentialRepository repository) {
        this.credentialRepository = repository;
        this.credentialRepositorySearched = true;
    }
}

