/*
 * Decompiled with CFR 0.152.
 */
package webview.video.com.h5videowebview;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.app.Activity;
import android.content.Context;
import android.net.http.SslError;
import android.os.Build;
import android.os.Handler;
import android.support.annotation.DrawableRes;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Property;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.SslErrorHandler;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import webview.video.com.h5videowebview.R;

public class H5VideoWebView
extends WebView {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    private static final int DEFAULT_MARGIN = 20;
    private static final String COM = "com";
    private final FrameLayout.LayoutParams FULL_SCREEN_PARAMS = new FrameLayout.LayoutParams(-1, -1);
    private Activity mActivity;
    private View mCustomView;
    private WebChromeClient.CustomViewCallback mCustomViewCallBack;
    private FrameLayout mFullContainerView;
    private View mTitleView;
    private boolean mIsShowTitleView = true;
    private int mLocation = 0;
    private int mHeight;
    private int mTitleViewBackground;
    private int mTitleColor;
    private int mTitleSize;
    private String mTitle;
    private int mResourceId = -1;
    private boolean mTitleShow = false;
    private ObjectAnimator mShowAnimator;
    private ObjectAnimator mHideAnimator;
    private float mShowAlpha = 0.0f;
    private int mBackMargin = 20;
    private int mTitleMargin = 20;
    private Handler mHandler;
    private Runnable mHideRun;

    public H5VideoWebView(Context context) {
        super(context);
        if (!(context instanceof Activity)) {
            throw new IllegalArgumentException("context must be Activity");
        }
        this.mActivity = (Activity)context;
        this.initWebView();
    }

    public H5VideoWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (!(context instanceof Activity)) {
            throw new IllegalArgumentException("context must be Activity");
        }
        this.mActivity = (Activity)context;
        this.initWebView();
    }

    public H5VideoWebView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (!(context instanceof Activity)) {
            throw new IllegalArgumentException("context must be Activity");
        }
        this.mActivity = (Activity)context;
        this.initWebView();
    }

    private void initWebView() {
        this.initDefaultParam();
        WebSettings webSettings = this.getSettings();
        webSettings.setSupportZoom(true);
        webSettings.setMediaPlaybackRequiresUserGesture(true);
        webSettings.setBuiltInZoomControls(true);
        webSettings.setDisplayZoomControls(true);
        webSettings.setAllowFileAccess(true);
        webSettings.setAllowContentAccess(true);
        webSettings.setLoadWithOverviewMode(true);
        webSettings.setTextZoom(100);
        webSettings.setUseWideViewPort(true);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setLoadsImagesAutomatically(true);
        webSettings.setBlockNetworkImage(false);
        webSettings.setBlockNetworkLoads(false);
        webSettings.setJavaScriptEnabled(true);
        webSettings.setPluginState(WebSettings.PluginState.ON);
        webSettings.setDomStorageEnabled(true);
        webSettings.setGeolocationEnabled(true);
        webSettings.setCacheMode(-1);
        webSettings.setBuiltInZoomControls(true);
        if (Build.VERSION.SDK_INT >= 21) {
            webSettings.setMixedContentMode(2);
        }
        WebViewClient client = new WebViewClient(){

            public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
                handler.proceed();
                super.onReceivedSslError(view, handler, error);
            }
        };
        this.setWebViewClient(client);
        WebChromeClient chromeClient = new WebChromeClient(){

            @Nullable
            public View getVideoLoadingProgressView() {
                return super.getVideoLoadingProgressView();
            }

            public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
                H5VideoWebView.this.showCustomView(view, callback);
                H5VideoWebView.this.mActivity.setRequestedOrientation(0);
            }

            public void onHideCustomView() {
                H5VideoWebView.this.hideCustomView();
                H5VideoWebView.this.mActivity.setRequestedOrientation(1);
            }
        };
        this.setWebChromeClient(chromeClient);
    }

    private void initDefaultParam() {
        this.mHeight = this.dip2px(44.0f);
        this.mTitleViewBackground = this.mActivity.getResources().getColor(R.color.colorGray);
        this.mTitleColor = this.mActivity.getResources().getColor(R.color.colorWhite);
        this.mTitleSize = 14;
    }

    private void showCustomView(View view, WebChromeClient.CustomViewCallback callback) {
        if (this.mCustomView != null) {
            if (callback != null) {
                callback.onCustomViewHidden();
            }
            return;
        }
        FrameLayout decorView = (FrameLayout)this.mActivity.getWindow().getDecorView();
        decorView.setBackgroundColor(-16777216);
        this.mFullContainerView = new FrameLayout((Context)this.mActivity){

            public boolean dispatchTouchEvent(MotionEvent ev) {
                if (ev.getAction() == 0 && H5VideoWebView.this.mTitleView != null) {
                    if (!H5VideoWebView.this.mTitleShow) {
                        H5VideoWebView.this.mTitleShow = true;
                        if (H5VideoWebView.this.mHideAnimator != null) {
                            H5VideoWebView.this.mHideAnimator.cancel();
                        }
                        H5VideoWebView.this.mShowAnimator = ObjectAnimator.ofFloat((Object)H5VideoWebView.this.mTitleView, (Property)3.ALPHA, (float[])new float[]{H5VideoWebView.this.mShowAlpha, 1.0f});
                        H5VideoWebView.this.mShowAnimator.setDuration(1000L);
                        H5VideoWebView.this.mShowAnimator.start();
                        H5VideoWebView.this.hideTitleView();
                    } else {
                        H5VideoWebView.this.mTitleShow = false;
                        if (H5VideoWebView.this.mShowAnimator != null) {
                            H5VideoWebView.this.mShowAnimator.cancel();
                        }
                        H5VideoWebView.this.mHideAnimator = ObjectAnimator.ofFloat((Object)H5VideoWebView.this.mTitleView, (Property)3.ALPHA, (float[])new float[]{1.0f, 0.0f});
                        H5VideoWebView.this.mHideAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                            public void onAnimationEnd(Animator animation) {
                                H5VideoWebView.this.mShowAlpha = ((Float)((ObjectAnimator)animation).getAnimatedValue()).floatValue();
                                super.onAnimationEnd(animation);
                            }
                        });
                        H5VideoWebView.this.mHideAnimator.setDuration(1000L);
                        H5VideoWebView.this.mHideAnimator.start();
                        if (H5VideoWebView.this.mHideRun != null) {
                            H5VideoWebView.this.mHandler.removeCallbacks(H5VideoWebView.this.mHideRun);
                        }
                    }
                }
                return super.dispatchTouchEvent(ev);
            }
        };
        this.mFullContainerView.setBackgroundColor(-16777216);
        this.mFullContainerView.addView(view, (ViewGroup.LayoutParams)this.FULL_SCREEN_PARAMS);
        if (this.mIsShowTitleView) {
            if (this.mTitleView == null) {
                this.mTitleView = this.createTitleView();
            }
            this.mFullContainerView.addView(this.mTitleView);
            this.mTitleShow = true;
            this.hideTitleView();
        }
        decorView.addView((View)this.mFullContainerView, (ViewGroup.LayoutParams)this.FULL_SCREEN_PARAMS);
        this.mCustomView = view;
        this.setStatusBarVisibility(false);
        this.mCustomViewCallBack = callback;
    }

    private void hideCustomView() {
        if (this.mCustomView == null) {
            return;
        }
        this.setStatusBarVisibility(true);
        FrameLayout decorView = (FrameLayout)this.mActivity.getWindow().getDecorView();
        decorView.removeView((View)this.mFullContainerView);
        this.mFullContainerView = null;
        this.mCustomView = null;
        this.mCustomViewCallBack.onCustomViewHidden();
        this.mTitleView = null;
        this.mTitleShow = false;
        this.mHandler.removeCallbacks(this.mHideRun);
        this.mHandler = null;
        this.setVisibility(0);
    }

    private void setStatusBarVisibility(boolean visible) {
        int flag = visible ? 0 : 1024;
        this.mActivity.getWindow().setFlags(flag, 1024);
    }

    private View createTitleView() {
        this.mTitleView = new RelativeLayout((Context)this.mActivity);
        this.mTitleView.setBackgroundColor(this.mTitleViewBackground);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
        params.height = this.mHeight;
        params.width = -1;
        this.mTitleView.setLayoutParams((ViewGroup.LayoutParams)params);
        RelativeLayout.LayoutParams ivParams = new RelativeLayout.LayoutParams(-2, -2);
        ImageView ivBack = new ImageView((Context)this.mActivity);
        if (this.mResourceId != -1) {
            ivBack.setImageResource(this.mResourceId);
        } else {
            ivBack.setImageResource(R.mipmap.title_view_back);
        }
        ivBack.setId(View.generateViewId());
        int padding = 10;
        ivBack.setPadding(padding, padding, padding, padding);
        ivBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                H5VideoWebView.this.hideCustomView();
            }
        });
        ivParams.setMargins(this.mBackMargin, 0, 0, 0);
        ivParams.addRule(15);
        ivParams.addRule(0);
        ivBack.setLayoutParams((ViewGroup.LayoutParams)ivParams);
        ((RelativeLayout)this.mTitleView).addView((View)ivBack, (ViewGroup.LayoutParams)ivParams);
        RelativeLayout.LayoutParams tvParams = new RelativeLayout.LayoutParams(-2, -2);
        TextView tvTitle = new TextView((Context)this.mActivity);
        tvTitle.setTextColor(this.mTitleColor);
        tvTitle.setTextSize(2, (float)this.mTitleSize);
        if (this.mLocation == 0) {
            tvParams.addRule(1, ivBack.getId());
            tvParams.addRule(15);
            tvParams.setMargins(this.mTitleMargin, 0, 0, 0);
        } else {
            tvParams.addRule(13);
        }
        tvTitle.setLayoutParams((ViewGroup.LayoutParams)tvParams);
        String url = this.getUrl();
        if (TextUtils.isEmpty((CharSequence)this.mTitle) && !TextUtils.isEmpty((CharSequence)url)) {
            int comIndex = url.indexOf(COM);
            this.mTitle = url.substring(0, comIndex - 1);
        }
        tvTitle.setText((CharSequence)this.mTitle);
        ((RelativeLayout)this.mTitleView).addView((View)tvTitle, (ViewGroup.LayoutParams)tvParams);
        return this.mTitleView;
    }

    public void setTitleView(View titleView) {
        this.mTitleView = titleView;
    }

    public void setTitle(String title) {
        this.mTitle = title;
    }

    public void setBackResource(@DrawableRes int resourceId) {
        this.mResourceId = resourceId;
    }

    public void setBackLeftMargin(int backMargin) {
        this.mBackMargin = backMargin;
    }

    public void setTitleLeftMargin(int titleMargin) {
        this.mTitleMargin = titleMargin;
    }

    public void setTitleViewBackground(int color2) {
        this.mTitleViewBackground = color2;
    }

    public void setTitleColor(int color2) {
        this.mTitleColor = color2;
    }

    public void setmTitleSize(int size) {
        this.mTitleSize = size;
    }

    public void setIsShowTitleView(boolean isShowTitleView) {
        this.mIsShowTitleView = isShowTitleView;
    }

    public void setTitleLocation(int location) {
        this.mLocation = location;
    }

    public void setHeight(int height) {
        this.setHeight(height, false);
    }

    public void setHeight(int height, boolean isDp) {
        this.mHeight = isDp ? this.dip2px(height) : height;
    }

    private int dip2px(float dipValue) {
        if (null == this.mActivity) {
            return 0;
        }
        DisplayMetrics dm = this.mActivity.getApplicationContext().getResources().getDisplayMetrics();
        float density = dm.density;
        return (int)(dipValue * density + 0.5f);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 4: {
                if (this.mCustomView != null) {
                    this.hideCustomView();
                } else if (this.canGoBack()) {
                    this.goBack();
                } else {
                    this.mActivity.finish();
                }
                return true;
            }
        }
        return super.onKeyUp(keyCode, event);
    }

    private void hideTitleView() {
        if (this.mTitleView != null) {
            if (this.mHandler == null) {
                this.mHandler = new Handler();
                this.mHideRun = new Runnable(){

                    @Override
                    public void run() {
                        H5VideoWebView.this.mTitleShow = false;
                        ObjectAnimator showAnimator = ObjectAnimator.ofFloat((Object)H5VideoWebView.this.mTitleView, (Property)View.ALPHA, (float[])new float[]{1.0f, 0.0f});
                        showAnimator.setDuration(1000L);
                        showAnimator.start();
                    }
                };
                this.mHandler.postDelayed(this.mHideRun, 2000L);
            } else {
                if (this.mHideRun != null) {
                    this.mHandler.removeCallbacks(this.mHideRun);
                }
                this.mHandler.postDelayed(this.mHideRun, 2000L);
            }
        }
    }
}

