/*
 * Decompiled with CFR 0.152.
 */
package com.wang.avi.indicators;

import android.graphics.Camera;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.nineoldandroids.animation.ValueAnimator;
import com.wang.avi.Indicator;
import java.util.ArrayList;

public class SquareSpinIndicator
extends Indicator {
    private float rotateX;
    private float rotateY;
    private Camera mCamera = new Camera();
    private Matrix mMatrix = new Matrix();

    @Override
    public void draw(Canvas canvas, Paint paint) {
        this.mMatrix.reset();
        this.mCamera.save();
        this.mCamera.rotateX(this.rotateX);
        this.mCamera.rotateY(this.rotateY);
        this.mCamera.getMatrix(this.mMatrix);
        this.mCamera.restore();
        this.mMatrix.preTranslate((float)(-this.centerX()), (float)(-this.centerY()));
        this.mMatrix.postTranslate((float)this.centerX(), (float)this.centerY());
        canvas.concat(this.mMatrix);
        canvas.drawRect(new RectF((float)(this.getWidth() / 5), (float)(this.getHeight() / 5), (float)(this.getWidth() * 4 / 5), (float)(this.getHeight() * 4 / 5)), paint);
    }

    @Override
    public ArrayList<ValueAnimator> onCreateAnimators() {
        ArrayList<ValueAnimator> animators = new ArrayList<ValueAnimator>();
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 180.0f, 180.0f, 0.0f, 0.0f});
        this.addUpdateListener(animator, new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                SquareSpinIndicator.this.rotateX = ((Float)animation.getAnimatedValue()).floatValue();
                SquareSpinIndicator.this.postInvalidate();
            }
        });
        animator.setInterpolator((Interpolator)new LinearInterpolator());
        animator.setRepeatCount(-1);
        animator.setDuration(2500L);
        ValueAnimator animator1 = ValueAnimator.ofFloat((float[])new float[]{0.0f, 0.0f, 180.0f, 180.0f, 0.0f});
        this.addUpdateListener(animator1, new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                SquareSpinIndicator.this.rotateY = ((Float)animation.getAnimatedValue()).floatValue();
                SquareSpinIndicator.this.postInvalidate();
            }
        });
        animator1.setInterpolator((Interpolator)new LinearInterpolator());
        animator1.setRepeatCount(-1);
        animator1.setDuration(2500L);
        animators.add(animator);
        animators.add(animator1);
        return animators;
    }
}

