/*
 * Decompiled with CFR 0.152.
 */
package com.wang.avi.indicators;

import android.graphics.Canvas;
import android.graphics.Paint;
import com.nineoldandroids.animation.ValueAnimator;
import com.wang.avi.Indicator;
import java.util.ArrayList;

public class BallSpinFadeLoaderIndicator
extends Indicator {
    public static final float SCALE = 1.0f;
    public static final int ALPHA = 255;
    float[] scaleFloats = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    int[] alphas = new int[]{255, 255, 255, 255, 255, 255, 255, 255};

    @Override
    public void draw(Canvas canvas, Paint paint) {
        float radius = this.getWidth() / 10;
        for (int i = 0; i < 8; ++i) {
            canvas.save();
            Point point = this.circleAt(this.getWidth(), this.getHeight(), (float)(this.getWidth() / 2) - radius, (double)i * 0.7853981633974483);
            canvas.translate(point.x, point.y);
            canvas.scale(this.scaleFloats[i], this.scaleFloats[i]);
            paint.setAlpha(this.alphas[i]);
            canvas.drawCircle(0.0f, 0.0f, radius, paint);
            canvas.restore();
        }
    }

    @Override
    public ArrayList<ValueAnimator> onCreateAnimators() {
        ArrayList<ValueAnimator> animators = new ArrayList<ValueAnimator>();
        int[] delays = new int[]{0, 120, 240, 360, 480, 600, 720, 780, 840};
        for (int i = 0; i < 8; ++i) {
            final int index = i;
            ValueAnimator scaleAnim = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.4f, 1.0f});
            scaleAnim.setDuration(1000L);
            scaleAnim.setRepeatCount(-1);
            scaleAnim.setStartDelay((long)delays[i]);
            scaleAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    BallSpinFadeLoaderIndicator.this.scaleFloats[index] = ((Float)animation.getAnimatedValue()).floatValue();
                    BallSpinFadeLoaderIndicator.this.postInvalidate();
                }
            });
            scaleAnim.start();
            ValueAnimator alphaAnim = ValueAnimator.ofInt((int[])new int[]{255, 77, 255});
            alphaAnim.setDuration(1000L);
            alphaAnim.setRepeatCount(-1);
            alphaAnim.setStartDelay((long)delays[i]);
            alphaAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    BallSpinFadeLoaderIndicator.this.alphas[index] = (Integer)animation.getAnimatedValue();
                    BallSpinFadeLoaderIndicator.this.postInvalidate();
                }
            });
            alphaAnim.start();
            animators.add(scaleAnim);
            animators.add(alphaAnim);
        }
        return animators;
    }

    Point circleAt(int width, int height, float radius, double angle) {
        float x = (float)((double)(width / 2) + (double)radius * Math.cos(angle));
        float y = (float)((double)(height / 2) + (double)radius * Math.sin(angle));
        return new Point(x, y);
    }

    final class Point {
        public float x;
        public float y;

        public Point(float x, float y) {
            this.x = x;
            this.y = y;
        }
    }
}

