/*
 * Decompiled with CFR 0.152.
 */
package com.wang.avi.indicators;

import android.graphics.Canvas;
import android.graphics.Paint;
import com.nineoldandroids.animation.ValueAnimator;
import com.wang.avi.Indicator;
import java.util.ArrayList;

public class BallPulseIndicator
extends Indicator {
    public static final float SCALE = 1.0f;
    private float[] scaleFloats = new float[]{1.0f, 1.0f, 1.0f};

    @Override
    public void draw(Canvas canvas, Paint paint) {
        float circleSpacing = 4.0f;
        float radius = ((float)Math.min(this.getWidth(), this.getHeight()) - circleSpacing * 2.0f) / 6.0f;
        float x = (float)(this.getWidth() / 2) - (radius * 2.0f + circleSpacing);
        float y = this.getHeight() / 2;
        for (int i = 0; i < 3; ++i) {
            canvas.save();
            float translateX = x + radius * 2.0f * (float)i + circleSpacing * (float)i;
            canvas.translate(translateX, y);
            canvas.scale(this.scaleFloats[i], this.scaleFloats[i]);
            canvas.drawCircle(0.0f, 0.0f, radius, paint);
            canvas.restore();
        }
    }

    @Override
    public ArrayList<ValueAnimator> onCreateAnimators() {
        ArrayList<ValueAnimator> animators = new ArrayList<ValueAnimator>();
        int[] delays = new int[]{120, 240, 360};
        for (int i = 0; i < 3; ++i) {
            final int index = i;
            ValueAnimator scaleAnim = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.3f, 1.0f});
            scaleAnim.setDuration(750L);
            scaleAnim.setRepeatCount(-1);
            scaleAnim.setStartDelay((long)delays[i]);
            scaleAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    ((BallPulseIndicator)BallPulseIndicator.this).scaleFloats[index] = ((Float)animation.getAnimatedValue()).floatValue();
                    BallPulseIndicator.this.postInvalidate();
                }
            });
            animators.add(scaleAnim);
        }
        return animators;
    }
}

