/*
 * Decompiled with CFR 0.152.
 */
package com.wang.avi.indicator;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.ValueAnimator;
import com.wang.avi.indicator.BaseIndicatorController;
import java.util.ArrayList;
import java.util.List;

public class LineScalePartyIndicator
extends BaseIndicatorController {
    public static final float SCALE = 1.0f;
    float[] scaleFloats = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f};

    @Override
    public void draw(Canvas canvas, Paint paint) {
        float translateX = this.getWidth() / 9;
        float translateY = this.getHeight() / 2;
        for (int i = 0; i < 4; ++i) {
            canvas.save();
            canvas.translate((float)(2 + i * 2) * translateX - translateX / 2.0f, translateY);
            canvas.scale(this.scaleFloats[i], this.scaleFloats[i]);
            RectF rectF = new RectF(-translateX / 2.0f, (float)(-this.getHeight()) / 2.5f, translateX / 2.0f, (float)this.getHeight() / 2.5f);
            canvas.drawRoundRect(rectF, 5.0f, 5.0f, paint);
            canvas.restore();
        }
    }

    @Override
    public List<Animator> createAnimation() {
        ArrayList<Animator> animators = new ArrayList<Animator>();
        long[] durations = new long[]{1260L, 430L, 1010L, 730L};
        long[] delays = new long[]{770L, 290L, 280L, 740L};
        for (int i = 0; i < 4; ++i) {
            final int index = i;
            ValueAnimator scaleAnim = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.4f, 1.0f});
            scaleAnim.setDuration(durations[i]);
            scaleAnim.setRepeatCount(-1);
            scaleAnim.setStartDelay(delays[i]);
            scaleAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    LineScalePartyIndicator.this.scaleFloats[index] = ((Float)animation.getAnimatedValue()).floatValue();
                    LineScalePartyIndicator.this.postInvalidate();
                }
            });
            scaleAnim.start();
            animators.add((Animator)scaleAnim);
        }
        return animators;
    }
}

