/*
 * Decompiled with CFR 0.152.
 */
package com.wang.avi.indicator;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.ValueAnimator;
import com.wang.avi.indicator.BaseIndicatorController;
import java.util.ArrayList;
import java.util.List;

public class BallClipRotateIndicator
extends BaseIndicatorController {
    float scaleFloat = 1.0f;
    float degrees;

    @Override
    public void draw(Canvas canvas, Paint paint) {
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth(3.0f);
        float circleSpacing = 12.0f;
        float x = this.getWidth() / 2;
        float y = this.getHeight() / 2;
        canvas.translate(x, y);
        canvas.scale(this.scaleFloat, this.scaleFloat);
        canvas.rotate(this.degrees);
        RectF rectF = new RectF(-x + circleSpacing, -y + circleSpacing, 0.0f + x - circleSpacing, 0.0f + y - circleSpacing);
        canvas.drawArc(rectF, -45.0f, 270.0f, false, paint);
    }

    @Override
    public List<Animator> createAnimation() {
        ArrayList<Animator> animators = new ArrayList<Animator>();
        ValueAnimator scaleAnim = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.6f, 0.5f, 1.0f});
        scaleAnim.setDuration(750L);
        scaleAnim.setRepeatCount(-1);
        scaleAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                BallClipRotateIndicator.this.scaleFloat = ((Float)animation.getAnimatedValue()).floatValue();
                BallClipRotateIndicator.this.postInvalidate();
            }
        });
        scaleAnim.start();
        ValueAnimator rotateAnim = ValueAnimator.ofFloat((float[])new float[]{0.0f, 180.0f, 360.0f});
        rotateAnim.setDuration(750L);
        rotateAnim.setRepeatCount(-1);
        rotateAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                BallClipRotateIndicator.this.degrees = ((Float)animation.getAnimatedValue()).floatValue();
                BallClipRotateIndicator.this.postInvalidate();
            }
        });
        rotateAnim.start();
        animators.add((Animator)scaleAnim);
        animators.add((Animator)rotateAnim);
        return animators;
    }
}

