/*
 * Decompiled with CFR 0.152.
 */
package com.wang.avi.indicator;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.nineoldandroids.animation.ValueAnimator;
import com.wang.avi.indicator.BaseIndicatorController;

public class BallScaleMultipleIndicator
extends BaseIndicatorController {
    float[] scaleFloats = new float[]{1.0f, 1.0f, 1.0f};
    int[] alphaInts = new int[]{255, 255, 255};

    @Override
    public void draw(Canvas canvas, Paint paint) {
        float circleSpacing = 4.0f;
        for (int i = 0; i < 3; ++i) {
            paint.setAlpha(this.alphaInts[i]);
            canvas.scale(this.scaleFloats[i], this.scaleFloats[i], (float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
            canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getHeight() / 2), (float)(this.getWidth() / 2) - circleSpacing, paint);
        }
    }

    @Override
    public void createAnimation() {
        long[] delays = new long[]{0L, 200L, 400L};
        for (int i = 0; i < 3; ++i) {
            final int index = i;
            ValueAnimator scaleAnim = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            scaleAnim.setInterpolator((Interpolator)new LinearInterpolator());
            scaleAnim.setDuration(1000L);
            scaleAnim.setRepeatCount(-1);
            scaleAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    BallScaleMultipleIndicator.this.scaleFloats[index] = ((Float)animation.getAnimatedValue()).floatValue();
                    BallScaleMultipleIndicator.this.postInvalidate();
                }
            });
            scaleAnim.setStartDelay(delays[i]);
            scaleAnim.start();
            ValueAnimator alphaAnim = ValueAnimator.ofInt((int[])new int[]{255, 0});
            alphaAnim.setInterpolator((Interpolator)new LinearInterpolator());
            alphaAnim.setDuration(1000L);
            alphaAnim.setRepeatCount(-1);
            alphaAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    BallScaleMultipleIndicator.this.alphaInts[index] = (Integer)animation.getAnimatedValue();
                    BallScaleMultipleIndicator.this.postInvalidate();
                }
            });
            scaleAnim.setStartDelay(delays[i]);
            alphaAnim.start();
        }
    }
}

