/*
 * Decompiled with CFR 0.152.
 */
package com.wang.avi.indicator;

import android.graphics.Canvas;
import android.graphics.Paint;
import com.nineoldandroids.animation.ValueAnimator;
import com.wang.avi.indicator.BaseIndicatorController;

public class BallPulseSyncIndicator
extends BaseIndicatorController {
    float[] translateYFloats = new float[3];

    @Override
    public void draw(Canvas canvas, Paint paint) {
        float circleSpacing = 4.0f;
        float radius = ((float)this.getWidth() - circleSpacing * 2.0f) / 6.0f;
        float x = (float)(this.getWidth() / 2) - (radius * 2.0f + circleSpacing);
        for (int i = 0; i < 3; ++i) {
            canvas.save();
            float translateX = x + radius * 2.0f * (float)i + circleSpacing * (float)i;
            canvas.translate(translateX, this.translateYFloats[i]);
            canvas.drawCircle(0.0f, 0.0f, radius, paint);
            canvas.restore();
        }
    }

    @Override
    public void createAnimation() {
        float circleSpacing = 4.0f;
        float radius = ((float)this.getWidth() - circleSpacing * 2.0f) / 6.0f;
        int[] delays = new int[]{70, 140, 210};
        for (int i = 0; i < 3; ++i) {
            final int index = i;
            ValueAnimator scaleAnim = ValueAnimator.ofFloat((float[])new float[]{this.getHeight() / 2, (float)(this.getHeight() / 2) - radius * 2.0f, this.getHeight() / 2});
            scaleAnim.setDuration(600L);
            scaleAnim.setRepeatCount(-1);
            scaleAnim.setStartDelay((long)delays[i]);
            scaleAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    BallPulseSyncIndicator.this.translateYFloats[index] = ((Float)animation.getAnimatedValue()).floatValue();
                    BallPulseSyncIndicator.this.postInvalidate();
                }
            });
            scaleAnim.start();
        }
    }
}

