/*
 * Decompiled with CFR 0.152.
 */
package com.wang.avi;

import android.graphics.PointF;
import android.view.animation.Interpolator;

public class CubicBezierInterpolator
implements Interpolator {
    protected PointF start;
    protected PointF end;
    protected PointF a = new PointF();
    protected PointF b = new PointF();
    protected PointF c = new PointF();

    public CubicBezierInterpolator(PointF start, PointF end) throws IllegalArgumentException {
        if (start.x < 0.0f || start.x > 1.0f) {
            throw new IllegalArgumentException("startX value must be in the range [0, 1]");
        }
        if (end.x < 0.0f || end.x > 1.0f) {
            throw new IllegalArgumentException("endX value must be in the range [0, 1]");
        }
        this.start = start;
        this.end = end;
    }

    public CubicBezierInterpolator(float startX, float startY, float endX, float endY) {
        this(new PointF(startX, startY), new PointF(endX, endY));
    }

    public CubicBezierInterpolator(double startX, double startY, double endX, double endY) {
        this((float)startX, (float)startY, (float)endX, (float)endY);
    }

    public float getInterpolation(float time) {
        return this.getBezierCoordinateY(this.getXForTime(time));
    }

    protected float getBezierCoordinateY(float time) {
        this.c.y = 3.0f * this.start.y;
        this.b.y = 3.0f * (this.end.y - this.start.y) - this.c.y;
        this.a.y = 1.0f - this.c.y - this.b.y;
        return time * (this.c.y + time * (this.b.y + time * this.a.y));
    }

    protected float getXForTime(float time) {
        float z;
        float x = time;
        for (int i = 1; i < 14 && !((double)Math.abs(z = this.getBezierCoordinateX(x) - time) < 0.001); ++i) {
            x -= z / this.getXDerivate(x);
        }
        return x;
    }

    private float getXDerivate(float t) {
        return this.c.x + t * (2.0f * this.b.x + 3.0f * this.a.x * t);
    }

    private float getBezierCoordinateX(float time) {
        this.c.x = 3.0f * this.start.x;
        this.b.x = 3.0f * (this.end.x - this.start.x) - this.c.x;
        this.a.x = 1.0f - this.c.x - this.b.x;
        return time * (this.c.x + time * (this.b.x + time * this.a.x));
    }
}

