/*
 * Decompiled with CFR 0.152.
 */
package com.wanderingcan.persistentsearch;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import com.wanderingcan.persistentsearch.R;
import com.wanderingcan.persistentsearch.SearchMenuPresenter;

public class SearchMenuItem
implements Comparable<SearchMenuItem> {
    private final int mId;
    private int mOrdering;
    private Drawable mIconDrawable;
    private String mTitle;
    private Drawable mActionDrawable;
    private boolean mDefaultAction;
    private SearchMenuPresenter mMenu;
    private ColorStateList mIconTint;
    private ColorStateList mActionTint;
    private PorterDuff.Mode mIconTintMode;
    private PorterDuff.Mode mActionTintMode;

    private SearchMenuItem() {
        this.mId = 0;
    }

    SearchMenuItem(SearchMenuPresenter presenter, int id, int order, String title) {
        this.mMenu = presenter;
        this.mId = id;
        this.mOrdering = order;
        this.mTitle = title;
        this.setActionIcon(R.drawable.ic_action_arrow);
        this.mDefaultAction = true;
    }

    protected boolean isDefaultAction() {
        return this.mDefaultAction;
    }

    public int getId() {
        return this.mId;
    }

    public int getOrdering() {
        return this.mOrdering;
    }

    public void setOrdering(int order) {
        this.mOrdering = order;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public SearchMenuItem setTitle(String title) {
        this.mTitle = title = title.trim();
        this.notifyItemChanged();
        return this;
    }

    public SearchMenuItem setTitle(@StringRes int resId) {
        Context context = this.mMenu.getContext();
        String title = context.getString(resId);
        return this.setTitle(title);
    }

    public Drawable getActionIcon() {
        return this.mActionDrawable;
    }

    public SearchMenuItem setActionIcon(Drawable icon) {
        this.mDefaultAction = false;
        this.mActionDrawable = DrawableCompat.wrap((Drawable)icon);
        if (this.mActionTint != null) {
            DrawableCompat.setTintList((Drawable)this.mActionDrawable, (ColorStateList)this.mActionTint);
        }
        if (this.mActionTintMode != null) {
            DrawableCompat.setTintMode((Drawable)this.mActionDrawable, (PorterDuff.Mode)this.mActionTintMode);
        }
        this.notifyItemChanged();
        return this;
    }

    public SearchMenuItem setActionIcon(@DrawableRes int iconResId) {
        return this.setActionIcon(ContextCompat.getDrawable((Context)this.mMenu.getContext(), (int)iconResId));
    }

    public Drawable getIcon() {
        return this.mIconDrawable;
    }

    public SearchMenuItem setIcon(Drawable icon) {
        this.mIconDrawable = DrawableCompat.wrap((Drawable)icon);
        if (this.mIconTint != null) {
            DrawableCompat.setTintList((Drawable)this.mIconDrawable, (ColorStateList)this.mIconTint);
        }
        if (this.mIconTintMode != null) {
            DrawableCompat.setTintMode((Drawable)this.mIconDrawable, (PorterDuff.Mode)this.mIconTintMode);
        }
        this.notifyItemChanged();
        return this;
    }

    public SearchMenuItem setIcon(@DrawableRes int iconResId) {
        return this.setIcon(ContextCompat.getDrawable((Context)this.mMenu.getContext(), (int)iconResId));
    }

    public SearchMenuItem setIconTintList(@Nullable ColorStateList tint) {
        this.mIconTint = tint;
        DrawableCompat.setTintList((Drawable)this.mIconDrawable, (ColorStateList)tint);
        this.notifyItemChanged();
        return this;
    }

    public SearchMenuItem setActionIconTint(@Nullable ColorStateList tint) {
        this.mActionTint = tint;
        DrawableCompat.setTintList((Drawable)this.mActionDrawable, (ColorStateList)tint);
        this.notifyItemChanged();
        return this;
    }

    public SearchMenuItem setIconTintMode(@Nullable PorterDuff.Mode mode) {
        this.mIconTintMode = mode;
        DrawableCompat.setTintMode((Drawable)this.mIconDrawable, (PorterDuff.Mode)mode);
        this.notifyItemChanged();
        return this;
    }

    public SearchMenuItem setActionIconTintMode(@Nullable PorterDuff.Mode mode) {
        this.mActionTintMode = mode;
        DrawableCompat.setTintMode((Drawable)this.mActionDrawable, (PorterDuff.Mode)mode);
        this.notifyItemChanged();
        return this;
    }

    private void notifyItemChanged() {
        int index = this.mMenu.getMenu().getItems().indexOf(this);
        this.mMenu.mAdapter.notifyItemChanged(index);
    }

    public String toString() {
        return "SearchMenuItem{\nId = " + this.mId + "\nTitle = '" + this.mTitle + '\'' + "\nOrdering = " + this.mOrdering + '}';
    }

    @Override
    public int compareTo(@NonNull SearchMenuItem another) {
        return this.mOrdering - another.mOrdering;
    }
}

