/*
 * Decompiled with CFR 0.152.
 */
package com.wanderingcan.persistentsearch;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;

class DividerItemDecoration
extends RecyclerView.ItemDecoration {
    private Drawable mDivider;

    public DividerItemDecoration(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, new int[]{16843284});
        this.mDivider = a.getDrawable(0);
        a.recycle();
    }

    public DividerItemDecoration(Drawable divider) {
        this.mDivider = divider;
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        super.getItemOffsets(outRect, view, parent, state);
        if (this.mDivider == null) {
            return;
        }
        if (parent.getChildPosition(view) < 1) {
            return;
        }
        if (this.getOrientation(parent) == 1) {
            outRect.top = this.mDivider.getIntrinsicHeight();
        } else {
            outRect.left = this.mDivider.getIntrinsicWidth();
        }
    }

    public void onDrawOver(Canvas c, RecyclerView parent) {
        if (this.mDivider == null) {
            super.onDrawOver(c, parent);
            return;
        }
        if (this.getOrientation(parent) == 1) {
            int left = parent.getPaddingLeft();
            int right = parent.getWidth() - parent.getPaddingRight();
            int childCount = parent.getChildCount();
            for (int i = 1; i < childCount; ++i) {
                View child = parent.getChildAt(i);
                RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
                int size = this.mDivider.getIntrinsicHeight();
                int top = child.getTop() - params.topMargin;
                int bottom = top + size;
                this.mDivider.setBounds(left, top, right, bottom);
                this.mDivider.draw(c);
            }
        } else {
            int top = parent.getPaddingTop();
            int bottom = parent.getHeight() - parent.getPaddingBottom();
            int childCount = parent.getChildCount();
            for (int i = 1; i < childCount; ++i) {
                View child = parent.getChildAt(i);
                RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
                int size = this.mDivider.getIntrinsicWidth();
                int left = child.getLeft() - params.leftMargin;
                int right = left + size;
                this.mDivider.setBounds(left, top, right, bottom);
                this.mDivider.draw(c);
            }
        }
    }

    private int getOrientation(RecyclerView parent) {
        if (parent.getLayoutManager() instanceof LinearLayoutManager) {
            LinearLayoutManager layoutManager = (LinearLayoutManager)parent.getLayoutManager();
            return layoutManager.getOrientation();
        }
        throw new IllegalStateException("DividerItemDecoration can only be used with a LinearLayoutManager.");
    }
}

