/*
 * Decompiled with CFR 0.152.
 */
package com.wanderingcan.persistentsearch;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.StringRes;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.CardView;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;
import com.wanderingcan.persistentsearch.DividerItemDecoration;
import com.wanderingcan.persistentsearch.SearchMenu;
import com.wanderingcan.persistentsearch.SearchMenuItem;
import com.wanderingcan.persistentsearch.SearchMenuPresenter;
import com.wanderingcan.persistentsearch.SearchMenuView;
import com.wanderingcan.widget.R;

public class PersistentSearchView
extends CardView {
    private static final String TAG = "PersistentSearchView";
    private static final String EMPTY = "";
    private ImageButton mNavIcon;
    private ImageButton mEndIcon;
    private EditText mSearchText;
    private SearchMenuView mSearchMenuView;
    private View mDivider;
    private SearchMenuPresenter mPresenter;
    private CharSequence mHint;
    private boolean mHintAlwaysVisible;
    private boolean mHintVisible;
    private boolean mShowClearDrawable;
    private boolean mShowMenu;
    private boolean mOpened;
    private OnSearchListener mSearchListener;
    private OnIconClickListener mIconListener;
    private OnMenuItemClickListener mMenuListener;
    private Drawable mEndDrawable;
    private Drawable mClearDrawable;
    private int mTextMargin;
    private int mImageMargin;

    public PersistentSearchView(Context context) {
        super(context);
        this.initialize(context, null, 0);
    }

    public PersistentSearchView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context, attrs, 0);
    }

    public PersistentSearchView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context, attrs, defStyleAttr);
    }

    private void initialize(Context context, AttributeSet attrs, int defStyleAttr) {
        this.mNavIcon = new ImageButton(context);
        this.mEndIcon = new ImageButton(context);
        this.mSearchText = new EditText(context);
        this.mSearchMenuView = new SearchMenuView(context);
        this.mDivider = new View(context);
        this.mDivider.setVisibility(8);
        this.mPresenter = new SearchMenuPresenter(context, new SearchMenuListener());
        this.mSearchMenuView.setAdapter(this.mPresenter.getAdapter());
        this.mSearchMenuView.addItemDecoration(new DividerItemDecoration(context, attrs));
        int[] attr2 = new int[]{16843284};
        TypedArray ta = context.obtainStyledAttributes(attr2);
        Drawable divider = ta.getDrawable(0);
        ta.recycle();
        this.mOpened = false;
        this.mShowClearDrawable = false;
        this.mShowMenu = true;
        this.setUseCompatPadding(true);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        if (Build.VERSION.SDK_INT >= 16) {
            this.mSearchText.setBackground(null);
            this.mNavIcon.setBackground(null);
            this.mEndIcon.setBackground(null);
            this.mDivider.setBackground(divider);
        } else {
            this.mSearchText.setBackgroundDrawable(null);
            this.mNavIcon.setBackgroundDrawable(null);
            this.mEndIcon.setBackgroundDrawable(null);
            this.mDivider.setBackgroundDrawable(divider);
        }
        this.mSearchText.setSingleLine();
        this.mHintVisible = false;
        this.mSearchText.setOnFocusChangeListener((View.OnFocusChangeListener)new SearchFocusListener());
        this.mSearchText.setOnEditorActionListener((TextView.OnEditorActionListener)new EditTextEditorAction());
        this.mSearchText.setImeOptions(3);
        this.mSearchText.addTextChangedListener((TextWatcher)new EditTextTextWatcher());
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.PersistentSearchView, defStyleAttr, 0);
        Drawable drawable2 = a.getDrawable(R.styleable.PersistentSearchView_navSrc);
        this.setNavigationDrawable(drawable2);
        this.mNavIcon.setScaleType(ImageView.ScaleType.FIT_CENTER);
        this.mNavIcon.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PersistentSearchView.this.mIconListener != null) {
                    PersistentSearchView.this.mIconListener.OnNavigationIconClick();
                }
            }
        });
        drawable2 = a.getDrawable(R.styleable.PersistentSearchView_endSrc);
        this.setEndDrawable(drawable2);
        this.mClearDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ic_action_cancel);
        this.mEndIcon.setScaleType(ImageView.ScaleType.FIT_CENTER);
        this.mEndIcon.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PersistentSearchView.this.mShowClearDrawable) {
                    PersistentSearchView.this.mSearchText.setText((CharSequence)PersistentSearchView.EMPTY);
                } else if (PersistentSearchView.this.mIconListener != null) {
                    PersistentSearchView.this.mIconListener.OnEndIconClick();
                }
            }
        });
        this.mHint = a.getText(R.styleable.PersistentSearchView_hint);
        this.mHintAlwaysVisible = a.getBoolean(R.styleable.PersistentSearchView_hintAlwaysActive, false);
        if (this.mHintAlwaysVisible) {
            this.mSearchText.setHint(this.mHint);
        }
        a.recycle();
        Resources res = context.getResources();
        int imageDimen = res.getDimensionPixelSize(R.dimen.image_dimen);
        this.mImageMargin = res.getDimensionPixelSize(R.dimen.image_side_margin);
        int imageTopMargin = res.getDimensionPixelSize(R.dimen.image_top_margin);
        FrameLayout.LayoutParams lpNav = this.generateDefaultLayoutParams();
        lpNav.width = lpNav.height = imageDimen;
        FrameLayout.LayoutParams lpEnd = (FrameLayout.LayoutParams)this.generateLayoutParams((ViewGroup.LayoutParams)lpNav);
        lpNav.gravity = 0x800003;
        lpEnd.gravity = 0x800005;
        if (Build.VERSION.SDK_INT >= 17) {
            this.mNavIcon.setPaddingRelative(this.mImageMargin, imageTopMargin, this.mImageMargin / 2, imageTopMargin);
            this.mEndIcon.setPaddingRelative(this.mImageMargin / 2, imageTopMargin, this.mImageMargin, imageTopMargin);
        } else {
            this.mNavIcon.setPadding(this.mImageMargin, imageTopMargin, this.mImageMargin / 2, imageTopMargin);
            this.mEndIcon.setPadding(this.mImageMargin / 2, imageTopMargin, this.mImageMargin, imageTopMargin);
        }
        FrameLayout.LayoutParams lpText = this.generateDefaultLayoutParams();
        lpText.gravity = 48;
        lpText.height = lpNav.topMargin + lpNav.height;
        this.mTextMargin = res.getDimensionPixelSize(R.dimen.text_margin);
        if (Build.VERSION.SDK_INT >= 17) {
            lpText.setMarginStart(this.mTextMargin);
            lpText.setMarginEnd(this.mTextMargin);
        } else {
            lpText.leftMargin = lpText.rightMargin = this.mTextMargin;
        }
        this.setupSearchTextMargin(lpText);
        FrameLayout.LayoutParams lpMenu = this.generateDefaultLayoutParams();
        lpMenu.topMargin = lpNav.topMargin + lpNav.height;
        FrameLayout.LayoutParams lpDivider = this.generateDefaultLayoutParams();
        if (divider != null) {
            lpDivider.height = divider.getIntrinsicHeight();
        }
        lpDivider.topMargin = lpNav.topMargin + lpNav.height;
        this.addView((View)this.mNavIcon, (ViewGroup.LayoutParams)lpNav);
        this.addView((View)this.mEndIcon, (ViewGroup.LayoutParams)lpEnd);
        this.addView((View)this.mSearchText, (ViewGroup.LayoutParams)lpText);
        this.addView((View)this.mSearchMenuView, (ViewGroup.LayoutParams)lpMenu);
        this.addView(this.mDivider, (ViewGroup.LayoutParams)lpDivider);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int minHeight = this.getResources().getDimensionPixelSize(R.dimen.min_height);
        if (this.mShowMenu && this.isSearchOpen()) {
            heightMode = 0;
        }
        heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)minHeight, (int)heightMode);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public void setOnSearchListener(OnSearchListener listener) {
        this.mSearchListener = listener;
    }

    public void setOnIconClickListener(OnIconClickListener listener) {
        this.mIconListener = listener;
    }

    public void setOnMenuItemClickListener(OnMenuItemClickListener listener) {
        this.mMenuListener = listener;
    }

    public void populateSearchText(CharSequence text) {
        this.mSearchText.setText(text);
        this.mSearchText.setSelection(this.mSearchText.getText().length());
    }

    public void setShowSearchMenu(boolean showMenu) {
        this.mShowMenu = showMenu;
    }

    public boolean showSearchMenu() {
        return this.mShowMenu;
    }

    public boolean isSearchOpen() {
        return this.mOpened;
    }

    public void openSearch() {
        this.mOpened = true;
        this.mSearchText.requestFocus();
        if (this.mSearchListener != null) {
            this.mSearchListener.onSearchOpened();
        }
        if (this.mShowMenu) {
            this.mSearchMenuView.setVisibility(0);
            this.mDivider.setVisibility(0);
        }
        this.requestLayout();
    }

    public void closeSearch() {
        this.mOpened = false;
        this.requestFocus();
        if (this.mSearchListener != null) {
            this.mSearchListener.onSearchClosed();
        }
        InputMethodManager inputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
        inputMethodManager.hideSoftInputFromWindow(this.getApplicationWindowToken(), 0);
        if (this.mSearchMenuView.getVisibility() == 0) {
            this.mSearchMenuView.setVisibility(8);
            this.mDivider.setVisibility(8);
        }
        this.requestLayout();
        this.mPresenter.getMenu().clearItems();
    }

    public void setNavigationBitmap(Bitmap bitmap) {
        if (bitmap == null) {
            this.setNavigationDrawable(null);
        } else {
            this.setNavigationDrawable((Drawable)new BitmapDrawable(this.getResources(), bitmap));
        }
    }

    public void setNavigationDrawable(Drawable drawable2) {
        if (drawable2 == null && this.mNavIcon.getVisibility() == 0) {
            this.mNavIcon.setVisibility(8);
            if (this.mSearchText.getLayoutParams() != null) {
                this.mSearchText.setLayoutParams((ViewGroup.LayoutParams)this.setupSearchTextMargin((FrameLayout.LayoutParams)this.mSearchText.getLayoutParams()));
            }
            return;
        }
        if (this.mNavIcon.getVisibility() == 8) {
            this.mNavIcon.setVisibility(0);
            if (this.mSearchText.getLayoutParams() != null) {
                this.mSearchText.setLayoutParams((ViewGroup.LayoutParams)this.setupSearchTextMargin((FrameLayout.LayoutParams)this.mSearchText.getLayoutParams()));
                this.mSearchText.requestLayout();
            }
        }
        this.mNavIcon.setImageDrawable(drawable2);
    }

    public Drawable getNavigationDrawable() {
        return this.mNavIcon.getDrawable();
    }

    public void setEndBitmap(Bitmap bitmap) {
        if (bitmap == null) {
            this.setEndDrawable(null);
        } else {
            this.setEndDrawable((Drawable)new BitmapDrawable(this.getResources(), bitmap));
        }
    }

    public void setEndDrawable(Drawable drawable2) {
        this.mEndDrawable = drawable2 == null ? ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ic_action_mic) : drawable2;
        if (!this.mShowClearDrawable) {
            this.mEndIcon.setImageDrawable(this.mEndDrawable);
        }
    }

    public Drawable getEndDrawable() {
        return this.mEndDrawable;
    }

    public void setHint(CharSequence hint) {
        this.mHint = hint;
        if (this.mHintAlwaysVisible || this.mHintVisible) {
            this.mSearchText.setHint(hint);
        }
    }

    public void setHint(@StringRes int stringRes) {
        this.setHint(this.getResources().getString(stringRes));
    }

    private FrameLayout.LayoutParams setupSearchTextMargin(FrameLayout.LayoutParams lp) {
        if (Build.VERSION.SDK_INT >= 17) {
            if (this.mNavIcon.getVisibility() == 0) {
                lp.setMarginStart(this.mTextMargin);
            } else {
                lp.setMarginStart(this.mImageMargin);
            }
        } else {
            lp.leftMargin = this.mNavIcon.getVisibility() == 0 ? this.mTextMargin : this.mImageMargin;
        }
        return lp;
    }

    public SearchMenu getSearchMenu() {
        return this.mPresenter.getMenu();
    }

    private class SearchFocusListener
    implements View.OnFocusChangeListener {
        private SearchFocusListener() {
        }

        public void onFocusChange(View v, boolean hasFocus) {
            if (hasFocus && !PersistentSearchView.this.mOpened) {
                PersistentSearchView.this.openSearch();
            }
            if (!PersistentSearchView.this.mHintAlwaysVisible) {
                if (hasFocus) {
                    PersistentSearchView.this.mSearchText.setHint(PersistentSearchView.this.mHint);
                } else {
                    PersistentSearchView.this.mSearchText.setHint((CharSequence)PersistentSearchView.EMPTY);
                }
            }
        }
    }

    private class EditTextEditorAction
    implements TextView.OnEditorActionListener {
        private EditTextEditorAction() {
        }

        public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
            if (actionId == 3) {
                if (PersistentSearchView.this.mSearchListener != null) {
                    PersistentSearchView.this.mSearchListener.onSearch(v.getText());
                }
                PersistentSearchView.this.closeSearch();
                return true;
            }
            return false;
        }
    }

    private class EditTextTextWatcher
    implements TextWatcher {
        private EditTextTextWatcher() {
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            if (TextUtils.isEmpty((CharSequence)s)) {
                PersistentSearchView.this.mShowClearDrawable = false;
                PersistentSearchView.this.mEndIcon.setImageDrawable(PersistentSearchView.this.mEndDrawable);
            } else {
                PersistentSearchView.this.mShowClearDrawable = true;
                if (!PersistentSearchView.this.mEndIcon.getDrawable().equals(PersistentSearchView.this.mClearDrawable)) {
                    PersistentSearchView.this.mEndIcon.setImageDrawable(PersistentSearchView.this.mClearDrawable);
                }
            }
            if (PersistentSearchView.this.mSearchListener != null && !TextUtils.isEmpty((CharSequence)s)) {
                PersistentSearchView.this.mSearchListener.onSearchTermChanged(s);
            }
        }

        public void afterTextChanged(Editable s) {
            if (TextUtils.isEmpty((CharSequence)s) && PersistentSearchView.this.mSearchListener != null) {
                PersistentSearchView.this.mSearchListener.onSearchCleared();
            }
        }
    }

    private class SearchMenuListener
    implements SearchMenuPresenter.SearchMenuItemListener {
        private SearchMenuListener() {
        }

        @Override
        public void onItemClick(SearchMenuItem item) {
            if (PersistentSearchView.this.mMenuListener != null) {
                PersistentSearchView.this.mMenuListener.onMenuItemClick(item);
            }
        }

        @Override
        public void onActionClick(SearchMenuItem item, boolean defaultAction) {
            if (defaultAction) {
                PersistentSearchView.this.populateSearchText(item.getTitle());
            }
        }
    }

    public static interface OnIconClickListener {
        public void OnNavigationIconClick();

        public void OnEndIconClick();
    }

    public static interface OnMenuItemClickListener {
        public void onMenuItemClick(SearchMenuItem var1);
    }

    public static interface OnSearchListener {
        public void onSearchOpened();

        public void onSearchClosed();

        public void onSearchCleared();

        public void onSearchTermChanged(CharSequence var1);

        public void onSearch(CharSequence var1);
    }
}

