/*
 * Decompiled with CFR 0.152.
 */
package com.walletone.sdk.constants;

import java.util.HashMap;
import java.util.Map;

public enum CurrencyId {
    RUB(643),
    UNDEFINED(0);

    private final Integer id;
    private static Map<Integer, CurrencyId> map;

    private CurrencyId(Integer id) {
        this.id = id;
    }

    public String getAlphabeticCode() {
        switch (this) {
            case RUB: {
                return "RUB";
            }
        }
        return "";
    }

    public String getSymbol() {
        switch (this) {
            case RUB: {
                return "\u20bd";
            }
        }
        return "";
    }

    public static CurrencyId getCurrencyById(Integer id) {
        CurrencyId result = map.get(id);
        return result == null ? UNDEFINED : result;
    }

    public Integer getId() {
        return this.id;
    }

    static {
        map = new HashMap<Integer, CurrencyId>();
        for (CurrencyId currency : CurrencyId.values()) {
            map.put(currency.id, currency);
        }
    }
}

