/*
 * Decompiled with CFR 0.152.
 */
package com.walletone.p2pui.paymenttool;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.util.Preconditions;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.helper.ItemTouchHelper;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.Toast;
import com.walletone.p2pui.R;
import com.walletone.p2pui.linkpaymenttool.LinkPaymentToolActivity;
import com.walletone.p2pui.paymenttool.PaymentToolAdapter;
import com.walletone.p2pui.paymenttool.PaymentToolContract;
import com.walletone.sdk.models.PaymentTool;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PaymentToolFragment
extends Fragment
implements PaymentToolContract.View {
    private View noPaymentToolsView;
    private View paymentToolsBlockView;
    private ViewGroup linkPaymentToolItem;
    private RecyclerView paymentToolsRecyclerView;
    private PaymentToolAdapter paymentToolsAdapter;
    private PaymentToolContract.Presenter presenter;
    private ProgressBar progressBar;
    PaymentToolItemListener itemListener = new PaymentToolItemListener(){

        @Override
        public void onPaymentToolClick(PaymentTool clickedPaymentTool) {
            Intent intent = new Intent();
            intent.putExtra("PaymentToolActivity.ARG_PAYMENT_TOOL_ID", (Serializable)clickedPaymentTool.getPaymentToolId());
            PaymentToolFragment.this.getActivity().setResult(-1, intent);
            PaymentToolFragment.this.getActivity().finish();
        }
    };

    public static PaymentToolFragment newInstance() {
        return new PaymentToolFragment();
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.paymentToolsAdapter = new PaymentToolAdapter(new ArrayList<PaymentTool>(0), this.itemListener, this.getContext());
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View root = inflater.inflate(R.layout.payment_tool_fragment_layout, container, false);
        this.paymentToolsBlockView = root.findViewById(R.id.payment_tools_block);
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.getContext());
        this.paymentToolsRecyclerView = (RecyclerView)root.findViewById(R.id.payment_tools_list);
        this.paymentToolsRecyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.paymentToolsRecyclerView.setAdapter((RecyclerView.Adapter)this.paymentToolsAdapter);
        this.setupItemTouchHelper();
        this.noPaymentToolsView = root.findViewById(R.id.no_payment_tools);
        this.linkPaymentToolItem = (ViewGroup)root.findViewById(R.id.link_payment_tool_item);
        this.linkPaymentToolItem.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                PaymentToolFragment.this.presenter.addNewPaymentTool();
            }
        });
        this.setLinkPaymentToolVisibility(this.presenter.isAddNewPaymentToolAvailable());
        this.progressBar = (ProgressBar)root.findViewById(R.id.progress_bar);
        this.setHasOptionsMenu(true);
        return root;
    }

    private void setupItemTouchHelper() {
        ItemTouchHelper.SimpleCallback swipeCallback = new ItemTouchHelper.SimpleCallback(0, 4){

            public boolean onMove(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, RecyclerView.ViewHolder target) {
                return false;
            }

            public void onSwiped(RecyclerView.ViewHolder viewHolder, int direction) {
                final int position = viewHolder.getAdapterPosition();
                final PaymentTool paymentTool = ((PaymentToolAdapter.ItemViewHolder)viewHolder).getPaymentTool();
                if (direction == 4) {
                    AlertDialog.Builder builder = new AlertDialog.Builder((Context)PaymentToolFragment.this.getActivity());
                    builder.setMessage(R.string.delete_payment_tool_confirmation);
                    builder.setOnDismissListener(new DialogInterface.OnDismissListener(){

                        public void onDismiss(DialogInterface dialogInterface) {
                            PaymentToolFragment.this.paymentToolsAdapter.notifyItemRangeChanged(position, PaymentToolFragment.this.paymentToolsAdapter.getItemCount());
                        }
                    }).setPositiveButton(R.string.delete, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            PaymentToolFragment.this.paymentToolsAdapter.removeItem(position);
                            PaymentToolFragment.this.presenter.deletePaymentTool(paymentTool);
                        }
                    }).setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                        }
                    }).show();
                }
            }
        };
        ItemTouchHelper itemTouchHelper = new ItemTouchHelper((ItemTouchHelper.Callback)swipeCallback);
        itemTouchHelper.attachToRecyclerView(this.paymentToolsRecyclerView);
    }

    private void setLinkPaymentToolVisibility(boolean visibility) {
        this.linkPaymentToolItem.setVisibility(visibility ? 0 : 8);
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        if (this.presenter.isAddNewPaymentToolAvailable()) {
            inflater.inflate(R.menu.payment_tools_menu, menu2);
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        Integer itemId = item.getItemId();
        if (itemId.equals(R.id.menu_link_payment_tool)) {
            this.presenter.addNewPaymentTool();
        }
        return true;
    }

    public void onResume() {
        super.onResume();
        this.presenter.start();
    }

    @Override
    @SuppressLint(value={"RestrictedApi"})
    public void setPresenter(PaymentToolContract.Presenter presenter) {
        this.presenter = (PaymentToolContract.Presenter)Preconditions.checkNotNull((Object)presenter);
    }

    @Override
    public void showPaymentTools(List<PaymentTool> paymentTools) {
        this.paymentToolsAdapter.replaceData(paymentTools);
        this.paymentToolsBlockView.setVisibility(0);
        this.noPaymentToolsView.setVisibility(8);
    }

    @Override
    public void showEmptyList() {
        this.noPaymentToolsView.setVisibility(0);
        this.paymentToolsBlockView.setVisibility(8);
    }

    @Override
    public void showLinkPaymentToolActivity() {
        Intent intent = new Intent(this.getContext(), LinkPaymentToolActivity.class);
        this.startActivityForResult(intent, 1);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 1: {
                if (resultCode == -1) {
                    this.presenter.loadPaymentTools(true);
                    break;
                }
                if (resultCode != 2) break;
                Toast.makeText((Context)this.getContext(), (CharSequence)"Link paymentTool result error", (int)0).show();
            }
        }
    }

    @Override
    public void setLoadingIndicator(boolean show) {
        this.progressBar.setVisibility(show ? 0 : 8);
    }

    @Override
    public void closePaymentToolAndShowPayDealActivity() {
        Intent intent = new Intent();
        this.getActivity().setResult(-1, intent);
        this.getActivity().finish();
    }

    @Override
    public void showError(Throwable error) {
        Toast.makeText((Context)this.getContext(), (CharSequence)error.getLocalizedMessage(), (int)0).show();
    }

    public static interface PaymentToolItemListener {
        public void onPaymentToolClick(PaymentTool var1);
    }
}

