/*
 * Decompiled with CFR 0.152.
 */
package com.walletone.p2pui.linkpaymenttool;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.MenuItem;
import android.webkit.ConsoleMessage;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.Toast;
import com.walletone.p2pui.R;
import com.walletone.p2pui.W1P2PToolbar;
import com.walletone.sdk.P2PCore;
import com.walletone.sdk.models.RequestBuilder;
import java.io.UnsupportedEncodingException;

public class LinkPaymentToolActivity
extends AppCompatActivity {
    private static final String LOG_TAG = "W1P2PToolbar";
    public static final int RESULT_FAIL = 2;
    private final String RETURN_HOST = "p2p-success-link-new-paymenttool";
    public static final int REQUEST_LINK_PAYMENT_TOOL = 1;
    private boolean isVisible = false;
    private boolean needFinish = false;
    WebView linkPaymentToolWebView;
    FrameLayout progressFrame;
    ProgressBar progressBar;
    private boolean finishEventDispatched = false;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.link_payment_tool_activity_layout);
        W1P2PToolbar.installToolBar(this);
        ActionBar ab = this.getSupportActionBar();
        if (ab == null) {
            String errorMsg = "This activity requires an AppCompat theme with an action bar, finishing activity...";
            Toast.makeText((Context)this, (CharSequence)errorMsg, (int)1).show();
            this.finish();
        } else {
            ab.setDisplayHomeAsUpEnabled(true);
        }
        this.linkPaymentToolWebView = (WebView)this.findViewById(R.id.link_payment_tool_web_view);
        this.progressFrame = (FrameLayout)this.findViewById(R.id.progressFrame);
        this.progressBar = (ProgressBar)this.findViewById(R.id.progress);
        this.progressBar.setMax(100);
        RequestBuilder request = P2PCore.INSTANCE.beneficiariesPaymentTools.addNewPaymentToolRequest("http://p2p-success-link-new-paymenttool", null, Boolean.valueOf(true));
        P2PCore.INSTANCE.printDebug("=======");
        P2PCore.INSTANCE.printDebug("LinkPaymentTool");
        P2PCore.INSTANCE.printDebug("Method: " + request.getMethodType().getMethodTypeId() + " / " + request.getUrlString());
        P2PCore.INSTANCE.printDebug("Http body:");
        P2PCore.INSTANCE.printDebug(request.getHttpBody());
        try {
            String postData = request.getHttpBody();
            this.linkPaymentToolWebView.setWebViewClient((WebViewClient)new MyWebViewClient());
            this.setupWebView();
            this.linkPaymentToolWebView.postUrl(request.getUrlString(), postData.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        LinearLayout toolBarContainer = (LinearLayout)this.findViewById(R.id.container);
        int[] location = new int[2];
        toolBarContainer.getLocationOnScreen(location);
        int locationY = location[1];
        Log.d((String)LOG_TAG, (String)("locationY: " + locationY));
        Log.d((String)LOG_TAG, (String)("getY(): " + toolBarContainer.getY()));
        if (locationY <= 0) {
            toolBarContainer.setY((float)this.getStatusBarHeight());
        }
    }

    public int getStatusBarHeight() {
        int result = 0;
        int resourceId = this.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = this.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }

    private void setupWebView() {
        WebSettings wbs = this.linkPaymentToolWebView.getSettings();
        wbs.setPluginState(WebSettings.PluginState.ON);
        wbs.setSaveFormData(true);
        wbs.setDomStorageEnabled(true);
        wbs.setJavaScriptEnabled(true);
        wbs.setBuiltInZoomControls(true);
        wbs.setAllowFileAccess(true);
        wbs.setSupportZoom(true);
        this.linkPaymentToolWebView.setWebViewClient((WebViewClient)new MyWebViewClient());
        this.linkPaymentToolWebView.setWebChromeClient(new WebChromeClient(){

            public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
                return true;
            }
        });
        this.linkPaymentToolWebView.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int newProgress) {
                LinkPaymentToolActivity.this.progressBar.setProgress(newProgress);
                if (newProgress == 100) {
                    LinkPaymentToolActivity.this.progressFrame.setVisibility(8);
                }
                super.onProgressChanged(view, newProgress);
            }
        });
    }

    private boolean checkUrl(String url) {
        if (url == null) {
            url = "";
        }
        url = url.toLowerCase();
        boolean handled = false;
        if (!this.finishEventDispatched && url.equals("http://p2p-success-link-new-paymenttool/")) {
            handled = true;
            this.finishEventDispatched = true;
            this.onResultSuccess();
        }
        return handled;
    }

    public void onResultSuccess() {
        this.setResult(-1);
        this.finish();
    }

    public void onResultFail() {
        this.setResult(2);
        this.finish();
    }

    protected void onResume() {
        super.onResume();
        this.isVisible = true;
        if (this.needFinish) {
            this.finish();
            this.needFinish = false;
        }
    }

    protected void onPause() {
        super.onPause();
        this.isVisible = false;
    }

    public void onBackPressed() {
        if (this.isVisible) {
            super.onBackPressed();
        } else {
            this.needFinish = true;
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                super.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private class MyWebViewClient
    extends WebViewClient {
        private String pendingUrl;

        private MyWebViewClient() {
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            if (this.pendingUrl == null) {
                this.pendingUrl = url;
            }
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            LinkPaymentToolActivity.this.progressFrame.setVisibility(0);
            return LinkPaymentToolActivity.this.checkUrl(url);
        }

        public void onPageFinished(WebView view, String url) {
            if (url == null) {
                url = "";
            }
            LinkPaymentToolActivity.this.checkUrl(url);
            if (!url.equals(this.pendingUrl)) {
                this.pendingUrl = null;
            }
        }
    }
}

