/*
 * Decompiled with CFR 0.152.
 */
package com.walletone.p2pui.refunds;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;
import com.walletone.p2pui.R;
import com.walletone.p2pui.refunds.RefundsAdapter;
import com.walletone.p2pui.refunds.RefundsContract;
import com.walletone.sdk.models.Refund;
import java.util.ArrayList;
import java.util.List;

public class RefundsFragment
extends Fragment
implements RefundsContract.View,
RefundsAdapter.OnScrolledToBottomListener {
    private View noRefundsView;
    private RecyclerView refundsListView;
    private RefundsAdapter refundsAdapter;
    private RefundsContract.Presenter presenter;

    public static RefundsFragment newInstance() {
        return new RefundsFragment();
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.refundsAdapter = new RefundsAdapter(new ArrayList<Refund>(0));
        this.refundsAdapter.setOnScrolledToBottomListener(this);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View root = inflater.inflate(R.layout.refunds_fragment_layout, container, false);
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.getContext());
        this.refundsListView = (RecyclerView)root.findViewById(R.id.refunds_list);
        this.refundsListView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.refundsListView.setHasFixedSize(true);
        this.refundsListView.setAdapter((RecyclerView.Adapter)this.refundsAdapter);
        this.noRefundsView = root.findViewById(R.id.no_refunds);
        return root;
    }

    @Override
    public void setPresenter(@NonNull RefundsContract.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void showRefunds(List<Refund> refunds) {
        this.refundsAdapter.replaceData(refunds);
        this.refundsListView.setVisibility(0);
        this.noRefundsView.setVisibility(8);
    }

    public void onResume() {
        super.onResume();
        this.presenter.start();
    }

    @Override
    public void showEmptyList() {
        this.refundsListView.setVisibility(8);
        this.noRefundsView.setVisibility(0);
    }

    @Override
    public void showError(Throwable error) {
        Toast.makeText((Context)this.getContext(), (CharSequence)error.getLocalizedMessage(), (int)0).show();
    }

    @Override
    public void setAllDataAreLoaded() {
        this.refundsAdapter.disableLoadMore();
    }

    @Override
    public void onScrolledToBottom() {
        this.presenter.loadMore();
    }
}

