/*
 * Decompiled with CFR 0.152.
 */
package com.walletone.p2pui.payouts;

import android.support.annotation.NonNull;
import com.walletone.p2pui.payouts.PayoutsContract;
import com.walletone.sdk.P2PCore;
import com.walletone.sdk.library.CompleteHandler;
import com.walletone.sdk.models.Payout;
import com.walletone.sdk.models.PayoutResult;
import java.util.ArrayList;
import java.util.List;

public class PayoutsPresenter
implements PayoutsContract.Presenter {
    private String dealId;
    private boolean firstLoad = true;
    private boolean isLoading = false;
    private boolean isLoadMoreInProgress = false;
    private boolean isAllowLoadMore = true;
    private Integer pageNumber = 0;
    private Integer itemsPerPage = 10;
    private List<Payout> payouts;
    private PayoutsContract.View payoutsView;

    public PayoutsPresenter(@NonNull String dealId, @NonNull PayoutsContract.View payoutsView) {
        this.dealId = dealId;
        this.payoutsView = payoutsView;
        this.payoutsView.setPresenter(this);
    }

    @Override
    public void start() {
        this.loadPayouts(false);
    }

    @Override
    public void loadPayouts(boolean forceUpdate) {
        this.loadPayouts(forceUpdate || this.firstLoad, true);
        this.firstLoad = false;
    }

    private void loadPayouts(boolean forceUpdate, boolean showLoadingUI) {
        CompleteHandler<PayoutResult, Throwable> handler = new CompleteHandler<PayoutResult, Throwable>(){

            public void completed(PayoutResult list, Throwable error) {
                PayoutsPresenter.this.isLoading = false;
                if (error == null) {
                    List payoutsList = list.getPayouts();
                    PayoutsPresenter.this.pageNumber = PayoutsPresenter.this.pageNumber + 1;
                    PayoutsPresenter.this.isAllowLoadMore = payoutsList.size() >= PayoutsPresenter.this.itemsPerPage;
                    if (!PayoutsPresenter.this.isAllowLoadMore) {
                        PayoutsPresenter.this.payoutsView.setAllDataAreLoaded();
                    }
                    PayoutsPresenter.this.payouts = payoutsList;
                    if (PayoutsPresenter.this.payouts.size() > 0) {
                        PayoutsPresenter.this.payoutsView.showPayouts(PayoutsPresenter.this.payouts);
                    } else {
                        PayoutsPresenter.this.payoutsView.showEmptyList();
                    }
                } else {
                    PayoutsPresenter.this.payoutsView.showError(error);
                }
            }
        };
        this.isLoading = true;
        this.payouts = new ArrayList<Payout>();
        this.pageNumber = 1;
        P2PCore.INSTANCE.payoutsManager.payouts(this.pageNumber.intValue(), this.itemsPerPage.intValue(), this.dealId, (CompleteHandler)handler);
    }

    @Override
    public void loadMore() {
        CompleteHandler<PayoutResult, Throwable> handler = new CompleteHandler<PayoutResult, Throwable>(){

            public void completed(PayoutResult list, Throwable error) {
                PayoutsPresenter.this.isLoadMoreInProgress = false;
                if (error == null) {
                    List payoutsList = list.getPayouts();
                    PayoutsPresenter.this.payouts.addAll(payoutsList);
                    PayoutsPresenter.this.pageNumber = PayoutsPresenter.this.pageNumber + 1;
                    PayoutsPresenter.this.isAllowLoadMore = !payoutsList.isEmpty() && payoutsList.size() >= PayoutsPresenter.this.itemsPerPage;
                    if (!PayoutsPresenter.this.isAllowLoadMore) {
                        PayoutsPresenter.this.payoutsView.setAllDataAreLoaded();
                    }
                    if (PayoutsPresenter.this.payouts.size() > 0) {
                        PayoutsPresenter.this.payoutsView.showPayouts(PayoutsPresenter.this.payouts);
                    }
                } else {
                    PayoutsPresenter.this.payoutsView.showError(error);
                }
            }
        };
        if (this.isAllowLoadMore) {
            P2PCore.INSTANCE.payoutsManager.payouts(this.pageNumber.intValue(), this.itemsPerPage.intValue(), this.dealId, (CompleteHandler)handler);
        }
    }
}

