/*
 * Decompiled with CFR 0.152.
 */
package com.walletone.p2pui.paydeal;

import android.graphics.Bitmap;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.view.MenuItem;
import android.webkit.ConsoleMessage;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import com.walletone.p2pui.R;
import com.walletone.p2pui.W1P2PToolbar;
import com.walletone.sdk.P2PCore;
import com.walletone.sdk.models.RequestBuilder;
import java.io.UnsupportedEncodingException;

public class PayDealActivity
extends AppCompatActivity {
    public static final String ARG_AUTH_DATA = "PayDealActivity.ARG_AUTH_DATA";
    public static final String ARG_DEAL_ID = "PayDealActivity.ARG_DEAL_ID";
    public static final int RESULT_FAIL = 2;
    private final String RETURN_HOST = "p2p-success-pay-deal";
    public static final int REQUEST_PAY_DEAL = 2;
    private boolean isVisible = false;
    private boolean needFinish = false;
    private WebView payDealWebView;
    private ProgressBar progressBar;
    private FrameLayout progressFrame;
    private Boolean redirectToPaymentToolAddition = false;
    private boolean finishEventDispatched = false;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.pay_deal_activity_layout);
        W1P2PToolbar.installToolBar(this);
        this.payDealWebView = (WebView)this.findViewById(R.id.pay_deal_web_view);
        this.progressFrame = (FrameLayout)this.findViewById(R.id.progressFrame);
        this.progressBar = (ProgressBar)this.findViewById(R.id.progress);
        this.progressBar.setMax(100);
        String authData = this.getIntent().getStringExtra(ARG_AUTH_DATA);
        String dealId = this.getIntent().getStringExtra(ARG_DEAL_ID);
        RequestBuilder request = P2PCore.INSTANCE.dealsManager.payRequest(dealId, null, this.redirectToPaymentToolAddition, authData, "http://p2p-success-pay-deal");
        P2PCore.INSTANCE.printDebug("=======");
        P2PCore.INSTANCE.printDebug("PayDeal");
        P2PCore.INSTANCE.printDebug("Method: " + request.getMethodType().getMethodTypeId() + " / " + request.getUrlString());
        P2PCore.INSTANCE.printDebug("Http body:");
        P2PCore.INSTANCE.printDebug(request.getHttpBody());
        try {
            String postData = request.getHttpBody();
            this.payDealWebView.setWebViewClient((WebViewClient)new MyWebViewClient());
            this.setupWebView();
            this.payDealWebView.postUrl(request.getUrlString(), postData.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    private void setupWebView() {
        WebSettings wbs = this.payDealWebView.getSettings();
        wbs.setPluginState(WebSettings.PluginState.ON);
        wbs.setSaveFormData(true);
        wbs.setDomStorageEnabled(true);
        wbs.setJavaScriptEnabled(true);
        wbs.setBuiltInZoomControls(true);
        wbs.setAllowFileAccess(true);
        wbs.setSupportZoom(true);
        this.payDealWebView.setWebViewClient((WebViewClient)new MyWebViewClient());
        this.payDealWebView.setWebChromeClient(new WebChromeClient(){

            public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
                return true;
            }
        });
        this.payDealWebView.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int newProgress) {
                PayDealActivity.this.progressBar.setProgress(newProgress);
                if (newProgress == 100) {
                    PayDealActivity.this.progressFrame.setVisibility(8);
                }
                super.onProgressChanged(view, newProgress);
            }
        });
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        LinearLayout toolBarContainer = (LinearLayout)this.findViewById(R.id.container);
        int[] location = new int[2];
        toolBarContainer.getLocationOnScreen(location);
        int locationY = location[1];
        if (locationY <= 0) {
            toolBarContainer.setY((float)this.getStatusBarHeight());
        }
    }

    public int getStatusBarHeight() {
        int result = 0;
        int resourceId = this.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = this.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }

    private boolean checkUrl(String url) {
        if (url == null) {
            url = "";
        }
        url = url.toLowerCase();
        boolean handled = false;
        if (!this.finishEventDispatched && url.equals("http://p2p-success-pay-deal/")) {
            handled = true;
            this.finishEventDispatched = true;
            this.onResultSuccess();
        }
        return handled;
    }

    public void onResultSuccess() {
        this.setResult(-1);
        this.finish();
    }

    public void onResultFail() {
        this.setResult(2);
        this.finish();
    }

    protected void onResume() {
        super.onResume();
        this.isVisible = true;
        if (this.needFinish) {
            this.finish();
            this.needFinish = false;
        }
    }

    protected void onPause() {
        super.onPause();
        this.isVisible = false;
    }

    public void onBackPressed() {
        if (this.isVisible) {
            super.onBackPressed();
        } else {
            this.needFinish = true;
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                super.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private class MyWebViewClient
    extends WebViewClient {
        private String pendingUrl;

        private MyWebViewClient() {
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            if (this.pendingUrl == null) {
                this.pendingUrl = url;
            }
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            PayDealActivity.this.progressFrame.setVisibility(0);
            return PayDealActivity.this.checkUrl(url);
        }

        public void onPageFinished(WebView view, String url) {
            if (url == null) {
                url = "";
            }
            PayDealActivity.this.checkUrl(url);
            if (!url.equals(this.pendingUrl)) {
                this.pendingUrl = null;
            }
        }
    }
}

