/*
 * Decompiled with CFR 0.152.
 */
package com.walletone.p2pui.payouts;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.support.v4.util.Preconditions;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.walletone.p2pui.R;
import com.walletone.sdk.models.Payout;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;

public class PayoutsAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private final int VIEW_TYPE_ITEM = 1;
    private final int VIEW_TYPE_PROGRESSBAR = 0;
    private boolean isFooterEnabled = true;
    private List<Payout> payouts;
    private OnScrolledToBottomListener onScrolledToBottomListener;

    public PayoutsAdapter(List<Payout> payouts) {
        this.payouts = payouts;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 0) {
            View view = this.createProgressView(parent);
            return new ProgressViewHolder(view);
        }
        return new ViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.payout_item, parent, false)){};
    }

    private View createProgressView(ViewGroup parent) {
        return LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.progress_item, parent, false);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (this.payouts.size() > 0 && position < this.payouts.size()) {
            ((ViewHolder)holder).setData(this.payouts.get(position));
        }
        if (position > 0 && position >= this.payouts.size() && this.onScrolledToBottomListener != null) {
            this.onScrolledToBottomListener.onScrolledToBottom();
        }
    }

    public int getItemCount() {
        return this.isFooterEnabled ? this.payouts.size() + 1 : this.payouts.size();
    }

    public int getItemViewType(int position) {
        return this.isFooterEnabled && position >= this.payouts.size() ? 0 : 1;
    }

    public void replaceData(List<Payout> payouts) {
        this.setList(payouts);
        this.notifyDataSetChanged();
    }

    @SuppressLint(value={"RestrictedApi"})
    private void setList(List<Payout> payouts) {
        this.payouts = (List)Preconditions.checkNotNull(payouts);
    }

    public void disableLoadMore() {
        this.isFooterEnabled = false;
    }

    public void setOnScrolledToBottomListener(OnScrolledToBottomListener onScrolledToBottomListener) {
        this.onScrolledToBottomListener = onScrolledToBottomListener;
    }

    public static interface OnScrolledToBottomListener {
        public void onScrolledToBottom();
    }

    public class ProgressViewHolder
    extends RecyclerView.ViewHolder {
        public ProgressBar progressBar;

        public ProgressViewHolder(View itemView) {
            super(itemView);
            this.progressBar = (ProgressBar)itemView.findViewById(R.id.load_more_progress_bar);
            this.progressBar.setIndeterminate(true);
        }
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        private TextView state;
        private TextView date;
        private TextView amount;
        private Payout payout;

        public ViewHolder(View itemView) {
            super(itemView);
            this.state = (TextView)itemView.findViewById(R.id.payout_state);
            this.date = (TextView)itemView.findViewById(R.id.payout_date);
            this.amount = (TextView)itemView.findViewById(R.id.payout_amount);
        }

        public void setData(Payout payout) {
            this.payout = payout;
            switch (payout.getPayoutStateId()) {
                case "Accepted": {
                    this.displayAcceptedState(this.itemView);
                    break;
                }
                case "Processing": {
                    this.displayProcessingState(this.itemView);
                    break;
                }
                case "ProcessError": {
                    this.displayErrorState(this.itemView);
                }
            }
            SimpleDateFormat df = new SimpleDateFormat("dd.MM.yy HH:mm", Locale.getDefault());
            this.date.setText((CharSequence)df.format(payout.getCreateDate()));
            DecimalFormat decFormat = new DecimalFormat(payout.getCurrencyId().getSymbol() + " ###.##");
            String number = decFormat.format(payout.getAmount());
            this.amount.setText((CharSequence)number);
        }

        private void displayErrorState(View view) {
            this.state.setText(R.string.payout_error_state);
            this.amount.setTextColor(-65536);
        }

        private void displayProcessingState(View view) {
            this.state.setText(R.string.payout_precessing_state);
            this.amount.setTextColor(ContextCompat.getColor((Context)view.getContext(), (int)R.color.processing_state_color));
        }

        private void displayAcceptedState(View view) {
            this.state.setText(R.string.payout_accepted_state);
            this.amount.setTextColor(ContextCompat.getColor((Context)view.getContext(), (int)R.color.accepted_state_color));
        }
    }
}

