/*
 * Decompiled with CFR 0.152.
 */
package com.walletone.p2pui.paymenttool;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.util.Preconditions;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.walletone.p2pui.R;
import com.walletone.p2pui.library.CreditCardValidator.CreditCardValidator;
import com.walletone.p2pui.library.PaymentToolType;
import com.walletone.p2pui.loaders.DownloadImageTask;
import com.walletone.p2pui.paymenttool.PaymentToolFragment;
import com.walletone.sdk.models.PaymentTool;
import java.util.List;
import java.util.Locale;

public class PaymentToolAdapter
extends RecyclerView.Adapter<ItemViewHolder> {
    public static final String IMAGE_URL_FOR_DOWNLOAD = "https://www.walletone.com/logo/paymenttype/%s.png?type=pt&w=50&h=50";
    private Context context;
    private CreditCardValidator validator;
    private List<PaymentTool> paymentTools;
    private PaymentToolFragment.PaymentToolItemListener itemListener;

    public PaymentToolAdapter(@NonNull List<PaymentTool> paymentTools, PaymentToolFragment.PaymentToolItemListener itemListener, Context context) {
        this.paymentTools = paymentTools;
        this.itemListener = itemListener;
        this.context = context;
        this.validator = new CreditCardValidator();
    }

    public void replaceData(List<PaymentTool> paymentTools) {
        this.setList(paymentTools);
        this.notifyDataSetChanged();
    }

    @SuppressLint(value={"RestrictedApi"})
    private void setList(List<PaymentTool> paymentTools) {
        this.paymentTools = (List)Preconditions.checkNotNull(paymentTools);
    }

    public ItemViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new ItemViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.payment_tool_item, parent, false)){};
    }

    public void onBindViewHolder(ItemViewHolder holder, int position) {
        PaymentTool paymentTool = this.paymentTools.get(position);
        PaymentToolType toolType = PaymentToolType.getPaymentToolNameByPaymentTypeId(paymentTool.getPaymentTypeId());
        holder.title.setText((CharSequence)this.context.getString(toolType.getLocalizedName()));
        String imageUrl = String.format(Locale.US, IMAGE_URL_FOR_DOWNLOAD, paymentTool.getPaymentTypeId());
        new DownloadImageTask(holder.image).execute(new String[]{imageUrl});
        holder.number.setText((CharSequence)paymentTool.getMask());
        holder.setPaymentTool(paymentTool);
        holder.setOnPaymentToolItemClickListener(this.itemListener);
    }

    public int getItemCount() {
        return this.paymentTools.size();
    }

    public void removeItem(int position) {
        this.paymentTools.remove(position);
        this.notifyItemRemoved(position);
    }

    public static class ItemViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener {
        ImageView image;
        TextView title;
        TextView number;
        PaymentToolFragment.PaymentToolItemListener itemListener;
        PaymentTool paymentTool;

        ItemViewHolder(View v) {
            super(v);
            this.image = (ImageView)v.findViewById(R.id.payment_tool_logo);
            this.title = (TextView)v.findViewById(R.id.payment_tool_title);
            this.number = (TextView)v.findViewById(R.id.card_number);
            v.setOnClickListener((View.OnClickListener)this);
        }

        public void setPaymentTool(PaymentTool paymentTool) {
            this.paymentTool = paymentTool;
        }

        public PaymentTool getPaymentTool() {
            return this.paymentTool;
        }

        public void setOnPaymentToolItemClickListener(PaymentToolFragment.PaymentToolItemListener itemListener) {
            this.itemListener = itemListener;
        }

        public void onClick(View view) {
            if (this.itemListener != null) {
                this.itemListener.onPaymentToolClick(this.paymentTool);
            }
        }
    }
}

