/*
 * Decompiled with CFR 0.152.
 */
package com.walletone.p2pui.library.CreditCardValidator;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public enum CreditCardType {
    AMEX("Amex", "^3[47][0-9]{5,}$"),
    VISA("Visa", "^4\\d{0,}$"),
    MASTERCARD("MasterCard", "^5[1-5]\\d{0,14}$"),
    MAESTRO("Maestro", "^(?:5[0678]\\d\\d|6304|6390|67\\d\\d)\\d{8,15}$"),
    DINERS_CLUB("Diners Club", "^3(?:0[0-5]|[68][0-9])[0-9]{4,}$"),
    JCB("JCB", "^(?:2131|1800|35[0-9]{3})[0-9]{3,}$"),
    DISCOVER("Discover", "^6(?:011|5[0-9]{2})[0-9]{3,}$"),
    UNIONPAY("UnionPay", "^62[0-5]\\d{13,16}$"),
    MIR("Mir", "^22[0-9]{1,14}$"),
    UNDEFINED("", "");

    private String title;
    private String regEx;
    private static Map<String, String> types;

    private CreditCardType(String title, String regEx) {
        this.title = title;
        this.regEx = regEx;
    }

    public String getTitle() {
        return this.title;
    }

    public String getRegEx() {
        return this.regEx;
    }

    public static CreditCardType type(String from) {
        for (CreditCardType type : CreditCardType.values()) {
            String numbersString;
            Pattern pattern = Pattern.compile(type.regEx);
            if (!pattern.matcher(numbersString = CreditCardType.onlyNumbers(from)).matches()) continue;
            return type;
        }
        return UNDEFINED;
    }

    static String onlyNumbers(String src) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            if (!Character.isDigit(c)) continue;
            builder.append(c);
        }
        return builder.toString();
    }

    static {
        types = new HashMap<String, String>();
        for (CreditCardType type : CreditCardType.values()) {
            types.put(type.title, type.regEx);
        }
    }
}

