/*
 * Decompiled with CFR 0.152.
 */
package com.walletone.p2pui.payouts;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.walletone.p2pui.R;
import com.walletone.p2pui.payouts.PayoutsAdapter;
import com.walletone.p2pui.payouts.PayoutsContract;
import com.walletone.sdk.models.Payout;
import java.util.ArrayList;
import java.util.List;

public class PayoutsFragment
extends Fragment
implements PayoutsContract.View,
PayoutsAdapter.OnScrolledToBottomListener {
    private View noPayoutsView;
    private RecyclerView payoutsListView;
    private PayoutsAdapter payoutsAdapter;
    private PayoutsContract.Presenter presenter;

    public static PayoutsFragment newInstance() {
        return new PayoutsFragment();
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.payoutsAdapter = new PayoutsAdapter(new ArrayList<Payout>(0));
        this.payoutsAdapter.setOnScrolledToBottomListener(this);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View root = inflater.inflate(R.layout.payouts_fragment_layout, container, false);
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.getContext());
        this.payoutsListView = (RecyclerView)root.findViewById(R.id.payouts_list2);
        this.payoutsListView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.payoutsListView.setAdapter((RecyclerView.Adapter)this.payoutsAdapter);
        this.noPayoutsView = root.findViewById(R.id.no_payouts);
        return root;
    }

    @Override
    public void setPresenter(@NonNull PayoutsContract.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void showPayouts(List<Payout> payouts) {
        this.payoutsAdapter.replaceData(payouts);
        this.payoutsListView.setVisibility(0);
        this.noPayoutsView.setVisibility(8);
    }

    public void onResume() {
        super.onResume();
        this.presenter.start();
    }

    @Override
    public void showEmptyList() {
        this.payoutsListView.setVisibility(8);
        this.noPayoutsView.setVisibility(0);
    }

    @Override
    public void setAllDataAreLoaded() {
        this.payoutsAdapter.disableLoadMore();
    }

    @Override
    public void onScrolledToBottom() {
        this.presenter.loadMore();
    }
}

