/*
 * Decompiled with CFR 0.152.
 */
package com.walletone.p2pui.paymenttool;

import android.support.annotation.NonNull;
import com.walletone.p2pui.paymenttool.PaymentToolContract;
import com.walletone.sdk.P2PCore;
import com.walletone.sdk.library.CompleteErrorOnlyHandler;
import com.walletone.sdk.library.CompleteHandler;
import com.walletone.sdk.models.PaymentTool;
import com.walletone.sdk.models.PaymentToolsResult;
import java.util.ArrayList;
import java.util.List;

public class PaymentToolPresenter
implements PaymentToolContract.Presenter {
    private Owner owner;
    private PaymentToolContract.View paymentToolView;
    private boolean firstLoad = true;
    private boolean isLoading = false;
    private boolean isAddPaymentToolAvailable = false;
    private List<PaymentTool> paymentTools;

    public PaymentToolPresenter(@NonNull Owner owner, @NonNull PaymentToolContract.View view) {
        this.owner = owner;
        this.paymentToolView = view;
        this.paymentToolView.setPresenter(this);
    }

    @Override
    public void start() {
        this.loadPaymentTools(false);
    }

    @Override
    public void loadPaymentTools(boolean forceUpdate) {
        this.loadPaymentTools(forceUpdate || this.firstLoad, true);
        this.firstLoad = false;
    }

    private void loadPaymentTools(boolean forceUpdate, boolean showLoadingUI) {
        this.paymentToolView.setLoadingIndicator(true);
        CompleteHandler<PaymentToolsResult, Throwable> handler = new CompleteHandler<PaymentToolsResult, Throwable>(){

            public void completed(PaymentToolsResult result, Throwable error) {
                List paymentToolsList = result.getPaymentTools();
                PaymentToolPresenter.this.paymentToolView.setLoadingIndicator(false);
                PaymentToolPresenter.this.isLoading = false;
                if (error == null) {
                    PaymentToolPresenter.this.paymentTools = paymentToolsList != null ? paymentToolsList : new ArrayList();
                    if (PaymentToolPresenter.this.paymentTools.size() > 0) {
                        PaymentToolPresenter.this.paymentToolView.showPaymentTools(PaymentToolPresenter.this.paymentTools);
                    } else {
                        PaymentToolPresenter.this.paymentToolView.showEmptyList();
                    }
                } else {
                    PaymentToolPresenter.this.paymentToolView.showError(error);
                }
            }
        };
        this.isLoading = true;
        this.paymentTools = new ArrayList<PaymentTool>();
        switch (this.owner) {
            case BENEFICIARY: {
                P2PCore.INSTANCE.beneficiariesPaymentTools.paymentTools((CompleteHandler)handler);
                break;
            }
            case PAYER: {
                P2PCore.INSTANCE.payersPaymentTools.paymentTools((CompleteHandler)handler);
            }
        }
    }

    @Override
    public void addNewPaymentTool() {
        switch (this.owner) {
            case BENEFICIARY: {
                this.paymentToolView.showLinkPaymentToolActivity();
                break;
            }
            case PAYER: {
                this.paymentToolView.closePaymentToolAndShowPayDealActivity();
            }
        }
    }

    @Override
    public boolean isAddNewPaymentToolAvailable() {
        return this.isAddPaymentToolAvailable || this.owner == Owner.BENEFICIARY;
    }

    @Override
    public void setAddPaymentToolAvailable(boolean isAvailable) {
        this.isAddPaymentToolAvailable = isAvailable;
    }

    @Override
    public void deletePaymentTool(final PaymentTool paymentTool) {
        CompleteErrorOnlyHandler<Throwable> callback = new CompleteErrorOnlyHandler<Throwable>(){

            public void completed(Throwable error) {
                if (error == null) {
                    PaymentToolPresenter.this.paymentTools.remove(paymentTool);
                } else {
                    PaymentToolPresenter.this.paymentToolView.showError(error);
                }
            }
        };
        switch (this.owner) {
            case BENEFICIARY: {
                P2PCore.INSTANCE.beneficiariesPaymentTools.delete(paymentTool.getPaymentToolId().intValue(), (CompleteErrorOnlyHandler)callback);
                break;
            }
            case PAYER: {
                P2PCore.INSTANCE.payersPaymentTools.delete(paymentTool.getPaymentToolId(), (CompleteErrorOnlyHandler)callback);
            }
        }
    }

    public static enum Owner {
        BENEFICIARY,
        PAYER;

    }
}

