/*
 * Decompiled with CFR 0.152.
 */
package com.walletone.p2pui.refunds;

import android.support.annotation.NonNull;
import com.walletone.p2pui.refunds.RefundsContract;
import com.walletone.sdk.P2PCore;
import com.walletone.sdk.library.CompleteHandler;
import com.walletone.sdk.models.Refund;
import com.walletone.sdk.models.RefundsResult;
import java.util.ArrayList;
import java.util.List;

public class RefundsPresenter
implements RefundsContract.Presenter {
    private String dealId;
    private boolean firstLoad = true;
    private boolean isLoading = false;
    private boolean isLoadMoreInProgress = false;
    private boolean isAllowLoadMore = true;
    private Integer pageNumber = 0;
    private Integer itemsPerPage = 10;
    private List<Refund> refunds;
    private RefundsContract.View refundsView;

    public RefundsPresenter(@NonNull String dealId, @NonNull RefundsContract.View refundsView) {
        this.dealId = dealId;
        this.refundsView = refundsView;
        this.refundsView.setPresenter(this);
    }

    @Override
    public void start() {
        this.loadRefunds(false);
    }

    @Override
    public void loadRefunds(boolean forceUpdate) {
        this.loadRefunds(forceUpdate || this.firstLoad, true);
        this.firstLoad = false;
    }

    private void loadRefunds(boolean forceUpdate, boolean showLoadingUI) {
        CompleteHandler<RefundsResult, Throwable> handler = new CompleteHandler<RefundsResult, Throwable>(){

            public void completed(RefundsResult list, Throwable error) {
                RefundsPresenter.this.isLoading = false;
                if (error == null) {
                    List refundsList = list.getRefunds();
                    RefundsPresenter.this.pageNumber = RefundsPresenter.this.pageNumber + 1;
                    RefundsPresenter.this.isAllowLoadMore = refundsList.size() >= RefundsPresenter.this.itemsPerPage;
                    if (!RefundsPresenter.this.isAllowLoadMore) {
                        RefundsPresenter.this.refundsView.setAllDataAreLoaded();
                    }
                    RefundsPresenter.this.refunds = refundsList;
                    if (RefundsPresenter.this.refunds.size() > 0) {
                        RefundsPresenter.this.refundsView.showRefunds(RefundsPresenter.this.refunds);
                    } else {
                        RefundsPresenter.this.refundsView.showEmptyList();
                    }
                } else {
                    RefundsPresenter.this.refundsView.showError(error);
                }
            }
        };
        this.isLoading = true;
        this.refunds = new ArrayList<Refund>();
        this.pageNumber = 1;
        P2PCore.INSTANCE.refundsManager.refunds(this.pageNumber.intValue(), this.itemsPerPage.intValue(), this.dealId, (CompleteHandler)handler);
    }

    @Override
    public void loadMore() {
        CompleteHandler<RefundsResult, Throwable> handler = new CompleteHandler<RefundsResult, Throwable>(){

            public void completed(RefundsResult list, Throwable var2) {
                List refundsList = list.getRefunds();
                RefundsPresenter.this.isLoadMoreInProgress = false;
                RefundsPresenter.this.refunds.addAll(refundsList);
                RefundsPresenter.this.pageNumber = RefundsPresenter.this.pageNumber + 1;
                RefundsPresenter.this.isAllowLoadMore = !refundsList.isEmpty() && refundsList.size() >= RefundsPresenter.this.itemsPerPage;
                if (!RefundsPresenter.this.isAllowLoadMore) {
                    RefundsPresenter.this.refundsView.setAllDataAreLoaded();
                }
                if (RefundsPresenter.this.refunds.size() > 0) {
                    RefundsPresenter.this.refundsView.showRefunds(RefundsPresenter.this.refunds);
                }
            }
        };
        if (this.isAllowLoadMore) {
            P2PCore.INSTANCE.refundsManager.refunds(this.pageNumber.intValue(), this.itemsPerPage.intValue(), this.dealId, (CompleteHandler)handler);
        }
    }
}

