/*
 * Decompiled with CFR 0.152.
 */
package com.walletone.p2pui.refunds;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.support.v4.util.Preconditions;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.walletone.p2pui.R;
import com.walletone.sdk.models.Refund;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;

public class RefundsAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private final int VIEW_TYPE_ITEM = 1;
    private final int VIEW_TYPE_PROGRESSBAR = 0;
    private boolean isFooterEnabled = true;
    private List<Refund> refunds;
    private OnScrolledToBottomListener onScrolledToBottomListener;

    public RefundsAdapter(List<Refund> refunds) {
        this.refunds = refunds;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 0) {
            View view = this.createProgressView(parent);
            return new ProgressViewHolder(view);
        }
        return new ViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.refund_item, parent, false)){};
    }

    private View createProgressView(ViewGroup parent) {
        return LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.progress_item, parent, false);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (this.refunds.size() > 0 && position < this.refunds.size()) {
            ((ViewHolder)holder).setData(this.refunds.get(position));
        }
        if (position > 0 && position >= this.refunds.size() && this.onScrolledToBottomListener != null) {
            this.onScrolledToBottomListener.onScrolledToBottom();
        }
    }

    public int getItemCount() {
        return this.isFooterEnabled ? this.refunds.size() + 1 : this.refunds.size();
    }

    public int getItemViewType(int position) {
        return this.isFooterEnabled && position >= this.refunds.size() ? 0 : 1;
    }

    public void replaceData(List<Refund> refunds) {
        this.setList(refunds);
        this.notifyDataSetChanged();
    }

    @SuppressLint(value={"RestrictedApi"})
    private void setList(List<Refund> refunds) {
        this.refunds = (List)Preconditions.checkNotNull(refunds);
    }

    public void disableLoadMore() {
        this.isFooterEnabled = false;
    }

    public void setOnScrolledToBottomListener(OnScrolledToBottomListener onScrolledToBottomListener) {
        this.onScrolledToBottomListener = onScrolledToBottomListener;
    }

    public static interface OnScrolledToBottomListener {
        public void onScrolledToBottom();
    }

    public class ProgressViewHolder
    extends RecyclerView.ViewHolder {
        public ProgressBar progressBar;

        public ProgressViewHolder(View itemView) {
            super(itemView);
            this.progressBar = (ProgressBar)itemView.findViewById(R.id.load_more_progress_bar);
            this.progressBar.setIndeterminate(true);
        }
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        private TextView state;
        private TextView date;
        private TextView amount;

        ViewHolder(View itemView) {
            super(itemView);
            this.state = (TextView)itemView.findViewById(R.id.refund_state);
            this.date = (TextView)itemView.findViewById(R.id.refund_date);
            this.amount = (TextView)itemView.findViewById(R.id.refund_amount);
        }

        public void setData(Refund refund) {
            switch (refund.getRefundStateId()) {
                case "Accepted": {
                    this.displayAcceptedState(this.itemView);
                    break;
                }
                case "Processing": {
                    this.displayProcessingState(this.itemView);
                    break;
                }
                case "ProcessError": {
                    this.displayErrorState(this.itemView);
                }
            }
            SimpleDateFormat df = new SimpleDateFormat("dd.MM.yy HH:mm", Locale.getDefault());
            this.date.setText((CharSequence)df.format(refund.getCreateDate()));
            DecimalFormat decFormat = new DecimalFormat(refund.getCurrencyId().getSymbol() + " ###.##");
            String number = decFormat.format(refund.getAmount());
            this.amount.setText((CharSequence)number);
        }

        private void displayErrorState(View view) {
            this.state.setText(R.string.refund_error_state);
            this.amount.setTextColor(-65536);
        }

        private void displayProcessingState(View view) {
            this.state.setText(R.string.refund_precessing_state);
            this.amount.setTextColor(ContextCompat.getColor((Context)view.getContext(), (int)R.color.processing_state_color));
        }

        private void displayAcceptedState(View view) {
            this.state.setText(R.string.refund_accepted_state);
            this.amount.setTextColor(ContextCompat.getColor((Context)view.getContext(), (int)R.color.accepted_state_color));
        }
    }
}

