/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.ads.android.data;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import com.unity3d.ads.android.UnityAdsDeviceLog;
import com.unity3d.ads.android.UnityAdsUtils;
import com.unity3d.ads.android.data.UnityAdsAdvertisingId;
import com.unity3d.ads.android.properties.UnityAdsProperties;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

@TargetApi(value=9)
public class UnityAdsDevice {
    public static String getSoftwareVersion() {
        return "" + Build.VERSION.SDK_INT;
    }

    public static String getHardwareVersion() {
        return Build.MANUFACTURER + " " + Build.MODEL;
    }

    public static int getDeviceType() {
        return UnityAdsProperties.APPLICATION_CONTEXT.getResources().getConfiguration().screenLayout;
    }

    @SuppressLint(value={"DefaultLocale"})
    public static String getAndroidId(boolean bl) {
        String string;
        try {
            string = Settings.Secure.getString((ContentResolver)UnityAdsProperties.APPLICATION_CONTEXT.getContentResolver(), (String)"android_id");
            if (bl) {
                string = UnityAdsUtils.Md5(string).toLowerCase();
            }
        }
        catch (Exception exception) {
            UnityAdsDeviceLog.error("Problems fetching androidId: " + exception.getMessage());
            string = "unknown";
        }
        return string;
    }

    public static String getAdvertisingTrackingId() {
        return UnityAdsAdvertisingId.getAdvertisingTrackingId();
    }

    public static boolean isLimitAdTrackingEnabled() {
        return UnityAdsAdvertisingId.getLimitedAdTracking();
    }

    public static String getConnectionType() {
        if (UnityAdsDevice.isUsingWifi()) {
            return "wifi";
        }
        return "cellular";
    }

    public static boolean isUsingWifi() {
        ConnectivityManager connectivityManager = (ConnectivityManager)UnityAdsProperties.APPLICATION_CONTEXT.getSystemService("connectivity");
        if (connectivityManager == null) {
            return false;
        }
        TelephonyManager telephonyManager = (TelephonyManager)UnityAdsProperties.APPLICATION_CONTEXT.getSystemService("phone");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !connectivityManager.getBackgroundDataSetting() || !connectivityManager.getActiveNetworkInfo().isConnected() || telephonyManager == null) {
            return false;
        }
        return networkInfo.getType() == 1 && networkInfo.isConnected();
    }

    public static int getNetworkType() {
        return ((TelephonyManager)UnityAdsProperties.APPLICATION_CONTEXT.getSystemService("phone")).getNetworkType();
    }

    public static int getScreenDensity() {
        return UnityAdsProperties.APPLICATION_CONTEXT.getResources().getDisplayMetrics().densityDpi;
    }

    public static int getScreenSize() {
        return UnityAdsDevice.getDeviceType();
    }

    private static JSONArray a(Map map) {
        if (map == null || map.size() == 0) {
            return null;
        }
        PackageManager packageManager = UnityAdsProperties.APPLICATION_CONTEXT.getPackageManager();
        JSONArray jSONArray = null;
        for (PackageInfo packageInfo : packageManager.getInstalledPackages(0)) {
            try {
                String string;
                if (packageInfo.packageName == null || packageInfo.packageName.length() <= 0 || !map.containsKey(string = UnityAdsUtils.Md5(packageInfo.packageName))) continue;
                map.get(string);
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("id", map.get(string));
                if (packageInfo.firstInstallTime > 0L) {
                    jSONObject.put("timestamp", packageInfo.firstInstallTime);
                }
                if (jSONArray == null) {
                    jSONArray = new JSONArray();
                }
                jSONArray.put((Object)jSONObject);
            }
            catch (Exception exception) {
                UnityAdsDeviceLog.debug("Exception when processing package " + packageInfo.packageName + " " + exception);
            }
        }
        return jSONArray;
    }

    public static String getPackageDataJson(Map map) {
        if ((map = UnityAdsDevice.a(map)) == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("games", (Object)map);
            return jSONObject.toString();
        }
        catch (Exception exception) {
            UnityAdsDeviceLog.debug("Exception in getPackageDataJson" + exception);
            return null;
        }
    }

    public static boolean isActiveNetworkConnected() {
        ConnectivityManager connectivityManager = (ConnectivityManager)UnityAdsProperties.APPLICATION_CONTEXT.getSystemService("connectivity");
        if (connectivityManager != null) {
            return (connectivityManager = connectivityManager.getActiveNetworkInfo()) != null && connectivityManager.isConnected();
        }
        return false;
    }
}

