/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.ads.android.cache;

import android.annotation.TargetApi;
import android.os.Build;
import com.unity3d.ads.android.UnityAdsDeviceLog;
import com.unity3d.ads.android.cache.a;
import com.unity3d.ads.android.cache.b;
import com.unity3d.ads.android.campaign.UnityAdsCampaign;
import com.unity3d.ads.android.properties.UnityAdsProperties;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@TargetApi(value=9)
public class UnityAdsCache {
    private static File a = null;

    public static void initialize(ArrayList iterator) {
        if (iterator == null || ((ArrayList)((Object)iterator)).size() == 0) {
            return;
        }
        UnityAdsDeviceLog.debug("Unity Ads cache: initializing cache with " + ((ArrayList)((Object)iterator)).size() + " campaigns");
        UnityAdsCache.stopAllDownloads();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Long> hashMap2 = new HashMap<String, Long>();
        boolean bl = true;
        iterator = ((ArrayList)((Object)iterator)).iterator();
        while (iterator.hasNext()) {
            UnityAdsCampaign object = (UnityAdsCampaign)((Object)iterator.next());
            if (object.forceCacheVideo().booleanValue() || object.allowCacheVideo().booleanValue() && bl) {
                String string = object.getVideoFilename();
                if (!UnityAdsCache.a(string, object.getVideoFileExpectedSize())) {
                    UnityAdsDeviceLog.debug("Unity Ads cache: queuing " + string + " for download");
                    hashMap.put(object.getVideoUrl(), string);
                } else {
                    UnityAdsDeviceLog.debug("Unity Ads cache: not downloading " + string + ", already in cache");
                }
            }
            hashMap2.put(object.getVideoFilename(), object.getVideoFileExpectedSize());
            bl = false;
        }
        UnityAdsCache.a(hashMap2);
        for (Map.Entry entry : hashMap.entrySet()) {
            b.download((String)entry.getKey(), UnityAdsCache.a((String)entry.getValue()));
        }
    }

    public static void cacheCampaign(UnityAdsCampaign unityAdsCampaign) {
        long l2;
        String string = unityAdsCampaign.getVideoFilename();
        if (UnityAdsCache.a(string, l2 = unityAdsCampaign.getVideoFileExpectedSize())) {
            return;
        }
        String string2 = b.getCurrentDownload();
        if (string2 != null && string2.equals(UnityAdsCache.a(string))) {
            return;
        }
        b.download(unityAdsCampaign.getVideoUrl(), UnityAdsCache.a(string));
    }

    public static boolean isCampaignCached(UnityAdsCampaign unityAdsCampaign) {
        String string = unityAdsCampaign.getVideoFilename();
        long l2 = unityAdsCampaign.getVideoFileExpectedSize();
        return UnityAdsCache.a(string, l2);
    }

    public static void stopAllDownloads() {
        b.stopAllDownloads();
    }

    private static void a(HashMap hashMap) {
        File[] fileArray;
        a = new File(UnityAdsProperties.APPLICATION_CONTEXT.getFilesDir().getPath());
        if (Build.VERSION.SDK_INT > 18 && (fileArray = UnityAdsProperties.APPLICATION_CONTEXT.getExternalCacheDir()) != null && (a = new File((String)(fileArray = fileArray.getAbsolutePath()), "UnityAdsVideoCache")).mkdirs()) {
            UnityAdsDeviceLog.debug("Successfully created cache");
        }
        UnityAdsDeviceLog.debug("Unity Ads cache: using " + a.getAbsolutePath() + " as cache");
        if (!a.isDirectory()) {
            UnityAdsDeviceLog.error("Unity Ads cache: Creating cache dir failed");
            return;
        }
        hashMap.put("UnityAds-pendingrequests.dat", -1L);
        if (a.getAbsolutePath().endsWith("UnityAdsVideoCache")) {
            UnityAdsDeviceLog.debug("Unity Ads cache: checking cache directory " + a.getAbsolutePath());
            fileArray = a.listFiles();
        } else {
            UnityAdsDeviceLog.debug("Unity Ads cache: checking app directory for Unity Ads cached files");
            fileArray = new a();
            fileArray = a.listFiles((FilenameFilter)fileArray);
        }
        for (File file : fileArray) {
            String string = file.getName();
            if (!hashMap.containsKey(string)) {
                UnityAdsDeviceLog.debug("Unity Ads cache: " + string + " not found in ad plan, deleting from cache");
                if (file.delete()) continue;
                UnityAdsDeviceLog.debug("Unity Ads cache: Couldn't delete file: " + file.getAbsolutePath());
                continue;
            }
            long l2 = (Long)hashMap.get(string);
            if (l2 == -1L) continue;
            if (file.length() != l2) {
                UnityAdsDeviceLog.debug("Unity Ads cache: " + string + " file size mismatch, deleting from cache");
                if (file.delete()) continue;
                UnityAdsDeviceLog.debug("Unity Ads cache: Couldn't delete file: " + file.getAbsolutePath());
                continue;
            }
            UnityAdsDeviceLog.debug("Unity Ads cache: " + string + " found, keeping");
        }
    }

    public static String getCacheDirectory() {
        if (a != null) {
            return a.getAbsolutePath();
        }
        return null;
    }

    private static String a(String string) {
        return UnityAdsCache.getCacheDirectory() + "/" + string;
    }

    private static boolean a(String object, long l2) {
        object = new File(UnityAdsCache.getCacheDirectory() + "/" + (String)object);
        return ((File)object).exists() && (l2 == -1L || ((File)object).length() == l2);
    }
}

