/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.ads.android;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import com.unity3d.ads.android.UnityAdsDeviceLog;
import com.unity3d.ads.android.properties.UnityAdsProperties;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;

@TargetApi(value=9)
public class UnityAdsUtils {
    private static final X500Principal a = new X500Principal("CN=Android Debug,O=Android,C=US");

    @SuppressLint(value={"PackageManagerGetSignatures"})
    public static boolean isDebuggable() {
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        if (UnityAdsProperties.APPLICATION_CONTEXT == null) {
            return false;
        }
        PackageManager packageManager = UnityAdsProperties.APPLICATION_CONTEXT.getPackageManager();
        String string = UnityAdsProperties.APPLICATION_CONTEXT.getPackageName();
        try {
            object = packageManager.getApplicationInfo(string, 0);
            bl = 0 != (object.flags &= 2);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            UnityAdsDeviceLog.debug("Could not find name");
            bl2 = true;
        }
        if (bl2) {
            try {
                Signature[] signatureArray = packageManager.getPackageInfo((String)string, (int)64).signatures;
                int n2 = packageManager.getPackageInfo((String)string, (int)64).signatures.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    object = signatureArray[i2];
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    bl = ((X509Certificate)certificateFactory.generateCertificate((InputStream)(object = new ByteArrayInputStream(object.toByteArray())))).getSubjectX500Principal().equals(a);
                    if (!bl) {
                        continue;
                    }
                    break;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                UnityAdsDeviceLog.debug("Could not find name");
            }
            catch (CertificateException certificateException) {
                UnityAdsDeviceLog.debug("Certificate exception");
            }
        }
        return bl;
    }

    @SuppressLint(value={"DefaultLocale"})
    public static String Md5(String string) {
        if (string == null) {
            return null;
        }
        Object object = null;
        try {
            object = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        if (object == null) {
            return null;
        }
        byte[] byArray = string.getBytes();
        int n2 = string.length();
        ((MessageDigest)object).update(byArray, 0, n2);
        byte[] byArray2 = ((MessageDigest)object).digest();
        object = "";
        for (int n3 : byArray2) {
            if ((n3 = 0xFF & n3) <= 15) {
                object = (String)object + "0";
            }
            object = (String)object + Integer.toHexString(n3);
        }
        return ((String)object).toUpperCase();
    }

    public static String readFile(File object, boolean bl) {
        String string = "";
        if (((File)object).exists() && ((File)object).canRead()) {
            try {
                String string2;
                object = new BufferedReader(new FileReader((File)object));
                while ((string2 = ((BufferedReader)object).readLine()) != null) {
                    string = string.concat(string2);
                    if (!bl) continue;
                    string = string.concat("\n");
                }
            }
            catch (Exception exception) {
                UnityAdsDeviceLog.error("Problem reading file: " + exception.getMessage());
                return null;
            }
            try {
                ((BufferedReader)object).close();
            }
            catch (Exception exception) {
                UnityAdsDeviceLog.error("Problem closing reader: " + exception.getMessage());
            }
            return string;
        }
        UnityAdsDeviceLog.error("File did not exist or couldn't be read");
        return null;
    }

    public static boolean writeFile(File file, String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(string.getBytes());
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            UnityAdsDeviceLog.error("Could not write file: " + exception.getMessage());
            return false;
        }
        UnityAdsDeviceLog.debug("Wrote file: " + file.getAbsolutePath());
        return true;
    }

    public static boolean canUseExternalStorage() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public static void runOnUiThread(Runnable runnable) {
        Handler handler = new Handler(Looper.getMainLooper());
        if (0L > 0L) {
            handler.postDelayed(runnable, 0L);
            return;
        }
        handler.post(runnable);
    }
}

