/*
 * Decompiled with CFR 0.152.
 */
package com.wajahatkarim3.easyvalidation.core.rules;

import com.wajahatkarim3.easyvalidation.core.rules.BaseRule;
import com.wajahatkarim3.easyvalidation.core.view_ktx.StringKtxKt;
import java.text.NumberFormat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/wajahatkarim3/easyvalidation/core/rules/GreaterThanOrEqualRule;", "Lcom/wajahatkarim3/easyvalidation/core/rules/BaseRule;", "target", "", "(Ljava/lang/Number;)V", "getTarget", "()Ljava/lang/Number;", "getErrorMessage", "", "validate", "", "text", "easyvalidation-core_release"})
public final class GreaterThanOrEqualRule
implements BaseRule {
    @NotNull
    private final Number target;

    @Override
    public boolean validate(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        CharSequence charSequence = text;
        if (charSequence.length() == 0) {
            return false;
        }
        if (StringsKt.startsWith$default((String)text, (String)"-", (boolean)false, (int)2, null)) {
            String txtNum = StringsKt.substringAfter$default((String)text, (String)"-", null, (int)2, null);
            if (StringKtxKt.validNumber(txtNum)) {
                Number number = NumberFormat.getNumberInstance().parse(txtNum);
                return (number = (Number)Float.valueOf(number.floatValue() * (float)-1)).floatValue() >= this.target.floatValue();
            }
            return false;
        }
        if (StringKtxKt.validNumber(text)) {
            Number number = NumberFormat.getNumberInstance().parse(text);
            return number.floatValue() >= this.target.floatValue();
        }
        return false;
    }

    @Override
    @NotNull
    public String getErrorMessage() {
        return "Should be greater than or equal to " + this.target;
    }

    @NotNull
    public final Number getTarget() {
        return this.target;
    }

    public GreaterThanOrEqualRule(@NotNull Number target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        this.target = target;
    }
}

