/*
 * Decompiled with CFR 0.152.
 */
package com.wajahatkarim3.easyvalidation.core;

import com.wajahatkarim3.easyvalidation.core.rules.AllLowerCaseRule;
import com.wajahatkarim3.easyvalidation.core.rules.AllUpercCaseRule;
import com.wajahatkarim3.easyvalidation.core.rules.AtLeastOneLowerCaseRule;
import com.wajahatkarim3.easyvalidation.core.rules.AtLeastOneNumberCaseRule;
import com.wajahatkarim3.easyvalidation.core.rules.AtLeastOneUpercCaseRule;
import com.wajahatkarim3.easyvalidation.core.rules.AtleastOneSpecialCharacterRule;
import com.wajahatkarim3.easyvalidation.core.rules.BaseRule;
import com.wajahatkarim3.easyvalidation.core.rules.ContainsRule;
import com.wajahatkarim3.easyvalidation.core.rules.CreditCardRule;
import com.wajahatkarim3.easyvalidation.core.rules.CreditCardWithDashesRule;
import com.wajahatkarim3.easyvalidation.core.rules.CreditCardWithSpacesRule;
import com.wajahatkarim3.easyvalidation.core.rules.EmailRule;
import com.wajahatkarim3.easyvalidation.core.rules.EndsWithRule;
import com.wajahatkarim3.easyvalidation.core.rules.GreaterThanOrEqualRule;
import com.wajahatkarim3.easyvalidation.core.rules.GreaterThanRule;
import com.wajahatkarim3.easyvalidation.core.rules.LessThanOrEqualRule;
import com.wajahatkarim3.easyvalidation.core.rules.LessThanRule;
import com.wajahatkarim3.easyvalidation.core.rules.MaxLengthRule;
import com.wajahatkarim3.easyvalidation.core.rules.MinLengthRule;
import com.wajahatkarim3.easyvalidation.core.rules.NoNumbersRule;
import com.wajahatkarim3.easyvalidation.core.rules.NoSpecialCharacterRule;
import com.wajahatkarim3.easyvalidation.core.rules.NonEmptyRule;
import com.wajahatkarim3.easyvalidation.core.rules.NotContainsRule;
import com.wajahatkarim3.easyvalidation.core.rules.NumberEqualToRule;
import com.wajahatkarim3.easyvalidation.core.rules.OnlyNumbersRule;
import com.wajahatkarim3.easyvalidation.core.rules.RegexRule;
import com.wajahatkarim3.easyvalidation.core.rules.StartsWithNoNumberRule;
import com.wajahatkarim3.easyvalidation.core.rules.StartsWithNumberRule;
import com.wajahatkarim3.easyvalidation.core.rules.StartsWithRule;
import com.wajahatkarim3.easyvalidation.core.rules.TextEqualToRule;
import com.wajahatkarim3.easyvalidation.core.rules.TextNotEqualToRule;
import com.wajahatkarim3.easyvalidation.core.rules.ValidNumberRule;
import com.wajahatkarim3.easyvalidation.core.rules.ValidUrlRule;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u0004\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0013\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J)\u0010\"\u001a\u00020\u00002!\u0010#\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0006J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0014J\u0006\u0010&\u001a\u00020\u0000J\u0006\u0010'\u001a\u00020\u0000J\u0006\u0010(\u001a\u00020\u0000J\u0006\u0010)\u001a\u00020\u0000J\u0006\u0010*\u001a\u00020\u0000J\u0006\u0010+\u001a\u00020\u0000J\u0006\u0010,\u001a\u00020\u0011J\u000e\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u0003J\u0006\u0010/\u001a\u00020\u0000J\u0006\u00100\u001a\u00020\u0000J\u0006\u00101\u001a\u00020\u0000J\u000e\u00102\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u0003J\u000e\u00103\u001a\u00020\u00002\u0006\u00104\u001a\u000205J\u000e\u00106\u001a\u00020\u00002\u0006\u00104\u001a\u000205J\u000e\u00107\u001a\u00020\u00002\u0006\u00104\u001a\u000205J\u000e\u00108\u001a\u00020\u00002\u0006\u00104\u001a\u000205J\u000e\u00109\u001a\u00020\u00002\u0006\u0010:\u001a\u00020;J\u000e\u0010<\u001a\u00020\u00002\u0006\u0010:\u001a\u00020;J\u0006\u0010=\u001a\u00020\u0000J\u0006\u0010>\u001a\u00020\u0000J\u0006\u0010?\u001a\u00020\u0000J\u000e\u0010@\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u0003J\u000e\u0010A\u001a\u00020\u00002\u0006\u00104\u001a\u000205J\u0006\u0010B\u001a\u00020\u0000J\u000e\u0010C\u001a\u00020\u00002\u0006\u0010D\u001a\u00020\u0003J\u000e\u0010E\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\u0003J\u0006\u0010F\u001a\u00020\u0000J\u0006\u0010G\u001a\u00020\u0000J\u000e\u0010H\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u0003J\u000e\u0010I\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u0003J\u000e\u0010J\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u0003J\u0006\u0010K\u001a\u00020\u0000J\u0006\u0010L\u001a\u00020\u0000J\u0006\u0010M\u001a\u00020\u0000R7\u0010\u0005\u001a\u001f\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\"\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006N"}, d2={"Lcom/wajahatkarim3/easyvalidation/core/Validator;", "", "text", "", "(Ljava/lang/String;)V", "errorCallback", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "message", "", "getErrorCallback", "()Lkotlin/jvm/functions/Function1;", "setErrorCallback", "(Lkotlin/jvm/functions/Function1;)V", "errorMessage", "isValid", "", "rulesList", "Ljava/util/ArrayList;", "Lcom/wajahatkarim3/easyvalidation/core/rules/BaseRule;", "Lkotlin/collections/ArrayList;", "getRulesList", "()Ljava/util/ArrayList;", "setRulesList", "(Ljava/util/ArrayList;)V", "successCallback", "Lkotlin/Function0;", "getSuccessCallback", "()Lkotlin/jvm/functions/Function0;", "setSuccessCallback", "(Lkotlin/jvm/functions/Function0;)V", "getText", "()Ljava/lang/String;", "addErrorCallback", "callback", "addRule", "rule", "allLowerCase", "allUpperCase", "atleastOneLowerCase", "atleastOneNumber", "atleastOneSpecialCharacters", "atleastOneUpperCase", "check", "contains", "target", "creditCardNumber", "creditCardNumberWithDashes", "creditCardNumberWithSpaces", "endsWith", "greaterThan", "number", "", "greaterThanOrEqual", "lessThan", "lessThanOrEqual", "maxLength", "length", "", "minLength", "noNumbers", "noSpecialCharacters", "nonEmpty", "notContains", "numberEqualTo", "onlyNumbers", "regex", "pattern", "setError", "startWithNonNumber", "startWithNumber", "startsWith", "textEqualTo", "textNotEqualTo", "validEmail", "validNumber", "validUrl", "easyvalidation-core_release"})
public final class Validator {
    private boolean isValid;
    private String errorMessage;
    @Nullable
    private Function1<? super String, Unit> errorCallback;
    @Nullable
    private Function0<Unit> successCallback;
    @NotNull
    private ArrayList<BaseRule> rulesList;
    @NotNull
    private final String text;

    @Nullable
    public final Function1<String, Unit> getErrorCallback() {
        return this.errorCallback;
    }

    public final void setErrorCallback(@Nullable Function1<? super String, Unit> function1) {
        this.errorCallback = function1;
    }

    @Nullable
    public final Function0<Unit> getSuccessCallback() {
        return this.successCallback;
    }

    public final void setSuccessCallback(@Nullable Function0<Unit> function0) {
        this.successCallback = function0;
    }

    @NotNull
    public final ArrayList<BaseRule> getRulesList() {
        return this.rulesList;
    }

    public final void setRulesList(@NotNull ArrayList<BaseRule> arrayList) {
        Intrinsics.checkParameterIsNotNull(arrayList, (String)"<set-?>");
        this.rulesList = arrayList;
    }

    public final boolean check() {
        block2: {
            block1: {
                for (BaseRule rule : this.rulesList) {
                    if (rule.validate(this.text)) continue;
                    this.setError(rule.getErrorMessage());
                    break;
                }
                if (!this.isValid) break block1;
                Function0<Unit> function0 = this.successCallback;
                if (function0 == null) break block2;
                Unit cfr_ignored_0 = (Unit)function0.invoke();
                break block2;
            }
            Function1<? super String, Unit> function1 = this.errorCallback;
            if (function1 == null) break block2;
            Unit cfr_ignored_1 = (Unit)function1.invoke((Object)this.errorMessage);
        }
        return this.isValid;
    }

    public final void setError(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.isValid = false;
        this.errorMessage = message;
    }

    @NotNull
    public final Validator addRule(@NotNull BaseRule rule) {
        Intrinsics.checkParameterIsNotNull((Object)rule, (String)"rule");
        this.rulesList.add(rule);
        return this;
    }

    @NotNull
    public final Validator addErrorCallback(@NotNull Function1<? super String, Unit> callback) {
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.errorCallback = callback;
        return this;
    }

    @NotNull
    public final Validator nonEmpty() {
        this.addRule(new NonEmptyRule());
        return this;
    }

    @NotNull
    public final Validator minLength(int length) {
        this.addRule(new MinLengthRule(length));
        return this;
    }

    @NotNull
    public final Validator maxLength(int length) {
        this.addRule(new MaxLengthRule(length));
        return this;
    }

    @NotNull
    public final Validator validEmail() {
        this.addRule(new EmailRule());
        return this;
    }

    @NotNull
    public final Validator validNumber() {
        this.addRule(new ValidNumberRule());
        return this;
    }

    @NotNull
    public final Validator greaterThan(@NotNull Number number) {
        Intrinsics.checkParameterIsNotNull((Object)number, (String)"number");
        this.addRule(new GreaterThanRule(number));
        return this;
    }

    @NotNull
    public final Validator greaterThanOrEqual(@NotNull Number number) {
        Intrinsics.checkParameterIsNotNull((Object)number, (String)"number");
        this.addRule(new GreaterThanOrEqualRule(number));
        return this;
    }

    @NotNull
    public final Validator lessThan(@NotNull Number number) {
        Intrinsics.checkParameterIsNotNull((Object)number, (String)"number");
        this.addRule(new LessThanRule(number));
        return this;
    }

    @NotNull
    public final Validator lessThanOrEqual(@NotNull Number number) {
        Intrinsics.checkParameterIsNotNull((Object)number, (String)"number");
        this.addRule(new LessThanOrEqualRule(number));
        return this;
    }

    @NotNull
    public final Validator numberEqualTo(@NotNull Number number) {
        Intrinsics.checkParameterIsNotNull((Object)number, (String)"number");
        this.addRule(new NumberEqualToRule(number));
        return this;
    }

    @NotNull
    public final Validator allLowerCase() {
        this.addRule(new AllLowerCaseRule());
        return this;
    }

    @NotNull
    public final Validator allUpperCase() {
        this.addRule(new AllUpercCaseRule());
        return this;
    }

    @NotNull
    public final Validator atleastOneUpperCase() {
        this.addRule(new AtLeastOneUpercCaseRule());
        return this;
    }

    @NotNull
    public final Validator atleastOneLowerCase() {
        this.addRule(new AtLeastOneLowerCaseRule());
        return this;
    }

    @NotNull
    public final Validator atleastOneNumber() {
        this.addRule(new AtLeastOneNumberCaseRule());
        return this;
    }

    @NotNull
    public final Validator noNumbers() {
        this.addRule(new NoNumbersRule());
        return this;
    }

    @NotNull
    public final Validator onlyNumbers() {
        this.addRule(new OnlyNumbersRule());
        return this;
    }

    @NotNull
    public final Validator startWithNumber() {
        this.addRule(new StartsWithNumberRule());
        return this;
    }

    @NotNull
    public final Validator startWithNonNumber() {
        this.addRule(new StartsWithNoNumberRule());
        return this;
    }

    @NotNull
    public final Validator noSpecialCharacters() {
        this.addRule(new NoSpecialCharacterRule());
        return this;
    }

    @NotNull
    public final Validator atleastOneSpecialCharacters() {
        this.addRule(new AtleastOneSpecialCharacterRule());
        return this;
    }

    @NotNull
    public final Validator textEqualTo(@NotNull String target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        this.addRule(new TextEqualToRule(target));
        return this;
    }

    @NotNull
    public final Validator textNotEqualTo(@NotNull String target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        this.addRule(new TextNotEqualToRule(target));
        return this;
    }

    @NotNull
    public final Validator startsWith(@NotNull String target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        this.addRule(new StartsWithRule(target));
        return this;
    }

    @NotNull
    public final Validator endsWith(@NotNull String target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        this.addRule(new EndsWithRule(target));
        return this;
    }

    @NotNull
    public final Validator contains(@NotNull String target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        this.addRule(new ContainsRule(target));
        return this;
    }

    @NotNull
    public final Validator notContains(@NotNull String target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        this.addRule(new NotContainsRule(target));
        return this;
    }

    @NotNull
    public final Validator creditCardNumber() {
        this.addRule(new MinLengthRule(16));
        this.addRule(new MaxLengthRule(16));
        this.addRule(new CreditCardRule());
        return this;
    }

    @NotNull
    public final Validator creditCardNumberWithSpaces() {
        this.addRule(new MinLengthRule(19));
        this.addRule(new MaxLengthRule(19));
        this.addRule(new CreditCardWithSpacesRule());
        return this;
    }

    @NotNull
    public final Validator creditCardNumberWithDashes() {
        this.addRule(new MinLengthRule(19));
        this.addRule(new MaxLengthRule(19));
        this.addRule(new CreditCardWithDashesRule());
        return this;
    }

    @NotNull
    public final Validator validUrl() {
        this.addRule(new ValidUrlRule());
        return this;
    }

    @NotNull
    public final Validator regex(@NotNull String pattern) {
        Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
        this.addRule(new RegexRule(pattern));
        return this;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public Validator(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        this.text = text;
        this.isValid = true;
        this.errorMessage = "";
        this.rulesList = new ArrayList();
    }
}

