/*
 * Decompiled with CFR 0.152.
 */
package com.ice.common.utils;

import java.util.concurrent.ThreadLocalRandom;

public final class UUIDUtils {
    private static final char[] DIGITS64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};

    private UUIDUtils() {
    }

    public static String generateUUID() {
        byte[] randomBytes = new byte[16];
        ThreadLocalRandom.current().nextBytes(randomBytes);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0x80);
        long msb = 0L;
        for (int i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(randomBytes[i] & 0xFF);
        }
        long lsb = 0L;
        for (int i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(randomBytes[i] & 0xFF);
        }
        return UUIDUtils.digits(msb >> 32, 8) + UUIDUtils.digits(msb >> 16, 4) + UUIDUtils.digits(msb, 4) + UUIDUtils.digits(lsb >> 48, 4) + UUIDUtils.digits(lsb, 12);
    }

    private static String digits(long val, int digits) {
        long hi = 1L << (int)((long)digits << 2);
        return Long.toHexString(hi | val & hi - 1L);
    }

    public static String generateUUID22() {
        byte[] randomBytes = new byte[16];
        ThreadLocalRandom.current().nextBytes(randomBytes);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0x80);
        long msb = 0L;
        for (int i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(randomBytes[i] & 0xFF);
        }
        long lsb = 0L;
        for (int i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(randomBytes[i] & 0xFF);
        }
        char[] out = new char[24];
        int bit = 0;
        int bt1 = 8;
        int bt2 = 8;
        int idx = 0;
        while (bit < 16) {
            int mask;
            int offsetm = 64 - (bit + 3 << 3);
            if (bt1 > 3) {
                mask = 0xFFFFFF;
            } else if (bt1 >= 0) {
                mask = (1 << 8 * bt1) - 1;
                bt2 -= 3 - bt1;
            } else {
                mask = (1 << 8 * Math.min(bt2, 3)) - 1;
                bt2 -= 3;
            }
            int tmp = 0;
            if (bt1 > 0) {
                tmp = (int)(offsetm < 0 ? msb : msb >>> offsetm & (long)mask);
                if ((bt1 -= 3) < 0) {
                    tmp <<= Math.abs(offsetm);
                    mask = (1 << 8 * Math.abs(bt1)) - 1;
                }
            }
            if (offsetm < 0) {
                int offsetl = 64 + offsetm;
                tmp = (int)((long)tmp | (offsetl < 0 ? lsb : lsb >>> offsetl) & (long)mask);
            }
            if (bit == 15) {
                out[idx + 3] = DIGITS64[63];
                out[idx + 2] = DIGITS64[63];
                tmp <<= 4;
            } else {
                out[idx + 3] = DIGITS64[tmp & 0x3F];
                out[idx + 2] = DIGITS64[(tmp >>= 6) & 0x3F];
                tmp >>= 6;
            }
            out[idx + 1] = DIGITS64[tmp & 0x3F];
            out[idx] = DIGITS64[(tmp >>= 6) & 0x3F];
            bit += 3;
            idx += 4;
        }
        return new String(out, 0, 22);
    }

    public static String generateShortId() {
        byte[] randomBytes = new byte[8];
        ThreadLocalRandom.current().nextBytes(randomBytes);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        long msb = 0L;
        for (int i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(randomBytes[i] & 0xFF);
        }
        char[] out = new char[12];
        int bit = 0;
        int bt1 = 8;
        int bt2 = 8;
        int offsetm = 1;
        int idx = 0;
        while (offsetm > 0) {
            int mask;
            offsetm = 64 - (bit + 3 << 3);
            if (bt1 > 3) {
                mask = 0xFFFFFF;
            } else if (bt1 >= 0) {
                mask = (1 << 8 * bt1) - 1;
                bt2 -= 3 - bt1;
            } else {
                mask = (1 << 8 * Math.min(bt2, 3)) - 1;
                bt2 -= 3;
            }
            int tmp = 0;
            if (bt1 > 0) {
                tmp = (int)(offsetm < 0 ? msb : msb >>> offsetm & (long)mask);
                if ((bt1 -= 3) < 0) {
                    tmp <<= Math.abs(offsetm);
                }
            }
            out[idx + 3] = DIGITS64[tmp & 0x3F];
            out[idx + 2] = DIGITS64[(tmp >>= 6) & 0x3F];
            out[idx + 1] = DIGITS64[(tmp >>= 6) & 0x3F];
            out[idx] = DIGITS64[(tmp >>= 6) & 0x3F];
            bit += 3;
            idx += 4;
        }
        return new String(out, 0, 11);
    }
}

