/*
 * Decompiled with CFR 0.152.
 */
package com.ice.common.enums;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public enum NodeTypeEnum {
    NONE(0),
    AND(1),
    TRUE(2),
    ALL(3),
    ANY(4),
    LEAF_FLOW(5),
    LEAF_RESULT(6),
    LEAF_NONE(7),
    P_NONE(8),
    P_AND(9),
    P_TRUE(10),
    P_ALL(11),
    P_ANY(12);

    private static final Map<Byte, NodeTypeEnum> MAP;
    private static final Set<Byte> RELATION_SET;
    private final byte type;

    private NodeTypeEnum(byte type) {
        this.type = type;
    }

    public static NodeTypeEnum getEnum(Byte type) {
        if (type == null) {
            return null;
        }
        return MAP.get(type);
    }

    public byte getType() {
        return this.type;
    }

    public static boolean isRelation(byte type) {
        return RELATION_SET.contains(type);
    }

    public static boolean isLeaf(byte type) {
        return type == NodeTypeEnum.LEAF_FLOW.type || type == NodeTypeEnum.LEAF_NONE.type || type == NodeTypeEnum.LEAF_RESULT.type;
    }

    static {
        MAP = new HashMap<Byte, NodeTypeEnum>(NodeTypeEnum.values().length);
        RELATION_SET = new HashSet<Byte>(10);
        for (NodeTypeEnum enums : NodeTypeEnum.values()) {
            MAP.put(enums.getType(), enums);
        }
        RELATION_SET.add(NodeTypeEnum.NONE.type);
        RELATION_SET.add(NodeTypeEnum.AND.type);
        RELATION_SET.add(NodeTypeEnum.TRUE.type);
        RELATION_SET.add(NodeTypeEnum.ALL.type);
        RELATION_SET.add(NodeTypeEnum.ANY.type);
        RELATION_SET.add(NodeTypeEnum.P_NONE.type);
        RELATION_SET.add(NodeTypeEnum.P_AND.type);
        RELATION_SET.add(NodeTypeEnum.P_TRUE.type);
        RELATION_SET.add(NodeTypeEnum.P_ALL.type);
        RELATION_SET.add(NodeTypeEnum.P_ANY.type);
    }
}

