/*
 * Decompiled with CFR 0.152.
 */
package com.ice.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum NodeTypeEnum {
    NONE(0),
    AND(1),
    TRUE(2),
    ALL(3),
    ANY(4),
    LEAF_FLOW(5),
    LEAF_RESULT(6),
    LEAF_NONE(7);

    private static final Map<Byte, NodeTypeEnum> MAP;
    private final byte type;

    private NodeTypeEnum(byte type) {
        this.type = type;
    }

    public static NodeTypeEnum getEnum(Byte type) {
        if (type == null) {
            return null;
        }
        return MAP.get(type);
    }

    public byte getType() {
        return this.type;
    }

    static {
        MAP = new HashMap<Byte, NodeTypeEnum>();
        for (NodeTypeEnum enums : NodeTypeEnum.values()) {
            MAP.put(enums.getType(), enums);
        }
    }
}

