/*
 * Decompiled with CFR 0.152.
 */
package com.ice.common.codec;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.TypeUtils;
import com.ice.common.enums.IceSerializerFeature;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public final class IceByteShortCodec
implements ObjectSerializer,
ObjectDeserializer {
    private static final IceByteShortCodec INSTANCE = new IceByteShortCodec();

    public static IceByteShortCodec getInstance() {
        return INSTANCE;
    }

    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) {
        SerializeWriter out = serializer.out;
        Number value = (Number)object;
        if (value == null) {
            out.writeNull(SerializerFeature.WriteNullNumberAsZero);
            return;
        }
        if (object instanceof Long) {
            out.writeLong(value.longValue());
        } else {
            out.writeInt(value.intValue());
        }
        if (out.isEnabled(IceSerializerFeature.CUSTOM_NUMBER_SHOW.getMask())) {
            Class<?> clazz = value.getClass();
            if (clazz == Byte.class) {
                out.write(66);
            } else if (clazz == Short.class) {
                out.write(83);
            }
        }
    }

    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        Integer intObj;
        JSONLexer lexer = parser.lexer;
        int token = lexer.token();
        if (token == 8) {
            lexer.nextToken(16);
            return null;
        }
        try {
            if (token == 2) {
                int val = lexer.intValue();
                lexer.nextToken(16);
                intObj = val;
            } else if (token == 3) {
                BigDecimal number = lexer.decimalValue();
                intObj = TypeUtils.intValue((BigDecimal)number);
                lexer.nextToken(16);
            } else if (token == 12) {
                JSONObject jsonObject = new JSONObject(true);
                parser.parseObject((Map)jsonObject);
                intObj = TypeUtils.castToInt((Object)jsonObject);
            } else {
                Object value = parser.parse();
                intObj = TypeUtils.castToInt((Object)value);
            }
        }
        catch (Exception ex) {
            String message = "parseByteOrShort error";
            if (fieldName != null) {
                message = message + ", field : " + fieldName;
            }
            throw new JSONException(message, (Throwable)ex);
        }
        if (clazz == AtomicInteger.class) {
            return (T)new AtomicInteger(intObj);
        }
        return (T)intObj;
    }

    public int getFastMatchToken() {
        return 2;
    }
}

