/*
 * Decompiled with CFR 0.152.
 */
package com.ice.common.codec;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public final class IceLongCodec
implements ObjectSerializer,
ObjectDeserializer {
    private static final IceLongCodec INSTANCE = new IceLongCodec();

    public static IceLongCodec getInstance() {
        return INSTANCE;
    }

    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) {
        SerializeWriter out = serializer.out;
        if (object == null) {
            out.writeNull(SerializerFeature.WriteNullNumberAsZero);
        } else {
            long value = (Long)object;
            out.writeLong(value);
            out.write(76);
        }
    }

    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        Long longObject;
        JSONLexer lexer = parser.lexer;
        try {
            int token = lexer.token();
            if (token == 2) {
                long longValue = lexer.longValue();
                lexer.nextToken(16);
                longObject = longValue;
            } else if (token == 3) {
                BigDecimal number = lexer.decimalValue();
                longObject = TypeUtils.longValue((BigDecimal)number);
                lexer.nextToken(16);
            } else {
                if (token == 12) {
                    JSONObject jsonObject = new JSONObject(true);
                    parser.parseObject((Map)jsonObject);
                    longObject = TypeUtils.castToLong((Object)jsonObject);
                } else {
                    Object value = parser.parse();
                    longObject = TypeUtils.castToLong((Object)value);
                }
                if (longObject == null) {
                    return null;
                }
            }
        }
        catch (Exception ex) {
            throw new JSONException("parseLong error, field : " + fieldName, (Throwable)ex);
        }
        return (T)(clazz == AtomicLong.class ? new AtomicLong(longObject) : longObject);
    }

    public int getFastMatchToken() {
        return 2;
    }
}

