/*
 * Decompiled with CFR 0.152.
 */
package com.w4lle.library;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.w4lle.library.NineGridAdapter;

public class NineGridlayout
extends ViewGroup {
    private NineGridAdapter adapter;
    private OnItemClickListerner onItemClickListerner;
    private final int ITEM_GAP = 3;
    private final int DEFAULT_WIDTH = 140;
    private int gap;
    private int columns;
    private int rows;
    private int totalWidth;
    private Context context;
    int singleWidth = 0;
    int singleHeight = 0;
    private int defaultWidth;
    private int defaultHeight;
    private int oldCount;

    public NineGridlayout(Context context) {
        this(context, null);
    }

    public NineGridlayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public NineGridlayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
        this.gap = NineGridlayout.dip2px(context, 3.0f);
        this.defaultWidth = this.defaultHeight = NineGridlayout.dip2px(context, 140.0f);
    }

    public void setDefaultWidth(int defaultWidth) {
        this.defaultWidth = defaultWidth;
    }

    public void setDefaultHeight(int defaultHeight) {
        this.defaultHeight = defaultHeight;
    }

    public void setAdapter(NineGridAdapter adapter) {
        this.adapter = adapter;
        if (adapter == null) {
            return;
        }
        this.generateChildrenLayout(adapter.getCount());
        this.removeAllViews();
        for (int i = 0; i < adapter.getCount(); ++i) {
            View itemView = adapter.getView(i, null);
            this.addView(itemView, this.generateDefaultLayoutParams());
        }
        this.oldCount = adapter.getCount();
        this.requestLayout();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int sizeWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int sizeHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.totalWidth = sizeWidth - this.getPaddingLeft() - this.getPaddingRight();
        if (this.adapter != null && this.adapter.getCount() > 0) {
            int childrenCount = this.adapter.getCount();
            if (childrenCount == 1) {
                this.singleWidth = this.defaultWidth;
                this.singleHeight = this.defaultHeight;
            } else {
                this.singleHeight = this.singleWidth = (this.totalWidth - this.gap * 2) / 3;
            }
            this.measureChildren(View.MeasureSpec.makeMeasureSpec((int)this.singleWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)this.singleHeight, (int)0x40000000));
            int measureWidth = this.singleWidth * this.columns + this.gap * (this.columns - 1);
            int measureHeight = this.singleHeight * this.rows + this.gap * (this.rows - 1);
            this.setMeasuredDimension(sizeWidth, measureHeight);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.layoutChildrenView();
    }

    private void layoutChildrenView() {
        if (this.adapter == null || this.adapter.getCount() == 0) {
            return;
        }
        int childrenCount = this.adapter.getCount();
        int i = 0;
        while (i < childrenCount) {
            int[] position = this.findPosition(i);
            int left = (this.singleWidth + this.gap) * position[1] + this.getPaddingLeft();
            int top = (this.singleHeight + this.gap) * position[0] + this.getPaddingTop();
            int right = left + this.singleWidth;
            int bottom = top + this.singleHeight;
            ImageView childrenView = (ImageView)this.getChildAt(i);
            if (childrenCount == 1) {
                childrenView.setScaleType(ImageView.ScaleType.FIT_CENTER);
            } else {
                childrenView.setScaleType(ImageView.ScaleType.CENTER_CROP);
            }
            final int itemPosition = i++;
            childrenView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (NineGridlayout.this.onItemClickListerner != null) {
                        NineGridlayout.this.onItemClickListerner.onItemClick(v, itemPosition);
                    }
                }
            });
            childrenView.layout(left, top, right, bottom);
        }
    }

    private int[] findPosition(int childNum) {
        int[] position = new int[2];
        block0: for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                if (i * this.columns + j != childNum) continue;
                position[0] = i;
                position[1] = j;
                continue block0;
            }
        }
        return position;
    }

    public int getGap() {
        return this.gap;
    }

    public void setGap(int gap) {
        this.gap = gap;
    }

    private void generateChildrenLayout(int length) {
        if (length <= 3) {
            this.rows = 1;
            this.columns = length;
        } else if (length <= 6) {
            this.rows = 2;
            this.columns = 3;
            if (length == 4) {
                this.columns = 2;
            }
        } else {
            this.rows = 3;
            this.columns = 3;
        }
    }

    public static int dip2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public void setOnItemClickListerner(OnItemClickListerner onItemClickListerner) {
        this.onItemClickListerner = onItemClickListerner;
    }

    public static interface OnItemClickListerner {
        public void onItemClick(View var1, int var2);
    }
}

