/*
 * Decompiled with CFR 0.152.
 */
package com.vuzix.hud.resources;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.util.Log;
import android.view.InputDevice;
import android.view.InputEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;

public final class Utils {
    private static final String TAG = Utils.class.getSimpleName();
    private static final String BOARD_REV_PATH_BLADE = "/sys/devices/platform/blade_eeprom.0/board01_rev";
    private static final String BOARD_REV_PATH_BLADE_REV_2020 = "/sys/devices/platform/blade_eeprom.0/board09_rev";
    private static final String BUILD_MODEL_M300 = "M300";
    private static final String BUILD_MODEL_M400 = "Vuzix M400";
    private static final String BUILD_MODEL_M4000 = "Vuzix M4000";
    private static final String BUILD_MODEL_SHIELD = "Vuzix Shield";
    private static final String BUILD_MODEL_BLADE_2 = "Blade 2";
    private static final String BUILD_MODEL_LX1_INTERNAL = "balor";
    private static final String BUILD_MODEL_LX1 = "LX1";
    private static final String EXTRA_MODE = "mode";
    private static final String MODE_ENABLED = "enabled";
    private static final String MODE_DISABLED = "disabled";
    private static final String MODE_DEFAULT = "default";
    private static final String EXTRA_BEHAVIOR = "behavior";
    private static final String BEHAVIOR_GESTURES = "gestures";
    private static final String BEHAVIOR_MOUSE = "mouse";
    private static final String EXTRA_TRACK_TOUCH = "track_touch";
    @Deprecated
    public static final int DEVICE_MODEL_UNKOWN = -1;
    public static final int DEVICE_MODEL_UNKNOWN = -1;
    public static final int DEVICE_MODEL_BLADE = 447;
    public static final int DEVICE_MODEL_BLADE_REV_2020 = 494;
    public static final int DEVICE_MODEL_BLADE_2 = 514;
    public static final int DEVICE_MODEL_M300 = 446;
    public static final int DEVICE_MODEL_M400 = 472;
    public static final int DEVICE_MODEL_M4000 = 490;
    public static final int DEVICE_MODEL_SHIELD = 492;
    public static final int DEVICE_MODEL_LX1 = 516;
    private static int currentModelNumber = -1;
    @Deprecated
    public static final int TOUCHPAD_ENABLE = 1;
    public static final int TOUCHPAD_DISABLE = 0;
    public static final int TOUCHPAD_ENABLE_FOR_GESTURES = 1;
    public static final int TOUCHPAD_ENABLE_FOR_MOUSE = 2;
    public static final int TOUCHPAD_DEFAULT = -1;
    private static final String[] INPUT_TOUCH_NAMES = new String[]{"cirque_gt5", "vuzix_mouse2", "vuzix_touch", "vuzix_mouse", "vuzix_abs"};
    private static final String[] INPUT_BUTTON_NAMES = new String[]{"gpio-keys", "qpnp_pon", "88pm88x_on", "pmic_resin", "dollar_cove_power_button"};

    public static DisplayType getDisplayType() {
        DisplayType type = DisplayType.UNKNOWN;
        switch (Utils.getModelNumber()) {
            case 447: 
            case 490: 
            case 492: 
            case 494: 
            case 514: {
                type = DisplayType.TRANSPARENT;
                break;
            }
            case 446: 
            case 472: 
            case 516: {
                type = DisplayType.OCCLUDED;
            }
        }
        return type;
    }

    public static NavigationButtonType getNavigationButtonType() {
        NavigationButtonType type = NavigationButtonType.UNKNOWN;
        switch (Utils.getModelNumber()) {
            case 447: 
            case 492: 
            case 494: 
            case 514: {
                type = NavigationButtonType.NO_NAV_BUTTONS;
                break;
            }
            case 446: 
            case 472: 
            case 490: 
            case 516: {
                type = NavigationButtonType.THREE_NAV_BUTTONS;
            }
        }
        return type;
    }

    public static int getModelNumber() {
        if (currentModelNumber != -1) {
            return currentModelNumber;
        }
        if (Utils.checkBoardRevSysfs(BOARD_REV_PATH_BLADE)) {
            currentModelNumber = 447;
        } else if (Utils.checkBoardRevSysfs(BOARD_REV_PATH_BLADE_REV_2020)) {
            currentModelNumber = 494;
        } else {
            switch (Build.MODEL) {
                case "M300": {
                    currentModelNumber = 446;
                    break;
                }
                case "Vuzix M400": {
                    currentModelNumber = 472;
                    break;
                }
                case "Vuzix M4000": {
                    currentModelNumber = 490;
                    break;
                }
                case "Vuzix Shield": {
                    currentModelNumber = 492;
                    break;
                }
                case "Blade 2": {
                    currentModelNumber = 514;
                    break;
                }
                case "balor": 
                case "LX1": {
                    currentModelNumber = 516;
                    break;
                }
                default: {
                    Log.e((String)TAG, (String)("No match for current device model name " + Build.MODEL));
                }
            }
        }
        return currentModelNumber;
    }

    private static boolean checkBoardRevSysfs(String sysfsPath) {
        String boardRev = Utils.getSysfs(sysfsPath);
        if (boardRev != null && !boardRev.isEmpty()) {
            int revNumber = Integer.parseInt(boardRev);
            return 0 < revNumber && revNumber < 255;
        }
        return false;
    }

    private static String getSysfs(String path) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(path), 100);
            String data = in.readLine();
            in.close();
            return data;
        }
        catch (IOException e) {
            return "";
        }
    }

    public static boolean canControlTouchPad() {
        switch (Utils.getModelNumber()) {
            case 447: 
            case 472: 
            case 490: 
            case 492: 
            case 494: 
            case 514: {
                return true;
            }
            case 446: 
            case 516: {
                return false;
            }
        }
        return false;
    }

    public static TouchpadType getTouchpadType() {
        switch (Utils.getModelNumber()) {
            case 446: 
            case 447: 
            case 472: 
            case 490: 
            case 492: 
            case 494: 
            case 514: {
                return TouchpadType.TWO_AXIS_TOUCHPAD;
            }
            case 516: {
                return TouchpadType.NO_TOUCHPAD;
            }
        }
        return TouchpadType.UNKNOWN;
    }

    public static boolean setTouchPadState(Context context, int state) {
        return Utils.setTouchPadState(context, state, null);
    }

    public static boolean setTouchPadState(Context context, int state, Bundle extras) {
        String mode;
        if (!Utils.canControlTouchPad()) {
            return false;
        }
        String behavior = null;
        switch (state) {
            case 1: {
                behavior = BEHAVIOR_GESTURES;
                mode = MODE_ENABLED;
                break;
            }
            case 2: {
                behavior = BEHAVIOR_MOUSE;
                mode = MODE_ENABLED;
                break;
            }
            case 0: {
                mode = MODE_DISABLED;
                break;
            }
            case -1: {
                mode = MODE_DEFAULT;
                break;
            }
            default: {
                return false;
            }
        }
        Intent intent = new Intent("com.vuzix.sdk.touchpad.ENABLE");
        if (extras != null) {
            intent.putExtras(extras);
        }
        intent.putExtra(EXTRA_MODE, mode);
        if (behavior != null) {
            intent.putExtra(EXTRA_BEHAVIOR, behavior);
        }
        switch (Utils.getModelNumber()) {
            case 447: 
            case 494: 
            case 514: {
                intent.setPackage("com.vuzix.hud.settings");
                break;
            }
            case 472: 
            case 490: 
            case 492: {
                intent.setPackage("com.android.settings");
                break;
            }
            default: {
                return false;
            }
        }
        context.sendBroadcast(intent);
        return true;
    }

    public static void setTouchpadTrackTouch(Context context, boolean trackTouch) {
        Intent intent = new Intent("com.vuzix.sdk.touchpad.ENABLE");
        intent.putExtra(EXTRA_MODE, MODE_ENABLED);
        intent.putExtra(EXTRA_BEHAVIOR, BEHAVIOR_GESTURES);
        intent.putExtra(EXTRA_TRACK_TOUCH, trackTouch);
        switch (Utils.getModelNumber()) {
            case 447: 
            case 494: 
            case 514: {
                intent.setPackage("com.vuzix.hud.settings");
                break;
            }
            case 472: 
            case 490: 
            case 492: {
                intent.setPackage("com.android.settings");
            }
        }
        context.sendBroadcast(intent);
    }

    public static int getCurrentTouchPadState(Context context) {
        if (!Utils.canControlTouchPad()) {
            return -1;
        }
        switch (Utils.getModelNumber()) {
            case 514: {
                return Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)"touchpad_mode", (int)1);
            }
        }
        return Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)"touchpad_enabled", (int)1);
    }

    public static boolean isInputDeviceTouchpad(InputEvent iEvent) {
        return Utils.checkInputOrigin(iEvent, INPUT_TOUCH_NAMES);
    }

    public static boolean isInputDeviceButtons(InputEvent iEvent) {
        return Utils.checkInputOrigin(iEvent, INPUT_BUTTON_NAMES);
    }

    private static boolean checkInputOrigin(InputEvent event, String[] array) {
        boolean isValid = false;
        String devName = "";
        if (event != null && array != null) {
            InputDevice dev = event.getDevice();
            if (dev != null) {
                devName = dev.getName();
            }
            if (Arrays.asList(array).contains(devName)) {
                isValid = true;
            }
        }
        return isValid;
    }

    public static enum DisplayType {
        TRANSPARENT,
        OCCLUDED,
        UNKNOWN;

    }

    public static enum NavigationButtonType {
        NO_NAV_BUTTONS,
        THREE_NAV_BUTTONS,
        UNKNOWN;

    }

    public static enum TouchpadType {
        NO_TOUCHPAD,
        TWO_AXIS_TOUCHPAD,
        UNKNOWN;

    }
}

