/*
 * Decompiled with CFR 0.152.
 */
package com.vuzix.hud.resources;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import com.vuzix.hud.resources.DynamicThemeActivity;
import com.vuzix.hud.resources.R;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public abstract class DynamicThemeApplication
extends Application {
    private boolean lightMode;
    private int themeResId;
    private Set<Activity> allActivities = new HashSet<Activity>();
    private Set<Activity> startedActivities = new HashSet<Activity>();
    private Set<Activity> pendingActivities = new HashSet<Activity>();
    private Handler handler;
    final BroadcastReceiver uiModeReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            DynamicThemeApplication.this.handleUIModeChange(intent);
        }
    };

    @SuppressLint(value={"UnspecifiedRegisterReceiverFlag"})
    public void onCreate() {
        super.onCreate();
        this.handler = new Handler(Looper.getMainLooper());
        this.changeTheme(this.getNormalThemeResId());
        this.registerActivityLifecycleCallbacks(new ActivityTracker());
        IntentFilter uiModeIntentFilter = new IntentFilter("com.vuzix.intent.action.UI_DISPLAY_MODE");
        if (Build.VERSION.SDK_INT >= 26) {
            this.handleUIModeChange(this.registerReceiver(this.uiModeReceiver, uiModeIntentFilter, 4));
        } else {
            this.handleUIModeChange(this.registerReceiver(this.uiModeReceiver, uiModeIntentFilter));
        }
    }

    private void handleUIModeChange(Intent displayModeIntent) {
        if (displayModeIntent == null) {
            return;
        }
        this.lightMode = DynamicThemeApplication.isLightMode(displayModeIntent);
        this.changeTheme(this.lightMode ? this.getLightThemeResId() : this.getNormalThemeResId());
    }

    public static boolean isLightMode(Intent displayModeIntent) {
        Parcelable displayModeExtra = displayModeIntent.getParcelableExtra("com.vuzix.intent.extra.UI_DISPLAY_MODE");
        return displayModeExtra != null && "LIGHT_MODE".equals(displayModeExtra.toString());
    }

    protected int getNormalThemeResId() {
        return R.style.HudTheme;
    }

    protected int getLightThemeResId() {
        return R.style.HudTheme_Light;
    }

    private void changeTheme(int resId) {
        if (this.themeResId == resId) {
            return;
        }
        this.themeResId = resId;
        this.getTheme().applyStyle(this.themeResId, true);
        ArrayList<Activity> activitiesToRecreate = new ArrayList<Activity>(this.allActivities);
        for (Activity activity : activitiesToRecreate) {
            if (this.startedActivities.contains(activity)) {
                this.recreate(activity);
                continue;
            }
            this.pendingActivities.add(activity);
        }
    }

    int getCurrentThemeResId() {
        return this.themeResId;
    }

    private void recreate(final Activity activity) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                activity.recreate();
            }
        });
    }

    public boolean isLightMode() {
        return this.lightMode;
    }

    private class ActivityTracker
    implements Application.ActivityLifecycleCallbacks {
        private ActivityTracker() {
        }

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
            if (activity instanceof DynamicThemeActivity && ((DynamicThemeActivity)activity).useDynamicTheme()) {
                DynamicThemeApplication.this.allActivities.add(activity);
            }
        }

        public void onActivityStarted(Activity activity) {
            DynamicThemeApplication.this.startedActivities.add(activity);
            if (DynamicThemeApplication.this.pendingActivities.contains(activity)) {
                DynamicThemeApplication.this.pendingActivities.remove(activity);
                DynamicThemeApplication.this.recreate(activity);
            }
        }

        public void onActivityStopped(Activity activity) {
            DynamicThemeApplication.this.startedActivities.remove(activity);
        }

        public void onActivityDestroyed(Activity activity) {
            DynamicThemeApplication.this.allActivities.remove(activity);
            DynamicThemeApplication.this.pendingActivities.remove(activity);
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }
    }
}

