/*
 * Decompiled with CFR 0.152.
 */
package com.vuzix.hud.resources;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.provider.Settings;
import android.util.Log;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public final class Utils {
    private static final String TAG = Utils.class.getSimpleName();
    private static final String BOARD_REV_PATH_BLADE = "/sys/devices/platform/blade_eeprom.0/board01_rev";
    private static final String BOARD_REV_PATH_BLADE_REV_2020 = "/sys/devices/platform/blade_eeprom.0/board09_rev";
    private static final String BUILD_MODEL_M300 = "M300";
    private static final String BUILD_MODEL_M400 = "Vuzix M400";
    private static final String BUILD_MODEL_M4000 = "Vuzix M4000";
    public static final int DEVICE_MODEL_UNKOWN = -1;
    public static final int DEVICE_MODEL_BLADE = 447;
    public static final int DEVICE_MODEL_BLADE_REV_2020 = 494;
    public static final int DEVICE_MODEL_M300 = 446;
    public static final int DEVICE_MODEL_M400 = 472;
    public static final int DEVICE_MODEL_M4000 = 490;
    public static final int TOUCHPAD_ENABLE = 1;
    public static final int TOUCHPAD_DISABLE = 0;
    public static final int TOUCHPAD_DEFAULT = -1;

    public static DisplayType getDisplayType() {
        DisplayType type = DisplayType.UNKNOWN;
        switch (Utils.getModelNumber()) {
            case 447: 
            case 490: 
            case 494: {
                type = DisplayType.TRANSPARENT;
                break;
            }
            case 446: 
            case 472: {
                type = DisplayType.OCCLUDED;
            }
        }
        return type;
    }

    public static int getModelNumber() {
        if (Utils.checkBoardRevSysfs(BOARD_REV_PATH_BLADE)) {
            return 447;
        }
        if (Utils.checkBoardRevSysfs(BOARD_REV_PATH_BLADE_REV_2020)) {
            return 494;
        }
        switch (Build.MODEL) {
            case "M300": {
                return 446;
            }
            case "Vuzix M400": {
                return 472;
            }
            case "Vuzix M4000": {
                return 490;
            }
        }
        Log.e((String)TAG, (String)"No matching clause for current device model name");
        return -1;
    }

    private static boolean checkBoardRevSysfs(String sysfsPath) {
        String boardRev = Utils.getSysfs(sysfsPath);
        if (boardRev != null && !boardRev.isEmpty()) {
            int revNumber = Integer.parseInt(boardRev);
            return 0 < revNumber && revNumber < 255;
        }
        return false;
    }

    private static String getSysfs(String path) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(path), 100);
            String data = in.readLine();
            in.close();
            return data;
        }
        catch (IOException e) {
            Log.v((String)TAG, (String)("Unable to read from " + path));
            return "";
        }
    }

    public static boolean canControlTouchPad() {
        switch (Utils.getModelNumber()) {
            case 472: 
            case 490: {
                return true;
            }
        }
        return false;
    }

    public static boolean setTouchPadState(Context context, int state) {
        String mode;
        if (!Utils.canControlTouchPad()) {
            return false;
        }
        switch (state) {
            case 1: {
                mode = "enabled";
                break;
            }
            case 0: {
                mode = "disabled";
                break;
            }
            case -1: {
                mode = "default";
                break;
            }
            default: {
                return false;
            }
        }
        Intent intent = new Intent("com.vuzix.sdk.touchpad.ENABLE");
        intent.putExtra("mode", mode);
        intent.setPackage("com.android.settings");
        context.sendBroadcast(intent);
        return true;
    }

    public int getCurrentTouchPadState(Context context) {
        if (!Utils.canControlTouchPad()) {
            return -1;
        }
        if (Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)"touchpad_enabled", (int)1) != 0) {
            return 1;
        }
        return 0;
    }

    public static enum DisplayType {
        TRANSPARENT,
        OCCLUDED,
        UNKNOWN;

    }
}

