/*
 * Decompiled with CFR 0.152.
 */
package com.vuzix.hud.resources;

import android.os.Build;
import android.util.Log;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public final class Utils {
    private static final String TAG = Utils.class.getSimpleName();
    private static final String BOARD_REV_PATH_BLADE = "/sys/devices/platform/blade_eeprom.0/board01_rev";
    private static final String BOARD_REV_PATH_BLADE_REV_2020 = "/sys/devices/platform/blade_eeprom.0/board09_rev";
    private static final String BUILD_MODEL_M300 = "M300";
    private static final String BUILD_MODEL_M400 = "Vuzix M400";
    public static final int DEVICE_MODEL_UNKOWN = -1;
    public static final int DEVICE_MODEL_BLADE = 447;
    public static final int DEVICE_MODEL_BLADE_REV_2020 = 494;
    public static final int DEVICE_MODEL_M300 = 446;
    public static final int DEVICE_MODEL_M400 = 472;

    public static int getModelNumber() {
        if (Utils.checkBoardRevSysfs(BOARD_REV_PATH_BLADE)) {
            return 447;
        }
        if (Utils.checkBoardRevSysfs(BOARD_REV_PATH_BLADE_REV_2020)) {
            return 494;
        }
        switch (Build.MODEL) {
            case "M300": {
                return 446;
            }
            case "Vuzix M400": {
                return 472;
            }
        }
        Log.e((String)TAG, (String)"No matching clause for current device model name");
        return -1;
    }

    private static boolean checkBoardRevSysfs(String sysfsPath) {
        String boardRev = Utils.getSysfs(sysfsPath);
        if (boardRev != null && !boardRev.isEmpty()) {
            int revNumber = Integer.parseInt(boardRev);
            return 0 < revNumber && revNumber < 255;
        }
        return false;
    }

    private static String getSysfs(String path) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(path), 100);
            String data = in.readLine();
            in.close();
            return data;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("Unable to read from " + path), (Throwable)e);
            return "";
        }
    }
}

