/*
 * Decompiled with CFR 0.152.
 */
package com.vuzix.hud.resources;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.util.Pair;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;
import com.vuzix.hud.resources.DynamicThemeActivity;
import com.vuzix.hud.resources.R;
import java.util.LinkedHashMap;
import java.util.List;

public abstract class DetailsActivity
extends DynamicThemeActivity {
    private static String TAG = DetailsActivity.class.getSimpleName();
    public static final String EXTRA_DETAILS_BUNDLE = "com.vuzix.hud.resources.EXTRA_DETAILS_BUNDLE";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.details_card);
        this.inflateDetailsCard(this.getDetailsKeySet(this.getKeyValuePairs()));
    }

    protected abstract List<Pair<String, String>> getKeyValuePairs();

    private LinkedHashMap<String, String> getDetailsKeySet(List<Pair<String, String>> pairs) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (pairs != null) {
            for (Pair<String, String> pair : pairs) {
                map.put((String)pair.first, (String)pair.second);
            }
        } else {
            Log.w((String)TAG, (String)"Pairs list is empty");
        }
        return map;
    }

    private void inflateDetailsCard(LinkedHashMap<String, String> map) {
        LayoutInflater inflater = this.getLayoutInflater();
        TableLayout table = (TableLayout)this.findViewById(R.id.details_card_table);
        for (String key : map.keySet()) {
            TableRow row = (TableRow)inflater.inflate(R.layout.details_card_row, null);
            TextView label = (TextView)row.findViewById(R.id.details_card_row_label);
            TextView value = (TextView)row.findViewById(R.id.details_card_row_value);
            label.setText((CharSequence)(key + ":"));
            value.setText((CharSequence)map.get(key));
            table.addView((View)row);
        }
    }

    public static void showDetailsSetting(Context context, Class className, Bundle extras) {
        Intent showDetails = new Intent(context, className);
        if (extras != null) {
            showDetails.putExtra(EXTRA_DETAILS_BUNDLE, extras);
        }
        context.startActivity(showDetails);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 23: 
            case 66: {
                this.finish();
                return true;
            }
        }
        return super.onKeyUp(keyCode, event);
    }
}

