/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.util;

import android.content.Context;
import android.os.Build;
import android.webkit.URLUtil;
import com.vungle.ads.internal.util.Logger;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/vungle/ads/internal/util/Utils;", "", "()V", "getFolderSize", "", "dir", "Ljava/io/File;", "getWebViewDataSize", "context", "Landroid/content/Context;", "isOSVersionInvalid", "", "isUrlValid", "url", "", "vungle-ads_release"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();

    private Utils() {
    }

    public final boolean isUrlValid(@Nullable String url) {
        CharSequence charSequence = url;
        return !(charSequence == null || charSequence.length() == 0) && (URLUtil.isHttpsUrl((String)url) || URLUtil.isHttpUrl((String)url));
    }

    public final boolean isOSVersionInvalid() {
        return Build.VERSION.SDK_INT < 25;
    }

    private final long getFolderSize(File dir) {
        long size = 0L;
        if (dir.exists()) {
            Sequence $this$forEach$iv = (Sequence)FilesKt.walkTopDown((File)dir);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File file = (File)element$iv;
                boolean bl = false;
                if (!file.isFile()) continue;
                size += file.length();
            }
        }
        return size;
    }

    public final long getWebViewDataSize(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        long totalSize = 0L;
        try {
            File cacheDir;
            File appWebViewDir = new File(context.getApplicationInfo().dataDir, "app_webview");
            if (appWebViewDir.exists()) {
                totalSize += this.getFolderSize(appWebViewDir);
            }
            if ((cacheDir = context.getCacheDir()).exists()) {
                Intrinsics.checkNotNullExpressionValue((Object)cacheDir, (String)"cacheDir");
                totalSize += this.getFolderSize(FilesKt.resolve((File)cacheDir, (String)"webviewCache"));
            }
        }
        catch (Exception e2) {
            Logger.Companion.e("WebViewSize", "Error reading WebView data size: " + e2.getMessage());
        }
        return totalSize;
    }
}

