/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.util;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.view.PixelCopy;
import android.view.View;
import android.view.Window;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.vungle.ads.ServiceLocator;
import com.vungle.ads.internal.executor.Executors;
import com.vungle.ads.internal.util.BlackScreenDetector;
import com.vungle.ads.internal.util.Logger;
import com.vungle.ads.internal.util.ThreadUtil;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\u0018\u0000 &2\u00020\u0001:\u0001&B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\fH\u0002J+\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0014\u0010\u0012\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0004\u0012\u00020\u00070\u0013H\u0001\u00a2\u0006\u0002\b\u0014J&\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0014\u0010\u0012\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0004\u0012\u00020\u00070\u0013H\u0002J&\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0014\u0010\u0012\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0004\u0012\u00020\u00070\u0013H\u0003J6\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\n2\u0014\u0010\u0012\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0004\u0012\u00020\u00070\u0013H\u0003J\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J+\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\"2\b\u0010\u001c\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u0005H\u0001\u00a2\u0006\u0002\b#J2\u0010$\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\r\u001a\u00020\u00052\u0018\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0004J\u0006\u0010%\u001a\u00020\u0007R\"\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'\u00b2\u0006\n\u0010(\u001a\u00020)X\u008a\u0084\u0002\u00b2\u0006\n\u0010(\u001a\u00020)X\u008a\u0084\u0002"}, d2={"Lcom/vungle/ads/internal/util/BlackScreenDetector;", "", "()V", "callback", "Lkotlin/Function2;", "", "", "", "calculateBlackScreenPercentageWithMargin", "image", "Landroid/graphics/Bitmap;", "marginPercentage", "", "samplingFactor", "maxMarginPercentage", "captureViewBitmapAsync", "view", "Landroid/view/View;", "onComplete", "Lkotlin/Function1;", "captureViewBitmapAsync$vungle_ads_release", "captureViewWithCanvas", "captureViewWithPixelCopy", "executePixelCopyRequest", "window", "Landroid/view/Window;", "rect", "Landroid/graphics/Rect;", "bitmap", "getActivity", "Landroid/app/Activity;", "context", "Landroid/content/Context;", "processBitmapForBlackScreen", "Lkotlin/Pair;", "processBitmapForBlackScreen$vungle_ads_release", "start", "stop", "Companion", "vungle-ads_release", "executors", "Lcom/vungle/ads/internal/executor/Executors;"})
public final class BlackScreenDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private volatile Function2<? super Integer, ? super String, Unit> callback;
    @NotNull
    private static final String TAG = "BlackScreenDetector";
    private static final double BLACK_SCREEN_MARGIN_PERCENTAGE = 0.1;
    private static final int BLACK_PIXEL_THRESHOLD = 10;

    public final void start(@Nullable View view, int samplingFactor, @NotNull Function2<? super Integer, ? super String, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.callback = callback;
        if (view == null) {
            Logger.Companion.w(TAG, "Black screen detection failed: View not available");
            Function2<? super Integer, ? super String, Unit> function2 = this.callback;
            if (function2 != null) {
                function2.invoke((Object)-1, (Object)"View not available");
            }
            this.callback = null;
            return;
        }
        this.captureViewBitmapAsync$vungle_ads_release(view, (Function1<? super Bitmap, Unit>)((Function1)new Function1<Bitmap, Unit>(view, this, samplingFactor){
            final /* synthetic */ View $view;
            final /* synthetic */ BlackScreenDetector this$0;
            final /* synthetic */ int $samplingFactor;
            {
                this.$view = $view;
                this.this$0 = $receiver;
                this.$samplingFactor = $samplingFactor;
                super(1);
            }

            public final void invoke(@Nullable Bitmap bitmap) {
                ServiceLocator.Companion companion = ServiceLocator.Companion;
                Context context = this.$view.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"view.context");
                Context context$iv = context;
                boolean $i$f$inject = false;
                Lazy executors$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<Executors>(context$iv){
                    final /* synthetic */ Context $context;
                    {
                        this.$context = $context;
                        super(0);
                    }

                    @NotNull
                    public final Executors invoke() {
                        return ServiceLocator.Companion.getInstance(this.$context).getService(Executors.class);
                    }
                }));
                start.1.invoke$lambda-0((Lazy<? extends Executors>)executors$delegate).getJobExecutor().execute(() -> start.1.invoke$lambda-1(this.this$0, bitmap, this.$samplingFactor));
            }

            private static final Executors invoke$lambda-0(Lazy<? extends Executors> $executors$delegate) {
                Lazy<? extends Executors> lazy = $executors$delegate;
                return (Executors)lazy.getValue();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private static final void invoke$lambda-1(BlackScreenDetector this$0, Bitmap $bitmap, int $samplingFactor) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                try {
                    Pair<Integer, String> pair = this$0.processBitmapForBlackScreen$vungle_ads_release($bitmap, $samplingFactor);
                    int percentage = ((Number)pair.component1()).intValue();
                    String errorMessage = (String)pair.component2();
                    Function2 function2 = BlackScreenDetector.access$getCallback$p(this$0);
                    if (function2 != null) {
                        function2.invoke((Object)percentage, (Object)errorMessage);
                    }
                }
                catch (Throwable e2) {
                    Logger.Companion.e("BlackScreenDetector", "Black screen detection failed", e2);
                    Function2 function2 = BlackScreenDetector.access$getCallback$p(this$0);
                    if (function2 != null) {
                        function2.invoke((Object)-1, (Object)("Internal calculation error: " + e2.getMessage()));
                    }
                }
                finally {
                    Bitmap bitmap = $bitmap;
                    if (bitmap != null) {
                        bitmap.recycle();
                    }
                    BlackScreenDetector.access$setCallback$p(this$0, null);
                }
            }
        }));
    }

    public final void stop() {
        this.callback = null;
    }

    @VisibleForTesting
    public final void captureViewBitmapAsync$vungle_ads_release(@NotNull View view, @NotNull Function1<? super Bitmap, Unit> onComplete) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter(onComplete, (String)"onComplete");
        if (this.callback == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 26) {
            this.captureViewWithPixelCopy(view, onComplete);
        } else {
            this.captureViewWithCanvas(view, onComplete);
        }
    }

    @RequiresApi(value=26)
    private final void captureViewWithPixelCopy(View view, Function1<? super Bitmap, Unit> onComplete) {
        Window window;
        Activity activity = this.getActivity(view.getContext());
        Object object = window = activity != null ? activity.getWindow() : null;
        if (window == null) {
            Logger.Companion.w(TAG, "Activity/Window not found for PixelCopy");
            onComplete.invoke(null);
            return;
        }
        ServiceLocator.Companion companion = ServiceLocator.Companion;
        Context context = view.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"view.context");
        Context context$iv = context;
        boolean $i$f$inject = false;
        Lazy executors$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<Executors>(context$iv){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final Executors invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(Executors.class);
            }
        }));
        ThreadUtil.INSTANCE.runOnUiThread((Function0<Unit>)((Function0)new Function0<Unit>(view, (Lazy<? extends Executors>)executors$delegate, this, window, onComplete){
            final /* synthetic */ View $view;
            final /* synthetic */ Lazy<Executors> $executors$delegate;
            final /* synthetic */ BlackScreenDetector this$0;
            final /* synthetic */ Window $window;
            final /* synthetic */ Function1<Bitmap, Unit> $onComplete;
            {
                this.$view = $view;
                this.$executors$delegate = $executors$delegate;
                this.this$0 = $receiver;
                this.$window = $window;
                this.$onComplete = $onComplete;
                super(0);
            }

            public final void invoke() {
                int width = this.$view.getWidth();
                int height = this.$view.getHeight();
                int[] location = new int[2];
                this.$view.getLocationInWindow(location);
                Rect rect = new Rect(location[0], location[1], location[0] + width, location[1] + height);
                BlackScreenDetector.access$captureViewWithPixelCopy$lambda-0(this.$executors$delegate).getJobExecutor().execute(() -> captureViewWithPixelCopy.1.invoke$lambda-0(width, height, this.this$0, this.$window, rect, this.$onComplete));
            }

            private static final void invoke$lambda-0(int $width, int $height, BlackScreenDetector this$0, Window $window, Rect $rect, Function1 $onComplete) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$rect, (String)"$rect");
                Intrinsics.checkNotNullParameter((Object)$onComplete, (String)"$onComplete");
                Bitmap bitmap = null;
                try {
                    bitmap = Bitmap.createBitmap((int)$width, (int)$height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    BlackScreenDetector.access$executePixelCopyRequest(this$0, $window, $rect, bitmap, $onComplete);
                }
                catch (Throwable e2) {
                    Logger.Companion.e("BlackScreenDetector", "Bitmap creation failed", e2);
                    Bitmap bitmap2 = bitmap;
                    if (bitmap2 != null) {
                        bitmap2.recycle();
                    }
                    $onComplete.invoke(null);
                }
            }
        }));
    }

    @RequiresApi(value=26)
    private final void executePixelCopyRequest(Window window, Rect rect, Bitmap bitmap, Function1<? super Bitmap, Unit> onComplete) {
        try {
            PixelCopy.request((Window)window, (Rect)rect, (Bitmap)bitmap, arg_0 -> BlackScreenDetector.executePixelCopyRequest$lambda-1(onComplete, bitmap, arg_0), (Handler)new Handler(Looper.getMainLooper()));
        }
        catch (Throwable e2) {
            Logger.Companion.e(TAG, "PixelCopy request failed", e2);
            bitmap.recycle();
            onComplete.invoke(null);
        }
    }

    private final void captureViewWithCanvas(View view, Function1<? super Bitmap, Unit> onComplete) {
        ThreadUtil.INSTANCE.runOnUiThread((Function0<Unit>)((Function0)new Function0<Unit>(view, onComplete){
            final /* synthetic */ View $view;
            final /* synthetic */ Function1<Bitmap, Unit> $onComplete;
            {
                this.$view = $view;
                this.$onComplete = $onComplete;
                super(0);
            }

            public final void invoke() {
                try {
                    Bitmap bitmap = Bitmap.createBitmap((int)this.$view.getWidth(), (int)this.$view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    View view = this.$view;
                    Bitmap created = bitmap;
                    boolean bl = false;
                    Canvas canvas = new Canvas(created);
                    view.draw(canvas);
                    Bitmap bitmap2 = bitmap;
                    this.$onComplete.invoke((Object)bitmap2);
                }
                catch (Throwable e2) {
                    Logger.Companion.e("BlackScreenDetector", "Bitmap capture failed", e2);
                    this.$onComplete.invoke(null);
                }
            }
        }));
    }

    private final Activity getActivity(Context context) {
        Context ctx = context;
        while (ctx instanceof ContextWrapper) {
            if (ctx instanceof Activity) {
                return (Activity)ctx;
            }
            ctx = ((ContextWrapper)ctx).getBaseContext();
        }
        return null;
    }

    @VisibleForTesting
    @NotNull
    public final Pair<Integer, String> processBitmapForBlackScreen$vungle_ads_release(@Nullable Bitmap bitmap, int samplingFactor) {
        Pair pair;
        if (bitmap != null) {
            int percentage = BlackScreenDetector.calculateBlackScreenPercentageWithMargin$default(this, bitmap, 0.1, samplingFactor, 0.0, 8, null);
            String errorMessage = percentage == -1 ? "Internal calculation error" : "";
            pair = new Pair((Object)percentage, (Object)errorMessage);
        } else {
            Logger.Companion.w(TAG, "Black screen detection failed: Snapshot capture failure");
            pair = new Pair((Object)-1, (Object)"Snapshot capture failure");
        }
        return pair;
    }

    private final int calculateBlackScreenPercentageWithMargin(Bitmap image, double marginPercentage, int samplingFactor, double maxMarginPercentage) {
        int width = image.getWidth();
        int height = image.getHeight();
        int marginX = (int)((double)width * marginPercentage);
        int marginY = (int)((double)height * marginPercentage);
        int croppedWidth = width - 2 * marginX;
        int croppedHeight = height - 2 * marginY;
        if (croppedWidth <= 0 || croppedHeight <= 0) {
            return -1;
        }
        long totalPixelsLong = (long)croppedWidth * (long)croppedHeight;
        if (totalPixelsLong > Integer.MAX_VALUE) {
            if (marginPercentage >= maxMarginPercentage) {
                return -1;
            }
            return this.calculateBlackScreenPercentageWithMargin(image, marginPercentage * (double)2, samplingFactor, maxMarginPercentage);
        }
        int totalPixels = (int)totalPixelsLong;
        int[] pixels = new int[totalPixels];
        image.getPixels(pixels, 0, croppedWidth, marginX, marginY, croppedWidth, croppedHeight);
        int blackPixelCount = 0;
        int sampledPixelCount = 0;
        int n = pixels.length + -1;
        if (samplingFactor <= 0) {
            throw new IllegalArgumentException("Step must be positive, was: " + samplingFactor + '.');
        }
        int i2 = 0;
        int n2 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n, (int)samplingFactor);
        if (i2 <= n2) {
            while (true) {
                ++sampledPixelCount;
                int pixel = pixels[i2];
                int alpha = pixel >> 24 & 0xFF;
                int red = pixel >> 16 & 0xFF;
                int green = pixel >> 8 & 0xFF;
                int blue = pixel & 0xFF;
                if (alpha > 0 && red < 10 && green < 10 && blue < 10) {
                    ++blackPixelCount;
                }
                if (i2 == n2) break;
                i2 += samplingFactor;
            }
        }
        return sampledPixelCount > 0 ? (int)((long)blackPixelCount * (long)100 / (long)sampledPixelCount) : 0;
    }

    static /* synthetic */ int calculateBlackScreenPercentageWithMargin$default(BlackScreenDetector blackScreenDetector2, Bitmap bitmap, double d2, int n, double d3, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 100;
        }
        if ((n2 & 8) != 0) {
            d3 = 0.5;
        }
        return blackScreenDetector2.calculateBlackScreenPercentageWithMargin(bitmap, d2, n, d3);
    }

    private static final Executors captureViewWithPixelCopy$lambda-0(Lazy<? extends Executors> $executors$delegate) {
        Lazy<? extends Executors> lazy = $executors$delegate;
        return (Executors)lazy.getValue();
    }

    private static final void executePixelCopyRequest$lambda-1(Function1 $onComplete, Bitmap $bitmap, int result) {
        Intrinsics.checkNotNullParameter((Object)$onComplete, (String)"$onComplete");
        Intrinsics.checkNotNullParameter((Object)$bitmap, (String)"$bitmap");
        if (result == 0) {
            $onComplete.invoke((Object)$bitmap);
        } else {
            Logger.Companion.w(TAG, "PixelCopy failed: " + result);
            $bitmap.recycle();
            $onComplete.invoke(null);
        }
    }

    public static final /* synthetic */ Function2 access$getCallback$p(BlackScreenDetector $this) {
        return $this.callback;
    }

    public static final /* synthetic */ void access$setCallback$p(BlackScreenDetector $this, Function2 function2) {
        $this.callback = function2;
    }

    public static final /* synthetic */ Executors access$captureViewWithPixelCopy$lambda-0(Lazy $executors$delegate) {
        return BlackScreenDetector.captureViewWithPixelCopy$lambda-0((Lazy<? extends Executors>)$executors$delegate);
    }

    public static final /* synthetic */ void access$executePixelCopyRequest(BlackScreenDetector $this, Window window, Rect rect, Bitmap bitmap, Function1 onComplete) {
        $this.executePixelCopyRequest(window, rect, bitmap, (Function1<? super Bitmap, Unit>)onComplete);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/vungle/ads/internal/util/BlackScreenDetector$Companion;", "", "()V", "BLACK_PIXEL_THRESHOLD", "", "BLACK_SCREEN_MARGIN_PERCENTAGE", "", "TAG", "", "vungle-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

