/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.util;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.VisibleForTesting;
import com.vungle.ads.internal.ui.PresenterAdOpenCallback;
import com.vungle.ads.internal.util.Logger;
import java.lang.ref.WeakReference;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 (2\u00020\u0001:\u0003()*B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0019H\u0016J\u0010\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u000e\u0010!\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005J.\u0010\"\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010$2\b\u0010&\u001a\u0004\u0018\u00010'H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/vungle/ads/internal/util/ActivityManager;", "Landroid/app/Application$ActivityLifecycleCallbacks;", "()V", "callbacks", "Ljava/util/concurrent/CopyOnWriteArraySet;", "Lcom/vungle/ads/internal/util/ActivityManager$LifeCycleCallback;", "foregroundActivityCount", "", "isAppInForeground", "", "isInitialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "targetActivityInfo", "Lcom/vungle/ads/internal/util/ActivityManager$TargetActivityInfo;", "addListener", "", "callback", "deInit", "context", "Landroid/content/Context;", "init", "onActivityCreated", "activity", "Landroid/app/Activity;", "savedInstanceState", "Landroid/os/Bundle;", "onActivityDestroyed", "onActivityPaused", "onActivityResumed", "onActivitySaveInstanceState", "outState", "onActivityStarted", "onActivityStopped", "removeListener", "startActivitySafely", "deepLinkOverrideIntent", "Landroid/content/Intent;", "defaultIntent", "adOpenCallback", "Lcom/vungle/ads/internal/ui/PresenterAdOpenCallback;", "Companion", "LifeCycleCallback", "TargetActivityInfo", "vungle-ads_release"})
public final class ActivityManager
implements Application.ActivityLifecycleCallbacks {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicBoolean isInitialized = new AtomicBoolean(false);
    private volatile int foregroundActivityCount;
    private volatile boolean isAppInForeground;
    @Nullable
    private volatile TargetActivityInfo targetActivityInfo;
    @NotNull
    private final CopyOnWriteArraySet<LifeCycleCallback> callbacks = new CopyOnWriteArraySet();
    @NotNull
    private static final String TAG = "ActivityManager";
    @NotNull
    private static final ActivityManager instance = new ActivityManager();

    private ActivityManager() {
    }

    private final void init(Context context) {
        block3: {
            Object object;
            if (this.isInitialized.getAndSet(true)) {
                return;
            }
            Object object2 = this;
            try {
                ActivityManager $this$init_u24lambda_u2d0 = object2;
                boolean bl = false;
                Context context2 = context.getApplicationContext();
                Intrinsics.checkNotNull((Object)context2, (String)"null cannot be cast to non-null type android.app.Application");
                Application app = (Application)context2;
                app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)$this$init_u24lambda_u2d0);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block3;
            Object e2 = object = throwable;
            boolean bl = false;
            Logger.Companion.e(TAG, "Error initializing ActivityManager", (Throwable)e2);
            this.isInitialized.set(false);
        }
    }

    private final void deInit(Context context) {
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNull((Object)context2, (String)"null cannot be cast to non-null type android.app.Application");
        Application app = (Application)context2;
        app.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        this.isInitialized.set(false);
        this.targetActivityInfo = null;
        this.foregroundActivityCount = 0;
        this.isAppInForeground = false;
        this.callbacks.clear();
    }

    private final boolean isAppInForeground() {
        return !this.isInitialized.get() || this.isAppInForeground;
    }

    private final void addListener(LifeCycleCallback callback) {
        this.callbacks.add(callback);
    }

    public final void removeListener(@NotNull LifeCycleCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.callbacks.remove(callback);
    }

    public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivityStarted(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        int n = this.foregroundActivityCount;
        this.foregroundActivityCount = n + 1;
        if (!this.isAppInForeground && this.foregroundActivityCount == 1) {
            Object it;
            this.isAppInForeground = true;
            TargetActivityInfo targetActivityInfo = this.targetActivityInfo;
            if (targetActivityInfo != null) {
                TargetActivityInfo $this$onActivityStarted_u24lambda_u2d3 = targetActivityInfo;
                boolean bl = false;
                Context context = (Context)$this$onActivityStarted_u24lambda_u2d3.getContext().get();
                if (context != null) {
                    it = context;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    Companion.startWhenForeground((Context)it, $this$onActivityStarted_u24lambda_u2d3.getDeepLinkOverrideIntent(), $this$onActivityStarted_u24lambda_u2d3.getDefaultIntent(), $this$onActivityStarted_u24lambda_u2d3.getAdOpenCallback());
                }
                this.targetActivityInfo = null;
            }
            Iterable $this$forEach$iv = this.callbacks;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (LifeCycleCallback)element$iv;
                boolean bl = false;
                ((LifeCycleCallback)it).onForeground();
            }
        }
    }

    public void onActivityStopped(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        int n = this.foregroundActivityCount;
        this.foregroundActivityCount = n + -1;
        if (this.isAppInForeground && this.foregroundActivityCount == 0) {
            this.isAppInForeground = false;
            Iterable $this$forEach$iv = this.callbacks;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LifeCycleCallback it = (LifeCycleCallback)element$iv;
                boolean bl = false;
                it.onBackground();
            }
        }
    }

    public void onActivityResumed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Iterable $this$forEach$iv = this.callbacks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LifeCycleCallback it = (LifeCycleCallback)element$iv;
            boolean bl = false;
            it.onActivityResumed(activity);
        }
    }

    public void onActivityPaused(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Iterable $this$forEach$iv = this.callbacks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LifeCycleCallback it = (LifeCycleCallback)element$iv;
            boolean bl = false;
            it.onActivityPaused(activity);
        }
    }

    public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
    }

    public void onActivityDestroyed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    private final boolean startActivitySafely(Context context, Intent deepLinkOverrideIntent, Intent defaultIntent, PresenterAdOpenCallback adOpenCallback) {
        try {
            if (deepLinkOverrideIntent != null) {
                context.startActivity(deepLinkOverrideIntent);
                PresenterAdOpenCallback presenterAdOpenCallback = adOpenCallback;
                if (presenterAdOpenCallback != null) {
                    presenterAdOpenCallback.onDeeplinkClick(true);
                }
            } else if (defaultIntent != null) {
                context.startActivity(defaultIntent);
            } else {
                return false;
            }
            return true;
        }
        catch (Exception e2) {
            Logger.Companion.e(TAG, "Failed to start activity: " + e2);
            try {
                if (deepLinkOverrideIntent != null) {
                    PresenterAdOpenCallback presenterAdOpenCallback = adOpenCallback;
                    if (presenterAdOpenCallback != null) {
                        presenterAdOpenCallback.onDeeplinkClick(false);
                    }
                }
                if (deepLinkOverrideIntent == null || defaultIntent == null) {
                    return false;
                }
                context.startActivity(defaultIntent);
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\u0004H\u0016J\b\u0010\t\u001a\u00020\u0004H\u0016\u00a8\u0006\n"}, d2={"Lcom/vungle/ads/internal/util/ActivityManager$LifeCycleCallback;", "", "()V", "onActivityPaused", "", "activity", "Landroid/app/Activity;", "onActivityResumed", "onBackground", "onForeground", "vungle-ads_release"})
    public static class LifeCycleCallback {
        public void onForeground() {
        }

        public void onBackground() {
        }

        public void onActivityResumed(@NotNull Activity activity) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        }

        public void onActivityPaused(@NotNull Activity activity) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B1\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\tH\u00c6\u0003J=\u0010\u0016\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lcom/vungle/ads/internal/util/ActivityManager$TargetActivityInfo;", "", "context", "Ljava/lang/ref/WeakReference;", "Landroid/content/Context;", "deepLinkOverrideIntent", "Landroid/content/Intent;", "defaultIntent", "adOpenCallback", "Lcom/vungle/ads/internal/ui/PresenterAdOpenCallback;", "(Ljava/lang/ref/WeakReference;Landroid/content/Intent;Landroid/content/Intent;Lcom/vungle/ads/internal/ui/PresenterAdOpenCallback;)V", "getAdOpenCallback", "()Lcom/vungle/ads/internal/ui/PresenterAdOpenCallback;", "getContext", "()Ljava/lang/ref/WeakReference;", "getDeepLinkOverrideIntent", "()Landroid/content/Intent;", "getDefaultIntent", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "vungle-ads_release"})
    private static final class TargetActivityInfo {
        @NotNull
        private final WeakReference<Context> context;
        @Nullable
        private final Intent deepLinkOverrideIntent;
        @Nullable
        private final Intent defaultIntent;
        @Nullable
        private final PresenterAdOpenCallback adOpenCallback;

        public TargetActivityInfo(@NotNull WeakReference<Context> context, @Nullable Intent deepLinkOverrideIntent, @Nullable Intent defaultIntent, @Nullable PresenterAdOpenCallback adOpenCallback) {
            Intrinsics.checkNotNullParameter(context, (String)"context");
            this.context = context;
            this.deepLinkOverrideIntent = deepLinkOverrideIntent;
            this.defaultIntent = defaultIntent;
            this.adOpenCallback = adOpenCallback;
        }

        @NotNull
        public final WeakReference<Context> getContext() {
            return this.context;
        }

        @Nullable
        public final Intent getDeepLinkOverrideIntent() {
            return this.deepLinkOverrideIntent;
        }

        @Nullable
        public final Intent getDefaultIntent() {
            return this.defaultIntent;
        }

        @Nullable
        public final PresenterAdOpenCallback getAdOpenCallback() {
            return this.adOpenCallback;
        }

        @NotNull
        public final WeakReference<Context> component1() {
            return this.context;
        }

        @Nullable
        public final Intent component2() {
            return this.deepLinkOverrideIntent;
        }

        @Nullable
        public final Intent component3() {
            return this.defaultIntent;
        }

        @Nullable
        public final PresenterAdOpenCallback component4() {
            return this.adOpenCallback;
        }

        @NotNull
        public final TargetActivityInfo copy(@NotNull WeakReference<Context> context, @Nullable Intent deepLinkOverrideIntent, @Nullable Intent defaultIntent, @Nullable PresenterAdOpenCallback adOpenCallback) {
            Intrinsics.checkNotNullParameter(context, (String)"context");
            return new TargetActivityInfo(context, deepLinkOverrideIntent, defaultIntent, adOpenCallback);
        }

        public static /* synthetic */ TargetActivityInfo copy$default(TargetActivityInfo targetActivityInfo, WeakReference weakReference, Intent intent, Intent intent2, PresenterAdOpenCallback presenterAdOpenCallback, int n, Object object) {
            if ((n & 1) != 0) {
                weakReference = targetActivityInfo.context;
            }
            if ((n & 2) != 0) {
                intent = targetActivityInfo.deepLinkOverrideIntent;
            }
            if ((n & 4) != 0) {
                intent2 = targetActivityInfo.defaultIntent;
            }
            if ((n & 8) != 0) {
                presenterAdOpenCallback = targetActivityInfo.adOpenCallback;
            }
            return targetActivityInfo.copy(weakReference, intent, intent2, presenterAdOpenCallback);
        }

        @NotNull
        public String toString() {
            return "TargetActivityInfo(context=" + this.context + ", deepLinkOverrideIntent=" + this.deepLinkOverrideIntent + ", defaultIntent=" + this.defaultIntent + ", adOpenCallback=" + this.adOpenCallback + ')';
        }

        public int hashCode() {
            int result = this.context.hashCode();
            result = result * 31 + (this.deepLinkOverrideIntent == null ? 0 : this.deepLinkOverrideIntent.hashCode());
            result = result * 31 + (this.defaultIntent == null ? 0 : this.defaultIntent.hashCode());
            result = result * 31 + (this.adOpenCallback == null ? 0 : this.adOpenCallback.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TargetActivityInfo)) {
                return false;
            }
            TargetActivityInfo targetActivityInfo = (TargetActivityInfo)other;
            if (!Intrinsics.areEqual(this.context, targetActivityInfo.context)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.deepLinkOverrideIntent, (Object)targetActivityInfo.deepLinkOverrideIntent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.defaultIntent, (Object)targetActivityInfo.defaultIntent)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.adOpenCallback, (Object)targetActivityInfo.adOpenCallback);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0015\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\u000e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ,\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u00020\u00068\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001c"}, d2={"Lcom/vungle/ads/internal/util/ActivityManager$Companion;", "", "()V", "TAG", "", "instance", "Lcom/vungle/ads/internal/util/ActivityManager;", "getInstance$vungle_ads_release$annotations", "getInstance$vungle_ads_release", "()Lcom/vungle/ads/internal/util/ActivityManager;", "addLifecycleListener", "", "listener", "Lcom/vungle/ads/internal/util/ActivityManager$LifeCycleCallback;", "deInit", "context", "Landroid/content/Context;", "deInit$vungle_ads_release", "init", "isForeground", "", "removeLifecycleListener", "startWhenForeground", "deepLinkOverrideIntent", "Landroid/content/Intent;", "defaultIntent", "adOpenCallback", "Lcom/vungle/ads/internal/ui/PresenterAdOpenCallback;", "vungle-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ActivityManager getInstance$vungle_ads_release() {
            return instance;
        }

        @VisibleForTesting
        public static /* synthetic */ void getInstance$vungle_ads_release$annotations() {
        }

        public final boolean startWhenForeground(@NotNull Context context, @Nullable Intent deepLinkOverrideIntent, @Nullable Intent defaultIntent, @Nullable PresenterAdOpenCallback adOpenCallback) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (this.isForeground()) {
                bl = this.getInstance$vungle_ads_release().startActivitySafely(context, deepLinkOverrideIntent, defaultIntent, adOpenCallback);
            } else {
                this.getInstance$vungle_ads_release().targetActivityInfo = new TargetActivityInfo(new WeakReference<Context>(context), deepLinkOverrideIntent, defaultIntent, adOpenCallback);
                bl = false;
            }
            return bl;
        }

        public final void init(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.getInstance$vungle_ads_release().init(context);
        }

        public final boolean isForeground() {
            return this.getInstance$vungle_ads_release().isAppInForeground();
        }

        public final void addLifecycleListener(@NotNull LifeCycleCallback listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            this.getInstance$vungle_ads_release().addListener(listener);
        }

        public final void removeLifecycleListener(@NotNull LifeCycleCallback listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            this.getInstance$vungle_ads_release().removeListener(listener);
        }

        public final void deInit$vungle_ads_release(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.getInstance$vungle_ads_release().deInit(context);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

