/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.ui.view;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.IntentFilter;
import android.net.Uri;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.annotation.VisibleForTesting;
import com.vungle.ads.AnalyticsClient;
import com.vungle.ads.NativeVideoPlaybackError;
import com.vungle.ads.R;
import com.vungle.ads.TimeIntervalMetric;
import com.vungle.ads.internal.NativeAdInternal;
import com.vungle.ads.internal.protos.Sdk;
import com.vungle.ads.internal.ui.view.AdVideoView;
import com.vungle.ads.internal.ui.view.BaseContentView;
import com.vungle.ads.internal.ui.view.VideoContentView;
import com.vungle.ads.internal.util.ActivityManager;
import com.vungle.ads.internal.util.Logger;
import com.vungle.ads.internal.util.OnSilentModeChangeListener;
import com.vungle.ads.internal.util.RingerModeReceiver;
import com.vungle.ads.nativead.NativeVideoContract;
import com.vungle.ads.nativead.NativeVideoListener;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000y\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\f*\u0001\u000b\b\u0000\u0018\u0000 G2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001GB\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\r\u0010'\u001a\u00020(H\u0010\u00a2\u0006\u0002\b)J\u0012\u0010*\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020,H\u0016J\u0011\u0010.\u001a\u0004\u0018\u00010/H\u0001\u00a2\u0006\u0004\b0\u00101J\u0010\u00102\u001a\u00020(2\u0006\u00103\u001a\u00020/H\u0016J\b\u00104\u001a\u00020(H\u0014J\b\u00105\u001a\u00020(H\u0014J\u0010\u00106\u001a\u00020(2\u0006\u00107\u001a\u00020/H\u0002J\b\u00108\u001a\u00020(H\u0016J\u0018\u00109\u001a\u00020(2\u0006\u0010:\u001a\u00020,2\u0006\u0010;\u001a\u00020<H\u0016J\u0010\u0010=\u001a\u00020(2\u0006\u00107\u001a\u00020/H\u0016J\b\u0010>\u001a\u00020(H\u0016J\b\u0010?\u001a\u00020(H\u0016J\b\u0010@\u001a\u00020(H\u0016J\u0010\u0010A\u001a\u00020(2\u0006\u0010B\u001a\u00020,H\u0016J\u0010\u0010C\u001a\u00020(2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010D\u001a\u00020(H\u0002J\b\u0010E\u001a\u00020(H\u0002J\b\u0010F\u001a\u00020(H\u0002R\u0010\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u001f\u001a\u0004\u0018\u00010 8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b!\u0010\"\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u0006H"}, d2={"Lcom/vungle/ads/internal/ui/view/VideoContentView;", "Lcom/vungle/ads/internal/ui/view/BaseContentView;", "Lcom/vungle/ads/nativead/NativeVideoContract$VideoControl;", "Lcom/vungle/ads/nativead/NativeVideoContract$VideoLifecycleCallback;", "Lcom/vungle/ads/internal/util/OnSilentModeChangeListener;", "context", "Landroid/content/Context;", "internal", "Lcom/vungle/ads/internal/NativeAdInternal;", "(Landroid/content/Context;Lcom/vungle/ads/internal/NativeAdInternal;)V", "activityLifecycle", "com/vungle/ads/internal/ui/view/VideoContentView$activityLifecycle$1", "Lcom/vungle/ads/internal/ui/view/VideoContentView$activityLifecycle$1;", "adActivity", "Ljava/lang/ref/WeakReference;", "Landroid/app/Activity;", "cp100Fired", "Ljava/util/concurrent/atomic/AtomicBoolean;", "cp25Fired", "cp50Fired", "cp75Fired", "ignoredFirst", "isReceiverRegistered", "muteView", "Landroid/widget/ImageView;", "preparedDurationMetric", "Lcom/vungle/ads/TimeIntervalMetric;", "ringerModeReceiver", "Lcom/vungle/ads/internal/util/RingerModeReceiver;", "startFired", "videoErrorHandled", "videoView", "Lcom/vungle/ads/internal/ui/view/AdVideoView;", "getVideoView$annotations", "()V", "getVideoView", "()Lcom/vungle/ads/internal/ui/view/AdVideoView;", "setVideoView", "(Lcom/vungle/ads/internal/ui/view/AdVideoView;)V", "destroy", "", "destroy$vungle_ads_release", "getAdActivity", "getCurrentTime", "", "getDuration", "isMuted", "", "isMuted$vungle_ads_release", "()Ljava/lang/Boolean;", "notifySilentModeChange", "silentModeEnabled", "onAttachedToWindow", "onDetachedFromWindow", "onMuteUpdateUI", "muted", "onVideoCompleted", "onVideoError", "what", "extra", "", "onVideoMuted", "onVideoPause", "onVideoPlay", "onVideoPrepared", "onVideoProgress", "percentage", "render", "showImageViewAsFallback", "toggleMute", "unRegisterRingerMode", "Companion", "vungle-ads_release"})
public final class VideoContentView
extends BaseContentView
implements NativeVideoContract.VideoControl,
NativeVideoContract.VideoLifecycleCallback,
OnSilentModeChangeListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private AdVideoView videoView;
    @Nullable
    private ImageView muteView;
    @Nullable
    private WeakReference<Activity> adActivity;
    @NotNull
    private final AtomicBoolean startFired;
    @NotNull
    private final AtomicBoolean cp25Fired;
    @NotNull
    private final AtomicBoolean cp50Fired;
    @NotNull
    private final AtomicBoolean cp75Fired;
    @NotNull
    private final AtomicBoolean cp100Fired;
    @NotNull
    private final AtomicBoolean videoErrorHandled;
    @NotNull
    private final TimeIntervalMetric preparedDurationMetric;
    @NotNull
    private final RingerModeReceiver ringerModeReceiver;
    @NotNull
    private final AtomicBoolean isReceiverRegistered;
    @NotNull
    private final AtomicBoolean ignoredFirst;
    @NotNull
    private final activityLifecycle.1 activityLifecycle;
    @NotNull
    private static final String TAG = "NativeAd-VideoContentView";

    public VideoContentView(@NotNull Context context, @NotNull NativeAdInternal internal) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)internal, (String)"internal");
        super(context, internal);
        this.startFired = new AtomicBoolean(false);
        this.cp25Fired = new AtomicBoolean(false);
        this.cp50Fired = new AtomicBoolean(false);
        this.cp75Fired = new AtomicBoolean(false);
        this.cp100Fired = new AtomicBoolean(false);
        this.videoErrorHandled = new AtomicBoolean(false);
        this.preparedDurationMetric = new TimeIntervalMetric(Sdk.SDKMetric.SDKMetricType.NATIVE_VIDEO_PREPARE_DURATION_MS);
        this.ringerModeReceiver = new RingerModeReceiver();
        this.isReceiverRegistered = new AtomicBoolean(false);
        this.ignoredFirst = new AtomicBoolean(false);
        this.activityLifecycle = new ActivityManager.LifeCycleCallback(this){
            final /* synthetic */ VideoContentView this$0;
            {
                this.this$0 = $receiver;
            }

            public void onActivityResumed(@NotNull Activity activity) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                    WeakReference weakReference = VideoContentView.access$getAdActivity$p(this.this$0);
                    if (!Intrinsics.areEqual((Object)(weakReference != null ? (Activity)weakReference.get() : null), (Object)activity)) break block1;
                    Logger.Companion.d("NativeAd-VideoContentView", "onActivityResumed and try to play video");
                    AdVideoView adVideoView = this.this$0.getVideoView();
                    if (adVideoView != null) {
                        adVideoView.playOnActivityResumed$vungle_ads_release();
                    }
                }
            }

            public void onActivityPaused(@NotNull Activity activity) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                    WeakReference weakReference = VideoContentView.access$getAdActivity$p(this.this$0);
                    if (!Intrinsics.areEqual((Object)(weakReference != null ? (Activity)weakReference.get() : null), (Object)activity)) break block1;
                    Logger.Companion.d("NativeAd-VideoContentView", "onActivityPaused and pause video");
                    AdVideoView adVideoView = this.this$0.getVideoView();
                    if (adVideoView != null) {
                        adVideoView.pauseOnActivityPaused$vungle_ads_release();
                    }
                }
            }
        };
    }

    @Nullable
    public final AdVideoView getVideoView() {
        return this.videoView;
    }

    public final void setVideoView(@Nullable AdVideoView adVideoView) {
        this.videoView = adVideoView;
    }

    @VisibleForTesting
    public static /* synthetic */ void getVideoView$annotations() {
    }

    private final Activity getAdActivity(Context context) {
        if (context instanceof Activity) {
            return (Activity)context;
        }
        Context ctx = context;
        while (ctx instanceof ContextWrapper) {
            if (ctx instanceof Activity) {
                return (Activity)ctx;
            }
            Intrinsics.checkNotNullExpressionValue((Object)((ContextWrapper)ctx).getBaseContext(), (String)"ctx.baseContext");
        }
        return null;
    }

    private final void showImageViewAsFallback() {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        super.render(context);
        ImageView imageView = this.getImageView$vungle_ads_release();
        if (imageView != null) {
            imageView.setVisibility(0);
        }
        ImageView imageView2 = this.muteView;
        if (imageView2 != null) {
            imageView2.setVisibility(8);
        }
        AdVideoView adVideoView = this.videoView;
        if (adVideoView != null) {
            adVideoView.setVisibility(8);
        }
    }

    private final void onMuteUpdateUI(boolean muted) {
        block1: {
            block0: {
                if (!muted) break block0;
                ImageView imageView = this.muteView;
                if (imageView == null) break block1;
                imageView.setImageResource(R.drawable.liftoff_icon_mute);
                break block1;
            }
            ImageView imageView = this.muteView;
            if (imageView == null) break block1;
            imageView.setImageResource(R.drawable.liftoff_icon_unmute);
        }
    }

    private final void toggleMute() {
        block0: {
            AdVideoView adVideoView = this.videoView;
            if (adVideoView == null) break block0;
            AdVideoView it = adVideoView;
            boolean bl = false;
            boolean targetMuted = !it.isMuted();
            it.setMuted(targetMuted);
            this.onMuteUpdateUI(targetMuted);
        }
    }

    protected void onAttachedToWindow() {
        block3: {
            Object object;
            super.onAttachedToWindow();
            Object object2 = this;
            try {
                VideoContentView $this$onAttachedToWindow_u24lambda_u2d1 = object2;
                boolean bl = false;
                if (!$this$onAttachedToWindow_u24lambda_u2d1.isReceiverRegistered.getAndSet(true)) {
                    Logger.Companion.d(TAG, "registerReceiver()");
                    $this$onAttachedToWindow_u24lambda_u2d1.ignoredFirst.set(false);
                    $this$onAttachedToWindow_u24lambda_u2d1.ringerModeReceiver.setListener($this$onAttachedToWindow_u24lambda_u2d1);
                    IntentFilter filter = new IntentFilter("android.media.RINGER_MODE_CHANGED");
                    $this$onAttachedToWindow_u24lambda_u2d1.getContext().registerReceiver((BroadcastReceiver)$this$onAttachedToWindow_u24lambda_u2d1.ringerModeReceiver, filter);
                }
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block3;
            Object it = object = throwable;
            boolean bl = false;
            Logger.Companion.e(TAG, "registerReceiver", (Throwable)it);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.unRegisterRingerMode();
    }

    private final void unRegisterRingerMode() {
        block3: {
            Object object;
            Object object2 = this;
            try {
                VideoContentView $this$unRegisterRingerMode_u24lambda_u2d3 = object2;
                boolean bl = false;
                if ($this$unRegisterRingerMode_u24lambda_u2d3.isReceiverRegistered.getAndSet(false)) {
                    Logger.Companion.d(TAG, "unregisterReceiver()");
                    $this$unRegisterRingerMode_u24lambda_u2d3.ringerModeReceiver.setListener(null);
                    $this$unRegisterRingerMode_u24lambda_u2d3.getContext().unregisterReceiver((BroadcastReceiver)$this$unRegisterRingerMode_u24lambda_u2d3.ringerModeReceiver);
                }
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block3;
            Object it = object = throwable;
            boolean bl = false;
            Logger.Companion.e(TAG, "unregisterReceiver", (Throwable)it);
        }
    }

    @Override
    public void notifySilentModeChange(boolean silentModeEnabled) {
        Boolean isMuted = this.isMuted$vungle_ads_release();
        Logger.Companion.d(TAG, "silentModeEnabled=" + silentModeEnabled + " currentIsMuted=" + isMuted);
        if (this.ignoredFirst.getAndSet(true) && isMuted != null && !Intrinsics.areEqual((Object)silentModeEnabled, (Object)isMuted)) {
            this.toggleMute();
        }
    }

    @Override
    public void render(@NotNull Context context) {
        block19: {
            Object object;
            Object $this$render_u24lambda_u2d8;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Logger.Companion.d(TAG, "initView");
            ImageView imageView = this.getImageView$vungle_ads_release();
            if (imageView != null) {
                imageView.setVisibility(8);
            }
            ActivityManager.Companion.addLifecycleListener(this.activityLifecycle);
            boolean startMuted = this.getInternal().isStartMuted$vungle_ads_release();
            Logger.Companion.d(TAG, "startMuted=" + startMuted);
            AdVideoView adVideoView = this.videoView = new AdVideoView(context, null, 2, null);
            if (adVideoView != null) {
                adVideoView.setMuted(startMuted);
            }
            AdVideoView adVideoView2 = this.videoView;
            if (adVideoView2 != null) {
                adVideoView2.setLooping(false);
            }
            AdVideoView adVideoView3 = this.videoView;
            if (adVideoView3 != null) {
                adVideoView3.setAutoVisibility(true, 0.01f);
            }
            AdVideoView adVideoView4 = this.videoView;
            if (adVideoView4 != null) {
                adVideoView4.setVideoLifecycleCallback(this);
            }
            AdVideoView adVideoView5 = this.videoView;
            if (adVideoView5 != null) {
                adVideoView5.setVideoTransformCallback$vungle_ads_release((arg_0, arg_1) -> VideoContentView.render$lambda-5(this, arg_0, arg_1));
            }
            RelativeLayout.LayoutParams videoParams = new RelativeLayout.LayoutParams(-1, -1);
            videoParams.addRule(13);
            AdVideoView adVideoView6 = this.videoView;
            if (adVideoView6 != null) {
                adVideoView6.setLayoutParams((ViewGroup.LayoutParams)videoParams);
            }
            this.addView((View)this.videoView);
            this.muteView = new ImageView(context);
            RelativeLayout.LayoutParams muteParams = new RelativeLayout.LayoutParams(-2, -2);
            muteParams.addRule(5);
            muteParams.addRule(6);
            ImageView imageView2 = this.muteView;
            if (imageView2 != null) {
                imageView2.setLayoutParams((ViewGroup.LayoutParams)muteParams);
            }
            ImageView imageView3 = this.muteView;
            if (imageView3 != null) {
                imageView3.setClickable(true);
            }
            ImageView imageView4 = this.muteView;
            if (imageView4 != null) {
                imageView4.setOnClickListener(arg_0 -> VideoContentView.render$lambda-6(this, arg_0));
            }
            this.onMuteUpdateUI(startMuted);
            this.addView((View)this.muteView);
            ImageView imageView5 = this.muteView;
            if (imageView5 != null) {
                imageView5.bringToFront();
            }
            this.requestLayout();
            Object object2 = this;
            try {
                $this$render_u24lambda_u2d8 = object2;
                boolean bl = false;
                Activity activity = super.getAdActivity(context);
                if (activity != null) {
                    Activity it = activity;
                    boolean bl2 = false;
                    ((VideoContentView)$this$render_u24lambda_u2d8).adActivity = new WeakReference<Activity>(it);
                }
                WeakReference<Activity> weakReference = ((VideoContentView)$this$render_u24lambda_u2d8).adActivity;
                $this$render_u24lambda_u2d8 = Result.constructor-impl((Object)Logger.Companion.d(TAG, "adActivity=" + (weakReference != null ? (Activity)weakReference.get() : null)));
            }
            catch (Throwable bl) {
                $this$render_u24lambda_u2d8 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            this.preparedDurationMetric.markStart();
            object2 = this;
            try {
                Unit unit;
                VideoContentView $this$render_u24lambda_u2d9 = object2;
                boolean bl = false;
                String $this$toUri$iv = $this$render_u24lambda_u2d9.getInternal().getMainVideoPath$vungle_ads_release();
                boolean $i$f$toUri = false;
                Uri uri = Uri.parse((String)$this$toUri$iv);
                Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(this)");
                Uri uri2 = uri;
                AdVideoView adVideoView7 = $this$render_u24lambda_u2d9.videoView;
                if (adVideoView7 != null) {
                    adVideoView7.setSource(uri2);
                }
                AdVideoView adVideoView8 = $this$render_u24lambda_u2d9.videoView;
                if (adVideoView8 != null) {
                    adVideoView8.play();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                object = Result.constructor-impl((Object)unit);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block19;
            Object e2 = object = throwable;
            boolean bl = false;
            this.onVideoError(-2, String.valueOf(((Throwable)e2).getLocalizedMessage()));
        }
    }

    @Override
    public int getDuration() {
        AdVideoView adVideoView = this.videoView;
        return adVideoView != null ? adVideoView.getDurationMs() : 0;
    }

    @Override
    public int getCurrentTime() {
        AdVideoView adVideoView = this.videoView;
        return adVideoView != null ? adVideoView.getCurrentPositionMs() : 0;
    }

    @VisibleForTesting
    @Nullable
    public final Boolean isMuted$vungle_ads_release() {
        AdVideoView adVideoView = this.videoView;
        return adVideoView != null ? Boolean.valueOf(adVideoView.isMuted()) : null;
    }

    @Override
    public void onVideoPrepared() {
        this.preparedDurationMetric.markEnd();
        AnalyticsClient.logMetric$vungle_ads_release$default(AnalyticsClient.INSTANCE, this.preparedDurationMetric, this.getInternal().getLogEntry$vungle_ads_release(), null, 4, null);
    }

    @Override
    public void onVideoPlay() {
        block0: {
            NativeVideoListener nativeVideoListener = this.getNativeVideoListener();
            if (nativeVideoListener == null) break block0;
            nativeVideoListener.onVideoPlay();
        }
    }

    @Override
    public void onVideoPause() {
        block0: {
            NativeVideoListener nativeVideoListener = this.getNativeVideoListener();
            if (nativeVideoListener == null) break block0;
            nativeVideoListener.onVideoPause();
        }
    }

    @Override
    public void onVideoCompleted() {
        block0: {
            NativeAdInternal.trackTpatEvent$default(this.getInternal(), "video.close", null, 2, null);
            NativeAdInternal.trackOMEvent$default(this.getInternal(), 3, null, 2, null);
            NativeVideoListener nativeVideoListener = this.getNativeVideoListener();
            if (nativeVideoListener == null) break block0;
            nativeVideoListener.onVideoEnd();
        }
    }

    @Override
    public void onVideoProgress(int percentage) {
        boolean bl = 1 <= percentage ? percentage < 25 : false;
        if (bl) {
            if (this.startFired.compareAndSet(false, true)) {
                int duration = this.getDuration();
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"OM_KEY_DURATION", (Object)duration), TuplesKt.to((Object)"OM_KEY_VOLUME", (Object)(Intrinsics.areEqual((Object)this.isMuted$vungle_ads_release(), (Object)true) ? 0 : 1))};
                Map args = MapsKt.mapOf((Pair[])pairArray);
                this.getInternal().trackTpatEvent("video.length", String.valueOf(duration));
                this.getInternal().trackOMEvent(4, args);
            }
        } else {
            boolean bl2 = 25 <= percentage ? percentage < 50 : false;
            if (bl2) {
                if (this.cp25Fired.compareAndSet(false, true)) {
                    NativeAdInternal.trackTpatEvent$default(this.getInternal(), "checkpoint.25", null, 2, null);
                    NativeAdInternal.trackOMEvent$default(this.getInternal(), 5, null, 2, null);
                }
            } else {
                boolean bl3 = 50 <= percentage ? percentage < 75 : false;
                if (bl3) {
                    if (this.cp50Fired.compareAndSet(false, true)) {
                        NativeAdInternal.trackTpatEvent$default(this.getInternal(), "checkpoint.50", null, 2, null);
                        NativeAdInternal.trackOMEvent$default(this.getInternal(), 6, null, 2, null);
                    }
                } else {
                    boolean bl4 = 75 <= percentage ? percentage < 100 : false;
                    if (bl4) {
                        if (this.cp75Fired.compareAndSet(false, true)) {
                            NativeAdInternal.trackTpatEvent$default(this.getInternal(), "checkpoint.75", null, 2, null);
                            NativeAdInternal.trackOMEvent$default(this.getInternal(), 7, null, 2, null);
                        }
                    } else if (percentage >= 100 && this.cp100Fired.compareAndSet(false, true)) {
                        NativeAdInternal.trackTpatEvent$default(this.getInternal(), "checkpoint.100", null, 2, null);
                    }
                }
            }
        }
    }

    @Override
    public void onVideoMuted(boolean muted) {
        block1: {
            block0: {
                if (!muted) break block0;
                NativeAdInternal.trackTpatEvent$default(this.getInternal(), "video.mute", null, 2, null);
                NativeAdInternal.trackOMEvent$default(this.getInternal(), 9, null, 2, null);
                NativeVideoListener nativeVideoListener = this.getNativeVideoListener();
                if (nativeVideoListener == null) break block1;
                nativeVideoListener.onVideoMute();
                break block1;
            }
            NativeAdInternal.trackTpatEvent$default(this.getInternal(), "video.unmute", null, 2, null);
            NativeAdInternal.trackOMEvent$default(this.getInternal(), 10, null, 2, null);
            NativeVideoListener nativeVideoListener = this.getNativeVideoListener();
            if (nativeVideoListener == null) break block1;
            nativeVideoListener.onVideoUnmute();
        }
    }

    @Override
    public void onVideoError(int what, @NotNull String extra) {
        Intrinsics.checkNotNullParameter((Object)extra, (String)"extra");
        if (this.videoErrorHandled.getAndSet(true)) {
            return;
        }
        this.showImageViewAsFallback();
        String error = "w=" + what + " e=" + extra + " url=" + this.getInternal().getOriginalVideoUrl$vungle_ads_release();
        new NativeVideoPlaybackError(error).setLogEntry$vungle_ads_release(this.getInternal().getLogEntry$vungle_ads_release()).logErrorNoReturnValue$vungle_ads_release();
    }

    @Override
    public void destroy$vungle_ads_release() {
        Logger.Companion.d(TAG, "destroy()");
        this.unRegisterRingerMode();
        WeakReference<Activity> weakReference = this.adActivity;
        if (weakReference != null) {
            weakReference.clear();
        }
        this.adActivity = null;
        ActivityManager.Companion.removeLifecycleListener(this.activityLifecycle);
        AdVideoView adVideoView = this.videoView;
        if (adVideoView != null) {
            adVideoView.release();
        }
        this.videoView = null;
        super.destroy$vungle_ads_release();
    }

    private static final void render$lambda-5(VideoContentView this$0, float left, float top) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ImageView imageView = this$0.muteView;
        if (imageView != null) {
            imageView.setTranslationX(left);
        }
        ImageView imageView2 = this$0.muteView;
        if (imageView2 != null) {
            imageView2.setTranslationY(top);
        }
    }

    private static final void render$lambda-6(VideoContentView this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.toggleMute();
    }

    public static final /* synthetic */ WeakReference access$getAdActivity$p(VideoContentView $this) {
        return $this.adActivity;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/vungle/ads/internal/ui/view/VideoContentView$Companion;", "", "()V", "TAG", "", "vungle-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

