/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.ui.view;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.media.AudioAttributes;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import androidx.annotation.VisibleForTesting;
import com.vungle.ads.internal.ui.view.AdVideoView;
import com.vungle.ads.internal.util.Logger;
import com.vungle.ads.nativead.NativeVideoContract;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\"\b\u0000\u0018\u0000 z2\u00020\u00012\u00020\u0002:\u0003z{|B\u001b\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010@\u001a\u00020AH\u0002J\b\u0010B\u001a\u00020AH\u0002J\b\u0010C\u001a\u00020AH\u0002J\b\u0010D\u001a\u00020AH\u0002J\b\u0010E\u001a\u00020AH\u0002J\b\u0010F\u001a\u00020AH\u0002J\b\u0010G\u001a\u00020AH\u0002J\b\u0010H\u001a\u00020AH\u0002J\u0006\u0010I\u001a\u00020\rJ\u0006\u0010J\u001a\u00020\rJ\u0006\u0010K\u001a\u00020\tJ\b\u0010L\u001a\u00020\tH\u0002J\b\u0010M\u001a\u00020AH\u0002J\u0018\u0010N\u001a\u00020A2\u0006\u0010O\u001a\u00020\r2\u0006\u0010P\u001a\u00020QH\u0002J\u0010\u0010R\u001a\u00020A2\u0006\u0010\u001f\u001a\u00020\tH\u0002J\b\u0010S\u001a\u00020AH\u0002J\b\u0010T\u001a\u00020AH\u0002J\u0010\u0010U\u001a\u00020A2\u0006\u0010V\u001a\u00020\rH\u0002J\b\u0010W\u001a\u00020AH\u0014J\b\u0010X\u001a\u00020AH\u0014J \u0010Y\u001a\u00020A2\u0006\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020\r2\u0006\u0010]\u001a\u00020\rH\u0016J\u0010\u0010^\u001a\u00020\t2\u0006\u0010Z\u001a\u00020[H\u0016J \u0010_\u001a\u00020A2\u0006\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020\r2\u0006\u0010]\u001a\u00020\rH\u0016J\u0010\u0010`\u001a\u00020A2\u0006\u0010Z\u001a\u00020[H\u0016J\u0006\u0010a\u001a\u00020AJ\b\u0010b\u001a\u00020AH\u0002J\r\u0010c\u001a\u00020AH\u0000\u00a2\u0006\u0002\bdJ\u0006\u0010e\u001a\u00020AJ\r\u0010f\u001a\u00020AH\u0000\u00a2\u0006\u0002\bgJ\b\u0010h\u001a\u00020AH\u0002J\u0006\u0010i\u001a\u00020AJ\u000e\u0010j\u001a\u00020A2\u0006\u0010k\u001a\u00020\rJ\u0018\u0010l\u001a\u00020A2\u0006\u0010m\u001a\u00020\t2\b\b\u0002\u0010n\u001a\u00020>J\u000e\u0010o\u001a\u00020A2\u0006\u0010p\u001a\u00020\tJ\u000e\u0010q\u001a\u00020A2\u0006\u0010r\u001a\u00020\tJ\u000e\u0010s\u001a\u00020A2\u0006\u0010t\u001a\u00020(J\u000e\u0010u\u001a\u00020A2\u0006\u0010v\u001a\u00020\u000bJ\u0017\u0010w\u001a\u00020A2\b\u0010\n\u001a\u0004\u0018\u00010;H\u0000\u00a2\u0006\u0002\bxJ\u0006\u0010y\u001a\u00020AR\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00168\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010)\u001a\u0004\u0018\u00010*8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b+\u0010\u0019\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R$\u00100\u001a\u0002018\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b2\u0010\u0019\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u000e\u00107\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010:\u001a\u0004\u0018\u00010;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020>X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006}"}, d2={"Lcom/vungle/ads/internal/ui/view/AdVideoView;", "Landroid/widget/FrameLayout;", "Landroid/view/TextureView$SurfaceTextureListener;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "autoVisibility", "", "callback", "Lcom/vungle/ads/nativead/NativeVideoContract$VideoLifecycleCallback;", "durationMs", "", "handler", "Landroid/os/Handler;", "lastPosMs", "lastProgressSent", "layoutListener", "Landroid/view/ViewTreeObserver$OnGlobalLayoutListener;", "looping", "mediaPlayerFactory", "Lkotlin/Function0;", "Landroid/media/MediaPlayer;", "getMediaPlayerFactory$vungle_ads_release$annotations", "()V", "getMediaPlayerFactory$vungle_ads_release", "()Lkotlin/jvm/functions/Function0;", "setMediaPlayerFactory$vungle_ads_release", "(Lkotlin/jvm/functions/Function0;)V", "mp", "muted", "prepared", "Ljava/util/concurrent/atomic/AtomicBoolean;", "preparing", "progressUpdater", "Lcom/vungle/ads/internal/ui/view/AdVideoView$ProgressUpdateRunnable;", "scrollListener", "Landroid/view/ViewTreeObserver$OnScrollChangedListener;", "sourceUri", "Landroid/net/Uri;", "surface", "Landroid/view/Surface;", "getSurface$vungle_ads_release$annotations", "getSurface$vungle_ads_release", "()Landroid/view/Surface;", "setSurface$vungle_ads_release", "(Landroid/view/Surface;)V", "texture", "Landroid/view/TextureView;", "getTexture$vungle_ads_release$annotations", "getTexture$vungle_ads_release", "()Landroid/view/TextureView;", "setTexture$vungle_ads_release", "(Landroid/view/TextureView;)V", "videoCompleted", "videoH", "videoPaused", "videoTransformCallback", "Lcom/vungle/ads/internal/ui/view/AdVideoView$VideoTransformCallback;", "videoW", "visibilityThreshold", "", "wantPlay", "applyMute", "", "applyTransform", "beginProgressUpdates", "calculateAndNotifyProgress", "checkVisibility", "detachSurface", "endProgressUpdates", "ensurePlayer", "getCurrentPositionMs", "getDurationMs", "isMuted", "isVisibleEnough", "notifyCompleted", "notifyError", "what", "extra", "", "notifyMuted", "notifyPause", "notifyPlay", "notifyProgress", "percentage", "onAttachedToWindow", "onDetachedFromWindow", "onSurfaceTextureAvailable", "st", "Landroid/graphics/SurfaceTexture;", "width", "height", "onSurfaceTextureDestroyed", "onSurfaceTextureSizeChanged", "onSurfaceTextureUpdated", "pause", "pauseInternal", "pauseOnActivityPaused", "pauseOnActivityPaused$vungle_ads_release", "play", "playOnActivityResumed", "playOnActivityResumed$vungle_ads_release", "prepareIfNeeded", "release", "seekTo", "ms", "setAutoVisibility", "enabled", "threshold", "setLooping", "loop", "setMuted", "mute", "setSource", "uri", "setVideoLifecycleCallback", "lifecycleCallback", "setVideoTransformCallback", "setVideoTransformCallback$vungle_ads_release", "stop", "Companion", "ProgressUpdateRunnable", "VideoTransformCallback", "vungle-ads_release"})
public final class AdVideoView
extends FrameLayout
implements TextureView.SurfaceTextureListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean autoVisibility;
    @NotNull
    private final ViewTreeObserver.OnScrollChangedListener scrollListener;
    @NotNull
    private final ViewTreeObserver.OnGlobalLayoutListener layoutListener;
    private float visibilityThreshold;
    @NotNull
    private TextureView texture;
    @Nullable
    private Surface surface;
    @Nullable
    private MediaPlayer mp;
    @Nullable
    private Uri sourceUri;
    @NotNull
    private AtomicBoolean prepared;
    @NotNull
    private AtomicBoolean preparing;
    private boolean wantPlay;
    private boolean videoPaused;
    private int lastPosMs;
    private int durationMs;
    private boolean muted;
    private boolean looping;
    private boolean videoCompleted;
    private int videoW;
    private int videoH;
    @Nullable
    private NativeVideoContract.VideoLifecycleCallback callback;
    @Nullable
    private VideoTransformCallback videoTransformCallback;
    private int lastProgressSent;
    @NotNull
    private final Handler handler;
    @NotNull
    private final ProgressUpdateRunnable progressUpdater;
    @NotNull
    private Function0<? extends MediaPlayer> mediaPlayerFactory;
    @NotNull
    private static final String TAG = "NativeAd-Video";
    private static final long PROGRESS_INTERVAL_MS = 1000L;
    public static final int ERROR_VIDEO_PREPARE_FAILED = -1;
    public static final int ERROR_VIDEO_PLAYBACK_FAILED = -2;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public AdVideoView(@NotNull Context context, @Nullable AttributeSet attrs) {
        void it;
        TextureView textureView;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.scrollListener = () -> AdVideoView.scrollListener$lambda-0(this);
        this.layoutListener = () -> AdVideoView.layoutListener$lambda-1(this);
        this.visibilityThreshold = 0.01f;
        TextureView textureView2 = textureView = new TextureView(context);
        AdVideoView adVideoView = this;
        boolean bl = false;
        it.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
        adVideoView.texture = textureView;
        this.prepared = new AtomicBoolean(false);
        this.preparing = new AtomicBoolean(false);
        this.lastProgressSent = -1;
        this.handler = new Handler(Looper.getMainLooper());
        this.progressUpdater = new ProgressUpdateRunnable(this);
        this.mediaPlayerFactory = mediaPlayerFactory.1.INSTANCE;
        this.setClickable(false);
        this.setFocusable(false);
        this.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.addView((View)this.texture, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
    }

    public /* synthetic */ AdVideoView(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }

    @NotNull
    public final TextureView getTexture$vungle_ads_release() {
        return this.texture;
    }

    public final void setTexture$vungle_ads_release(@NotNull TextureView textureView) {
        Intrinsics.checkNotNullParameter((Object)textureView, (String)"<set-?>");
        this.texture = textureView;
    }

    @VisibleForTesting
    public static /* synthetic */ void getTexture$vungle_ads_release$annotations() {
    }

    @Nullable
    public final Surface getSurface$vungle_ads_release() {
        return this.surface;
    }

    public final void setSurface$vungle_ads_release(@Nullable Surface surface) {
        this.surface = surface;
    }

    @VisibleForTesting
    public static /* synthetic */ void getSurface$vungle_ads_release$annotations() {
    }

    @NotNull
    public final Function0<MediaPlayer> getMediaPlayerFactory$vungle_ads_release() {
        return this.mediaPlayerFactory;
    }

    public final void setMediaPlayerFactory$vungle_ads_release(@NotNull Function0<? extends MediaPlayer> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.mediaPlayerFactory = function0;
    }

    @VisibleForTesting
    public static /* synthetic */ void getMediaPlayerFactory$vungle_ads_release$annotations() {
    }

    protected void onAttachedToWindow() {
        Logger.Companion.d(TAG, "onAttachedToWindow()");
        super.onAttachedToWindow();
        this.getViewTreeObserver().addOnScrollChangedListener(this.scrollListener);
        this.getViewTreeObserver().addOnGlobalLayoutListener(this.layoutListener);
    }

    protected void onDetachedFromWindow() {
        Logger.Companion.d(TAG, "onDetachedFromWindow()");
        super.onDetachedFromWindow();
        this.getViewTreeObserver().removeOnScrollChangedListener(this.scrollListener);
        this.getViewTreeObserver().removeOnGlobalLayoutListener(this.layoutListener);
        this.pauseInternal();
        this.detachSurface();
    }

    public final void setVideoLifecycleCallback(@NotNull NativeVideoContract.VideoLifecycleCallback lifecycleCallback) {
        Intrinsics.checkNotNullParameter((Object)lifecycleCallback, (String)"lifecycleCallback");
        this.callback = lifecycleCallback;
    }

    public final void setVideoTransformCallback$vungle_ads_release(@Nullable VideoTransformCallback callback) {
        this.videoTransformCallback = callback;
    }

    public final void setSource(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this.sourceUri = uri;
        this.prepared.set(false);
        this.preparing.set(false);
        this.videoW = 0;
        this.videoH = 0;
        this.prepareIfNeeded();
    }

    public final void playOnActivityResumed$vungle_ads_release() {
        if (this.wantPlay && this.videoPaused && !this.videoCompleted) {
            this.play();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void play() {
        this.wantPlay = true;
        this.videoPaused = false;
        this.videoCompleted = false;
        Surface surface = this.surface;
        Logger.Companion.d(TAG, "play(): prepared=" + this.prepared + ", surfaceValid=" + (surface != null ? Boolean.valueOf(surface.isValid()) : null) + ", visible=" + this.isVisibleEnough());
        if (this.prepared.get()) {
            Surface surface2 = this.surface;
            boolean bl = surface2 != null ? surface2.isValid() : false;
            if (bl && this.isVisibleEnough()) {
                MediaPlayer mediaPlayer = this.mp;
                if (mediaPlayer != null ? mediaPlayer.isPlaying() : false) return;
                MediaPlayer mediaPlayer2 = this.mp;
                Logger.Companion.d(TAG, "play(): pos=" + (mediaPlayer2 != null ? Integer.valueOf(mediaPlayer2.getCurrentPosition()) : null) + " ms");
                MediaPlayer mediaPlayer3 = this.mp;
                if (mediaPlayer3 != null) {
                    mediaPlayer3.start();
                }
                this.notifyPlay();
                return;
            }
        }
        this.prepareIfNeeded();
    }

    public final void pauseOnActivityPaused$vungle_ads_release() {
        this.videoPaused = true;
        this.pauseInternal();
    }

    public final void pause() {
        MediaPlayer mediaPlayer = this.mp;
        Logger.Companion.d(TAG, "pause() at pos=" + (mediaPlayer != null ? Integer.valueOf(mediaPlayer.getCurrentPosition()) : null) + " ms");
        this.videoPaused = true;
        this.wantPlay = false;
        this.pauseInternal();
    }

    public final void stop() {
        this.wantPlay = false;
        this.lastPosMs = 0;
        this.videoCompleted = false;
        MediaPlayer player = this.mp;
        Surface surface = this.surface;
        Logger.Companion.d(TAG, "stop(): prepared=" + this.prepared + ", surface=" + (surface != null ? Boolean.valueOf(surface.isValid()) : null));
        if (player != null && this.prepared.get()) {
            if (player.isPlaying()) {
                player.pause();
                this.notifyPause();
            }
            player.seekTo(0);
            Surface surface2 = this.surface;
            boolean bl = surface2 != null ? surface2.isValid() : false;
            if (bl && !player.isPlaying()) {
                player.start();
                player.pause();
            }
        }
        this.endProgressUpdates();
        this.lastProgressSent = -1;
    }

    public final void seekTo(int ms) {
        this.lastPosMs = RangesKt.coerceAtLeast((int)ms, (int)0);
        Logger.Companion.d(TAG, "seekTo " + this.lastPosMs);
        if (this.prepared.get()) {
            MediaPlayer mediaPlayer = this.mp;
            if (mediaPlayer != null) {
                mediaPlayer.seekTo(this.lastPosMs);
            }
            this.calculateAndNotifyProgress();
        }
    }

    public final void setLooping(boolean loop) {
        Logger.Companion.d(TAG, "setLooping to " + this.looping);
        this.looping = loop;
        MediaPlayer mediaPlayer = this.mp;
        if (mediaPlayer != null) {
            mediaPlayer.setLooping(loop);
        }
    }

    public final void setMuted(boolean mute) {
        Logger.Companion.d(TAG, "setMuted to " + mute);
        this.muted = mute;
        this.applyMute();
        this.notifyMuted(mute);
    }

    public final boolean isMuted() {
        return this.muted;
    }

    public final void setAutoVisibility(boolean enabled, float threshold) {
        Logger.Companion.d(TAG, "setAutoVisibility enabled=" + enabled + " threshold=" + threshold);
        this.autoVisibility = enabled;
        this.visibilityThreshold = RangesKt.coerceIn((float)threshold, (float)0.0f, (float)1.0f);
        if (enabled) {
            this.checkVisibility();
        }
    }

    public static /* synthetic */ void setAutoVisibility$default(AdVideoView adVideoView, boolean bl, float f2, int n, Object object) {
        if ((n & 2) != 0) {
            f2 = 0.8f;
        }
        adVideoView.setAutoVisibility(bl, f2);
    }

    public final int getCurrentPositionMs() {
        int n;
        if (this.prepared.get()) {
            Object object;
            Object object2 = this;
            try {
                AdVideoView $this$getCurrentPositionMs_u24lambda_u2d3 = object2;
                boolean bl = false;
                MediaPlayer mediaPlayer = $this$getCurrentPositionMs_u24lambda_u2d3.mp;
                object = Result.constructor-impl((Object)(mediaPlayer != null ? mediaPlayer.getCurrentPosition() : $this$getCurrentPositionMs_u24lambda_u2d3.lastPosMs));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object2 = object;
            object = this.lastPosMs;
            n = RangesKt.coerceAtLeast((int)((Number)(Result.isFailure-impl((Object)object2) ? object : object2)).intValue(), (int)0);
        } else {
            n = RangesKt.coerceAtLeast((int)this.lastPosMs, (int)0);
        }
        return n;
    }

    public final int getDurationMs() {
        return this.durationMs;
    }

    public final void release() {
        Object object;
        Object $this$release_u24lambda_u2d6;
        Object $this$release_u24lambda_u2d4;
        Logger.Companion.d(TAG, "release()");
        this.pause();
        this.handler.removeCallbacks((Runnable)this.progressUpdater);
        Object object2 = this;
        try {
            Unit unit;
            $this$release_u24lambda_u2d4 = object2;
            boolean bl = false;
            MediaPlayer mediaPlayer = $this$release_u24lambda_u2d4.mp;
            if (mediaPlayer != null) {
                mediaPlayer.setSurface(null);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            $this$release_u24lambda_u2d4 = Result.constructor-impl((Object)unit);
        }
        catch (Throwable bl) {
            $this$release_u24lambda_u2d4 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$release_u24lambda_u2d4;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object it = $this$release_u24lambda_u2d4 = throwable;
            boolean bl = false;
            Logger.Companion.e(TAG, "Failed to clear Surface", (Throwable)it);
        }
        object2 = this;
        try {
            Unit unit;
            $this$release_u24lambda_u2d6 = object2;
            boolean bl = false;
            MediaPlayer mediaPlayer = $this$release_u24lambda_u2d6.mp;
            if (mediaPlayer != null) {
                mediaPlayer.stop();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            $this$release_u24lambda_u2d6 = Result.constructor-impl((Object)unit);
        }
        catch (Throwable bl) {
            $this$release_u24lambda_u2d6 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$release_u24lambda_u2d6;
        Throwable throwable2 = Result.exceptionOrNull-impl((Object)object2);
        if (throwable2 != null) {
            Object it = $this$release_u24lambda_u2d6 = throwable2;
            boolean bl = false;
            Logger.Companion.e(TAG, "Failed to stop MediaPlayer", (Throwable)it);
        }
        object2 = this;
        try {
            Unit unit;
            AdVideoView $this$release_u24lambda_u2d8 = object2;
            boolean bl = false;
            MediaPlayer mediaPlayer = $this$release_u24lambda_u2d8.mp;
            if (mediaPlayer != null) {
                mediaPlayer.release();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            object = Result.constructor-impl((Object)unit);
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = object;
        Throwable throwable3 = Result.exceptionOrNull-impl((Object)object2);
        if (throwable3 != null) {
            Object it = object = throwable3;
            boolean bl = false;
            Logger.Companion.e(TAG, "Failed to release MediaPlayer", (Throwable)it);
        }
        this.mp = null;
        this.detachSurface();
        this.prepared.set(false);
        this.preparing.set(false);
    }

    /*
     * WARNING - void declaration
     */
    private final void ensurePlayer() {
        void $this$ensurePlayer_u24lambda_u2d14;
        if (this.mp != null) {
            return;
        }
        Object object = this.mediaPlayerFactory.invoke();
        MediaPlayer mediaPlayer = (MediaPlayer)object;
        AdVideoView adVideoView = this;
        boolean bl = false;
        $this$ensurePlayer_u24lambda_u2d14.setAudioAttributes(new AudioAttributes.Builder().setUsage(1).setContentType(3).build());
        $this$ensurePlayer_u24lambda_u2d14.setOnPreparedListener(arg_0 -> AdVideoView.ensurePlayer$lambda-14$lambda-10(this, arg_0));
        $this$ensurePlayer_u24lambda_u2d14.setOnVideoSizeChangedListener((arg_0, arg_1, arg_2) -> AdVideoView.ensurePlayer$lambda-14$lambda-11(this, arg_0, arg_1, arg_2));
        $this$ensurePlayer_u24lambda_u2d14.setOnCompletionListener(arg_0 -> AdVideoView.ensurePlayer$lambda-14$lambda-12(this, arg_0));
        $this$ensurePlayer_u24lambda_u2d14.setOnErrorListener((arg_0, arg_1, arg_2) -> AdVideoView.ensurePlayer$lambda-14$lambda-13(this, arg_0, arg_1, arg_2));
        adVideoView.mp = (MediaPlayer)object;
    }

    private final void pauseInternal() {
        Object object;
        MediaPlayer player = this.mp;
        if (player != null && this.prepared.get() && player.isPlaying()) {
            Logger.Companion.d(TAG, "pauseInternal(): pos=" + player.getCurrentPosition() + " ms");
            player.pause();
            this.notifyPause();
        } else {
            Logger.Companion.d(TAG, "pauseInternal(): no-op (not playing or no player)");
        }
        Object object2 = this;
        AdVideoView adVideoView = this;
        try {
            AdVideoView $this$pauseInternal_u24lambda_u2d15 = object2;
            boolean bl = false;
            MediaPlayer mediaPlayer = player;
            object = Result.constructor-impl((Object)(mediaPlayer != null ? mediaPlayer.getCurrentPosition() : $this$pauseInternal_u24lambda_u2d15.lastPosMs));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        object = this.lastPosMs;
        adVideoView.lastPosMs = ((Number)(Result.isFailure-impl((Object)object2) ? object : object2)).intValue();
    }

    private final void prepareIfNeeded() {
        block10: {
            Object object;
            Object object2 = this;
            try {
                Unit unit;
                AdVideoView $this$prepareIfNeeded_u24lambda_u2d16 = object2;
                boolean bl = false;
                Uri uri = $this$prepareIfNeeded_u24lambda_u2d16.sourceUri;
                if (uri == null) {
                    return;
                }
                Uri uri2 = uri;
                if ($this$prepareIfNeeded_u24lambda_u2d16.prepared.get() || $this$prepareIfNeeded_u24lambda_u2d16.preparing.get()) {
                    return;
                }
                $this$prepareIfNeeded_u24lambda_u2d16.ensurePlayer();
                $this$prepareIfNeeded_u24lambda_u2d16.preparing.set(true);
                $this$prepareIfNeeded_u24lambda_u2d16.prepared.set(false);
                MediaPlayer mediaPlayer = $this$prepareIfNeeded_u24lambda_u2d16.mp;
                if (mediaPlayer != null) {
                    mediaPlayer.reset();
                }
                MediaPlayer mediaPlayer2 = $this$prepareIfNeeded_u24lambda_u2d16.mp;
                if (mediaPlayer2 != null) {
                    mediaPlayer2.setLooping($this$prepareIfNeeded_u24lambda_u2d16.looping);
                }
                MediaPlayer mediaPlayer3 = $this$prepareIfNeeded_u24lambda_u2d16.mp;
                if (mediaPlayer3 != null) {
                    mediaPlayer3.setSurface($this$prepareIfNeeded_u24lambda_u2d16.surface);
                }
                MediaPlayer mediaPlayer4 = $this$prepareIfNeeded_u24lambda_u2d16.mp;
                if (mediaPlayer4 != null) {
                    mediaPlayer4.setDataSource($this$prepareIfNeeded_u24lambda_u2d16.getContext(), uri2);
                }
                Surface surface = $this$prepareIfNeeded_u24lambda_u2d16.surface;
                Logger.Companion.d(TAG, "prepareAsync(): uri=" + uri2 + ", surfaceValid=" + (surface != null ? Boolean.valueOf(surface.isValid()) : null));
                MediaPlayer mediaPlayer5 = $this$prepareIfNeeded_u24lambda_u2d16.mp;
                if (mediaPlayer5 != null) {
                    mediaPlayer5.prepareAsync();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                object = Result.constructor-impl((Object)unit);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block10;
            Object e2 = object = throwable;
            boolean bl = false;
            this.notifyError(-1, String.valueOf(((Throwable)e2).getLocalizedMessage()));
        }
    }

    private final void applyMute() {
        block0: {
            float vol = this.muted ? 0.0f : 1.0f;
            MediaPlayer mediaPlayer = this.mp;
            if (mediaPlayer == null) break block0;
            mediaPlayer.setVolume(vol, vol);
        }
    }

    private final void notifyPlay() {
        block0: {
            this.beginProgressUpdates();
            NativeVideoContract.VideoLifecycleCallback videoLifecycleCallback = this.callback;
            if (videoLifecycleCallback == null) break block0;
            videoLifecycleCallback.onVideoPlay();
        }
    }

    private final void notifyPause() {
        block0: {
            this.endProgressUpdates();
            NativeVideoContract.VideoLifecycleCallback videoLifecycleCallback = this.callback;
            if (videoLifecycleCallback == null) break block0;
            videoLifecycleCallback.onVideoPause();
        }
    }

    private final void notifyCompleted() {
        block0: {
            NativeVideoContract.VideoLifecycleCallback videoLifecycleCallback = this.callback;
            if (videoLifecycleCallback == null) break block0;
            videoLifecycleCallback.onVideoCompleted();
        }
    }

    private final void notifyMuted(boolean muted) {
        block0: {
            NativeVideoContract.VideoLifecycleCallback videoLifecycleCallback = this.callback;
            if (videoLifecycleCallback == null) break block0;
            videoLifecycleCallback.onVideoMuted(muted);
        }
    }

    private final void notifyError(int what, String extra) {
        block0: {
            NativeVideoContract.VideoLifecycleCallback videoLifecycleCallback = this.callback;
            if (videoLifecycleCallback == null) break block0;
            videoLifecycleCallback.onVideoError(what, extra);
        }
    }

    private final void notifyProgress(int percentage) {
        block0: {
            NativeVideoContract.VideoLifecycleCallback videoLifecycleCallback = this.callback;
            if (videoLifecycleCallback == null) break block0;
            videoLifecycleCallback.onVideoProgress(percentage);
        }
    }

    private final void calculateAndNotifyProgress() {
        long pos;
        int percent;
        int dur = this.durationMs;
        if (dur > 0 && this.prepared.get() && (percent = RangesKt.coerceIn((int)((int)((pos = (long)this.getCurrentPositionMs()) * (long)100 / (long)dur)), (int)0, (int)100)) != this.lastProgressSent) {
            this.lastProgressSent = percent;
            this.notifyProgress(percent);
        }
    }

    private final void beginProgressUpdates() {
        this.handler.removeCallbacks((Runnable)this.progressUpdater);
        this.handler.post((Runnable)this.progressUpdater);
    }

    private final void endProgressUpdates() {
        this.handler.removeCallbacks((Runnable)this.progressUpdater);
        this.calculateAndNotifyProgress();
    }

    public void onSurfaceTextureAvailable(@NotNull SurfaceTexture st, int width, int height) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)st, (String)"st");
        Surface surface = this.surface;
        if (surface != null) {
            surface.release();
        }
        this.surface = new Surface(st);
        Object object2 = this;
        try {
            Unit unit;
            AdVideoView $this$onSurfaceTextureAvailable_u24lambda_u2d18 = object2;
            boolean bl = false;
            MediaPlayer mediaPlayer = $this$onSurfaceTextureAvailable_u24lambda_u2d18.mp;
            if (mediaPlayer != null) {
                mediaPlayer.setSurface($this$onSurfaceTextureAvailable_u24lambda_u2d18.surface);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            object = Result.constructor-impl(unit);
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object it = object = throwable;
            boolean bl = false;
            Logger.Companion.e(TAG, "Failed to set surface", (Throwable)it);
        }
        boolean surfaceRet = Result.isSuccess-impl((Object)object2);
        Logger.Companion.d(TAG, "onSurfaceTextureAvailable(): " + width + " x " + height + ", prepared=" + this.prepared + ", wantPlay=" + this.wantPlay + ", surfaceRet=" + surfaceRet);
        if (surfaceRet && this.prepared.get() && this.wantPlay) {
            Logger.Companion.d(TAG, "onSurfaceTextureAvailable and videoCompleted=" + this.videoCompleted);
            if (!this.videoCompleted) {
                MediaPlayer mediaPlayer = this.mp;
                if (mediaPlayer != null) {
                    mediaPlayer.start();
                }
                this.notifyPlay();
            } else {
                this.seekTo(this.durationMs);
                MediaPlayer mediaPlayer = this.mp;
                if (mediaPlayer != null) {
                    mediaPlayer.start();
                }
                MediaPlayer mediaPlayer2 = this.mp;
                if (mediaPlayer2 != null) {
                    mediaPlayer2.pause();
                }
            }
        } else {
            this.prepareIfNeeded();
        }
        this.applyTransform();
    }

    public void onSurfaceTextureSizeChanged(@NotNull SurfaceTexture st, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)st, (String)"st");
        Logger.Companion.d(TAG, "onSurfaceTextureSizeChanged() width=" + width + " height=" + height);
        this.applyTransform();
    }

    public boolean onSurfaceTextureDestroyed(@NotNull SurfaceTexture st) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)st, (String)"st");
        Logger.Companion.d(TAG, "onSurfaceTextureDestroyed()");
        this.pauseInternal();
        Object object2 = this;
        try {
            Unit unit;
            AdVideoView $this$onSurfaceTextureDestroyed_u24lambda_u2d20 = object2;
            boolean bl = false;
            MediaPlayer mediaPlayer = $this$onSurfaceTextureDestroyed_u24lambda_u2d20.mp;
            if (mediaPlayer != null) {
                mediaPlayer.setSurface(null);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            object = Result.constructor-impl((Object)unit);
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object it = object = throwable;
            boolean bl = false;
            Logger.Companion.e(TAG, "Failed to clear surface", (Throwable)it);
        }
        this.detachSurface();
        this.endProgressUpdates();
        return true;
    }

    public void onSurfaceTextureUpdated(@NotNull SurfaceTexture st) {
        Intrinsics.checkNotNullParameter((Object)st, (String)"st");
    }

    private final void detachSurface() {
        Surface surface = this.surface;
        if (surface != null) {
            surface.release();
        }
        this.surface = null;
    }

    private final void applyTransform() {
        block2: {
            if (this.videoW <= 0 || this.videoH <= 0) {
                return;
            }
            int vw = this.texture.getWidth();
            int vh = this.texture.getHeight();
            if (vw == 0 || vh == 0) {
                return;
            }
            float viewRatio = (float)vw / (float)vh;
            float videoRatio = (float)this.videoW / (float)this.videoH;
            Matrix matrix = new Matrix();
            float scale = viewRatio > videoRatio ? (float)vh / (float)this.videoH : (float)vw / (float)this.videoW;
            float sx = (float)this.videoW * scale / (float)vw;
            float sy = (float)this.videoH * scale / (float)vh;
            matrix.setScale(sx, sy, (float)vw / 2.0f, (float)vh / 2.0f);
            this.texture.setTransform(matrix);
            this.texture.invalidate();
            float displayW = (float)this.videoW * scale;
            float displayH = (float)this.videoH * scale;
            float left = ((float)vw - displayW) / 2.0f;
            float top = ((float)vh - displayH) / 2.0f;
            VideoTransformCallback videoTransformCallback = this.videoTransformCallback;
            if (videoTransformCallback == null) break block2;
            videoTransformCallback.onVideoTransformed(this.texture.getX() + left, this.texture.getY() + top);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void checkVisibility() {
        if (!this.autoVisibility) {
            return;
        }
        boolean enough = this.isVisibleEnough();
        if (enough && this.wantPlay && !this.videoPaused) {
            if (this.prepared.get()) {
                Surface surface = this.surface;
                boolean bl = surface != null ? surface.isValid() : false;
                if (bl) {
                    MediaPlayer mediaPlayer = this.mp;
                    if (mediaPlayer != null ? mediaPlayer.isPlaying() : false) return;
                    if (this.videoCompleted) return;
                    MediaPlayer mediaPlayer2 = this.mp;
                    Logger.Companion.d(TAG, "auto-resume: visibility OK, start() at pos=" + (mediaPlayer2 != null ? Integer.valueOf(mediaPlayer2.getCurrentPosition()) : null) + " ms");
                    MediaPlayer mediaPlayer3 = this.mp;
                    if (mediaPlayer3 != null) {
                        mediaPlayer3.start();
                    }
                    this.notifyPlay();
                    return;
                }
            }
            this.prepareIfNeeded();
            return;
        }
        if (!this.prepared.get()) return;
        MediaPlayer mediaPlayer = this.mp;
        if (!(mediaPlayer != null ? mediaPlayer.isPlaying() : false)) return;
        Logger.Companion.d(TAG, "auto-pause: visibility NOT enough");
        this.pauseInternal();
    }

    private final boolean isVisibleEnough() {
        if (!this.isShown()) {
            return false;
        }
        Rect clipRect = new Rect();
        if (!this.getGlobalVisibleRect(clipRect)) {
            return false;
        }
        long visibleViewArea = (long)clipRect.height() * (long)clipRect.width();
        long totalViewArea = (long)this.getHeight() * (long)this.getWidth();
        if (totalViewArea <= 0L) {
            return false;
        }
        float ratio = (float)visibleViewArea / (float)totalViewArea;
        return ratio >= this.visibilityThreshold;
    }

    @JvmOverloads
    public AdVideoView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 2, null);
    }

    private static final void scrollListener$lambda-0(AdVideoView this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.checkVisibility();
    }

    private static final void layoutListener$lambda-1(AdVideoView this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.checkVisibility();
    }

    private static final void ensurePlayer$lambda-14$lambda-10(AdVideoView this$0, MediaPlayer player) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        NativeVideoContract.VideoLifecycleCallback videoLifecycleCallback = this$0.callback;
        if (videoLifecycleCallback != null) {
            videoLifecycleCallback.onVideoPrepared();
        }
        this$0.durationMs = player.getDuration();
        this$0.preparing.set(false);
        this$0.prepared.set(true);
        if (this$0.lastPosMs > 0) {
            player.seekTo(this$0.lastPosMs);
        }
        this$0.applyMute();
        Logger.Companion.d(TAG, "onPrepared(): duration=" + this$0.durationMs + " ms lastPos=" + this$0.lastPosMs + " wantPlay=" + this$0.wantPlay);
        if (this$0.wantPlay) {
            Surface surface = this$0.surface;
            boolean bl = surface != null ? surface.isValid() : false;
            if (bl) {
                Logger.Companion.d(TAG, "start video on prepared.");
                player.start();
                this$0.notifyPlay();
            }
        }
    }

    private static final void ensurePlayer$lambda-14$lambda-11(AdVideoView this$0, MediaPlayer mediaPlayer, int w, int h2) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (w > 0 && h2 > 0) {
            this$0.videoW = w;
            this$0.videoH = h2;
            SurfaceTexture surfaceTexture = this$0.texture.getSurfaceTexture();
            if (surfaceTexture != null) {
                surfaceTexture.setDefaultBufferSize(w, h2);
            }
            this$0.applyTransform();
        }
    }

    private static final void ensurePlayer$lambda-14$lambda-12(AdVideoView this$0, MediaPlayer it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Logger.Companion.d(TAG, "onCompletion()");
        this$0.lastPosMs = this$0.durationMs;
        this$0.videoCompleted = true;
        this$0.endProgressUpdates();
        this$0.lastProgressSent = 100;
        this$0.notifyProgress(100);
        this$0.notifyCompleted();
    }

    private static final boolean ensurePlayer$lambda-14$lambda-13(AdVideoView this$0, MediaPlayer mediaPlayer, int what, int extra) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Logger.Companion.w(TAG, "onError(): what=" + what + ", extra=" + extra);
        this$0.preparing.set(false);
        this$0.prepared.set(false);
        this$0.notifyError(what, String.valueOf(extra));
        return true;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/vungle/ads/internal/ui/view/AdVideoView$Companion;", "", "()V", "ERROR_VIDEO_PLAYBACK_FAILED", "", "ERROR_VIDEO_PREPARE_FAILED", "PROGRESS_INTERVAL_MS", "", "TAG", "", "vungle-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&\u00a8\u0006\u0007"}, d2={"Lcom/vungle/ads/internal/ui/view/AdVideoView$VideoTransformCallback;", "", "onVideoTransformed", "", "left", "", "top", "vungle-ads_release"})
    public static interface VideoTransformCallback {
        public void onVideoTransformed(float var1, float var2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0016R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00030\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/vungle/ads/internal/ui/view/AdVideoView$ProgressUpdateRunnable;", "Ljava/lang/Runnable;", "adVideoView", "Lcom/vungle/ads/internal/ui/view/AdVideoView;", "(Lcom/vungle/ads/internal/ui/view/AdVideoView;)V", "weakRef", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "run", "", "vungle-ads_release"})
    private static final class ProgressUpdateRunnable
    implements Runnable {
        @NotNull
        private final WeakReference<AdVideoView> weakRef;

        public ProgressUpdateRunnable(@NotNull AdVideoView adVideoView) {
            Intrinsics.checkNotNullParameter((Object)((Object)adVideoView), (String)"adVideoView");
            this.weakRef = new WeakReference<AdVideoView>(adVideoView);
        }

        @Override
        public void run() {
            AdVideoView adVideoView = (AdVideoView)((Object)this.weakRef.get());
            if (adVideoView == null) {
                return;
            }
            AdVideoView videoView = adVideoView;
            videoView.calculateAndNotifyProgress();
            if (videoView.prepared.get()) {
                MediaPlayer mediaPlayer = videoView.mp;
                boolean bl = mediaPlayer != null ? mediaPlayer.isPlaying() : false;
                if (bl && !videoView.videoCompleted) {
                    videoView.handler.postDelayed((Runnable)this, 1000L);
                }
            }
        }
    }
}

